/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.dimension.IProviderFreeze;
import asmodeuscore.api.item.IItemSpaceFood;
import asmodeuscore.core.event.PressureEvent;
import asmodeuscore.core.event.RadiationEvent;
import asmodeuscore.core.handler.LightningStormHandler;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.core.GSBlocks;
import galaxyspace.core.GSItems;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.configs.GSConfigSchematics;
import galaxyspace.core.events.SetBlockEvent;
import galaxyspace.core.events.UpdateBlockEvent;
import galaxyspace.core.handler.capabilities.GSCapabilityProviderStats;
import galaxyspace.core.handler.capabilities.GSCapabilityProviderStatsClient;
import galaxyspace.core.handler.capabilities.GSCapabilityStatsHandler;
import galaxyspace.core.handler.capabilities.GSStatsCapability;
import galaxyspace.core.handler.capabilities.StatsCapability;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.prefab.entities.EntityAstroWolf;
import galaxyspace.core.prefab.items.rockets.ItemTier4Rocket;
import galaxyspace.core.prefab.items.rockets.ItemTier5Rocket;
import galaxyspace.core.prefab.items.rockets.ItemTier6Rocket;
import galaxyspace.core.util.GSDamageSource;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigCore;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigDimensions;
import galaxyspace.systems.BarnardsSystem.core.configs.BRConfigCore;
import galaxyspace.systems.BarnardsSystem.core.configs.BRConfigDimensions;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.mars.dimension.WorldProviderMars_WE;
import galaxyspace.systems.SolarSystem.planets.mars.world.MarsSaveData;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemThermalPaddingBase;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemPlasmaSword;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPlanetShield;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.ZeroGravityEvent;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.api.inventory.AccessInventoryGC;
import micdoodle8.mods.galacticraft.api.inventory.IInventoryGC;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemTier1Rocket;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.items.ItemTier2Rocket;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GSEventHandler {
    private static List<BlockToChange> block_to_change = new ArrayList<BlockToChange>();
    private static List<ItemsToChange> items_to_change = new ArrayList<ItemsToChange>();
    private static final float hot_temp = 4.0f;
    private static final float warn_temp = 2.0f;
    private static final float cool_temp = -1.2f;
    private static final float cold_temp = -2.0f;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("galaxyspace")) {
            ConfigManager.sync((String)"galaxyspace", (Config.Type)Config.Type.INSTANCE);
            GSConfigCore.config.save();
            GSConfigDimensions.config.save();
            GSConfigSchematics.config.save();
            GSConfigEnergy.config.save();
            ACConfigCore.config.save();
            ACConfigDimensions.config.save();
            BRConfigCore.config.save();
            BRConfigDimensions.config.save();
            GSConfigCore.syncConfig(true);
            GSConfigDimensions.syncConfig(true);
            GSConfigSchematics.syncConfig(true);
            GSConfigEnergy.syncConfig(true);
            ACConfigCore.syncConfig(true);
            ACConfigDimensions.syncConfig(true);
            BRConfigCore.syncConfig(true);
            BRConfigDimensions.syncConfig(true);
            GalaxySpace.debug = GSConfigCore.enableDebug;
            GalaxySpace.instance.debug("reload");
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(GSCapabilityStatsHandler.GS_PLAYER_PROPERTIES, (ICapabilityProvider)new GSCapabilityProviderStats((EntityPlayerMP)event.getObject()));
        } else if (event.getObject() instanceof EntityPlayer && ((EntityPlayer)event.getObject()).field_70170_p.field_72995_K) {
            this.onAttachCapabilityClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAttachCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerSP) {
            event.addCapability(GSCapabilityStatsHandler.GS_PLAYER_PROPERTIES_CLIENT, (ICapabilityProvider)new GSCapabilityProviderStatsClient((EntityPlayerSP)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        StatsCapability oldStats = GSStatsCapability.get((Entity)event.getOriginal());
        StatsCapability newStats = GSStatsCapability.get((Entity)event.getEntityPlayer());
        newStats.copyFrom(oldStats, !event.isWasDeath() || event.getOriginal().field_70170_p.func_82736_K().func_82766_b("keepInventory"));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        boolean flag;
        World w = e.world;
        if (!w.field_72995_K && (flag = w.func_82736_K().func_82766_b("doWeatherCycle")) && w.field_73011_w.func_186058_p() == GCPlanetDimensions.MARS) {
            int stormDust;
            MarsSaveData mars_data = MarsSaveData.get(w);
            mars_data.prevStormStrength = mars_data.stormStrength;
            if (!mars_data.isDustStorm) {
                int clearWeather;
                if ((clearWeather = mars_data.clearWeatherTime--) >= 0) {
                    if (mars_data.stormStrength > 0.0f) {
                        mars_data.stormStrength = (float)((double)mars_data.stormStrength - 0.01);
                    }
                    if (clearWeather <= 0) {
                        mars_data.isDustStorm = true;
                        mars_data.tickDustStorm = w.field_73012_v.nextInt(24000) + 12000;
                    }
                }
            } else if ((stormDust = mars_data.tickDustStorm--) >= 0) {
                mars_data.stormStrength = (float)((double)mars_data.stormStrength + 0.01);
                if (stormDust <= 0) {
                    mars_data.isDustStorm = false;
                    mars_data.clearWeatherTime = w.field_73012_v.nextInt(168000) + 12000;
                }
            }
            mars_data.stormStrength = MathHelper.func_76131_a((float)mars_data.stormStrength, (float)0.0f, (float)1.0f);
            mars_data.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onUnloadWorld(WorldEvent.Unload e) {
        if (e.getWorld().field_73011_w.func_186058_p() == GCPlanetDimensions.MARS) {
            e.getWorld().getPerWorldStorage().func_75744_a();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            StatsCapability stats = GSStatsCapability.get((Entity)event.player);
            Integer[] ids = new Integer[256];
            for (int i = 0; i < stats.getKnowledgeResearches().length; ++i) {
                ids[i] = stats.getKnowledgeResearches()[i];
            }
            GalaxySpace.packetPipeline.sendTo((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.C_UPDATE_RESEARCHES, GCCoreUtil.getDimensionID((World)event.player.field_70170_p), new Object[]{ids}), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            ItemStack chest = ((EntityPlayer)e.getEntityLiving()).func_184582_a(EntityEquipmentSlot.CHEST);
            e.setCanceled(chest != null && chest.func_77973_b() instanceof IJetpackArmor && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, (EntityPlayer)e.getEntityLiving()) && ((IJetpackArmor)chest.func_77973_b()).isActivated(chest));
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent e) {
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent e) {
        EntityPlayerMP player;
        ItemStack stack;
        if (e.getSource().func_76346_g() instanceof EntityPlayerMP && (stack = (player = (EntityPlayerMP)e.getSource().func_76346_g()).func_184614_ca()).func_77973_b() instanceof ItemPlasmaSword && stack.func_77978_p().func_74760_g(ItemPlasmaSword.heat) >= 10.0f) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.overheat")));
            e.setCanceled(true);
        }
        if (e.getEntityLiving() instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)e.getEntityLiving();
            World world = player.func_130014_f_();
            if (!world.field_72995_K) {
                float protect = 0.0f;
                for (ItemStack s : player.field_71071_by.field_70460_b) {
                    if (!(s.func_77973_b() instanceof ItemSpaceSuit) || !s.func_77942_o() || !(((ItemSpaceSuit)s.func_77973_b()).getElectricityStored(s) > 5.0f) || !s.func_77978_p().func_74764_b("protection")) continue;
                    protect += 0.1f;
                }
                e.setAmount(e.getAmount() - e.getAmount() * protect);
            }
        }
    }

    @SubscribeEvent
    public void onSetBlock(SetBlockEvent e) {
        if (e.world != null && !e.world.field_72995_K && e.world.field_73011_w instanceof IGalacticraftWorldProvider && e.pos != null && e.block != null) {
            float thermal = ((IGalacticraftWorldProvider)e.world.field_73011_w).getThermalLevelModifier();
            AxisAlignedBB bb = new AxisAlignedBB(e.pos);
            for (BlockToChange block : block_to_change) {
                if (block.only_gs_dim && !(e.world.field_73011_w instanceof IProviderFreeze) || e.world.field_73011_w instanceof IProviderFreeze && !((IProviderFreeze)e.world.field_73011_w).isFreeze()) continue;
                if (block.need_check_temp) {
                    if (e.block != block.state && e.block.func_185904_a() != block.state.func_185904_a() || OxygenUtil.isAABBInBreathableAirBlock((World)e.world, (AxisAlignedBB)bb, (boolean)true)) continue;
                    if (thermal <= -1.2f) {
                        e.world.func_175656_a(e.pos, block.cold_replaced);
                        e.setCanceled(true);
                        continue;
                    }
                    if (!(thermal >= 2.0f)) continue;
                    e.world.func_175656_a(e.pos, block.hot_replaced);
                    block.spawnParticleHotTemp(e.world, e.pos);
                    e.setCanceled(true);
                    continue;
                }
                e.world.func_175656_a(e.pos, block.cold_replaced);
                block.spawnParticleHotTemp(e.world, e.pos);
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onUpdateBlocks(UpdateBlockEvent e) {
        if (!e.world.field_72995_K && GSConfigCore.enableOxygenForPlantsAndFoods) {
            if (!e.world.func_175697_a(e.pos, 1)) {
                return;
            }
            if (e.world.field_73011_w instanceof IGalacticraftWorldProvider) {
                if (((IGalacticraftWorldProvider)e.world.field_73011_w).hasBreathableAtmosphere()) {
                    return;
                }
                if (((IGalacticraftWorldProvider)e.world.field_73011_w).getCelestialBody().atmosphere.isGasPresent(EnumAtmosphericGas.OXYGEN)) {
                    return;
                }
                AxisAlignedBB bb = new AxisAlignedBB(e.pos);
                float thermal = ((IGalacticraftWorldProvider)e.world.field_73011_w).getThermalLevelModifier();
                boolean thermal_check = thermal > 2.0f || thermal < -1.2f;
                if (!OxygenUtil.isAABBInBreathableAirBlock((World)e.world, (AxisAlignedBB)bb, (boolean)thermal_check)) {
                    if (e.block.func_177230_c() instanceof BlockLeaves) {
                        e.world.func_180501_a(e.pos, GSBlocks.DRY_LEAVES.func_176223_P(), 3);
                        e.setCanceled(true);
                    }
                    if (e.block.func_177230_c() instanceof BlockBush && e.block.func_177230_c() != Blocks.field_150330_I) {
                        if (e.world.func_180495_p(e.pos.func_177977_b()).func_185898_k()) {
                            e.world.func_180501_a(e.pos, Blocks.field_150330_I.func_176223_P(), 3);
                        } else {
                            e.world.func_175698_g(e.pos);
                        }
                        e.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_71071_by == null || event.getPos() == null || event.getPos().func_177958_n() == 0 && event.getPos().func_177956_o() == 0 && event.getPos().func_177952_p() == 0) {
            return;
        }
        World world = event.getEntityPlayer().field_70170_p;
        if (world == null) {
            return;
        }
        IBlockState state = world.func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (world.field_72995_K) {
            // empty if block
        }
        if (!world.field_72995_K && !block.hasTileEntity(state)) {
            if (CompatibilityManager.isIc2Loaded() && world.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)world.field_73011_w).hasNoAtmosphere() && ((IGalacticraftWorldProvider)world.field_73011_w).getWindLevel() <= 0.0f && stack.func_77973_b() == Item.func_111206_d((String)"ic2:te") && (stack.func_77952_i() == 11 || stack.func_77952_i() == 21)) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.nowind.name") + "! " + GCCoreUtil.translate((String)"gui.message.cant_place")));
                event.setCanceled(true);
            }
            if (block == Blocks.field_150432_aD && stack.func_77973_b() == Items.field_151133_ar) {
                stack.func_190918_g(1);
                player.field_71071_by.func_70441_a(new ItemStack(GSItems.BASIC, 1, 17));
                world.func_175698_g(event.getPos());
            }
            if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
                AxisAlignedBB bb = new AxisAlignedBB(event.getPos().func_177984_a());
                float thermal = ((IGalacticraftWorldProvider)world.field_73011_w).getThermalLevelModifier();
                for (ItemsToChange ore : items_to_change) {
                    if (!stack.func_77973_b().equals(ore.itemstack.func_77973_b()) || ((IGalacticraftWorldProvider)world.field_73011_w).hasBreathableAtmosphere()) continue;
                    if (FluidUtil.isFilledContainer((ItemStack)stack) && world.func_175625_s(event.getPos()) != null && (world.func_175625_s(event.getPos()) instanceof IFluidHandlerWrapper || world.func_175625_s(event.getPos()) instanceof IFluidHandler)) {
                        return;
                    }
                    if (ore.need_check_oxygen && !OxygenUtil.isAABBInBreathableAirBlock((World)world, (AxisAlignedBB)bb, (ore.need_check_temp && (thermal > 2.0f || thermal < -2.0f) ? 1 : 0) != 0)) {
                        player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needoxygen")));
                        event.setCanceled(true);
                    }
                    if (ore.need_check_temp && !GSUtils.getThermalControl(world, event.getPos().func_177984_a()) && (thermal > 2.0f || thermal < -2.0f)) {
                        player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needthermal")));
                        event.setCanceled(true);
                    }
                    if (ore.replaced == Blocks.field_150350_a.func_176223_P()) break;
                    if (world.func_180495_p(event.getPos()).func_177230_c().func_176200_f((IBlockAccess)world, event.getPos())) {
                        world.func_175656_a(event.getPos(), ore.replaced);
                        break;
                    }
                    world.func_175656_a(event.getPos().func_177984_a(), ore.replaced);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!event.getWorld().field_72995_K) {
            EntityWolf wolf;
            ItemStack stack = event.getItemStack();
            if (event.getTarget() instanceof EntityWolf && !(event.getTarget() instanceof EntityAstroWolf) && (wolf = (EntityWolf)event.getTarget()).func_70909_n() && event.getItemStack().func_77973_b() == GCItems.oxMask) {
                EntityAstroWolf astrowolf = new EntityAstroWolf(wolf.func_130014_f_());
                astrowolf.func_184754_b(wolf.func_184753_b());
                astrowolf.func_70903_f(wolf.func_70909_n());
                astrowolf.func_70916_h(wolf.func_70919_bu());
                astrowolf.func_70606_j(wolf.func_110143_aJ());
                astrowolf.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
                astrowolf.func_70904_g(wolf.func_70906_o());
                astrowolf.func_70080_a(wolf.field_70165_t, wolf.field_70163_u, wolf.field_70161_v, wolf.field_70177_z, wolf.field_70125_A);
                event.getTarget().func_70106_y();
                event.getWorld().func_72838_d((Entity)astrowolf);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        World world = event.getWorld();
        if (world == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack i = event.getItemStack();
        if (!world.field_72995_K && GalaxySpace.debug) {
            GalaxySpace.instance.debug(Item.field_150901_e.func_177774_c((Object)i.func_77973_b()) + " | " + i.func_77977_a() + " | " + Biome.func_150568_d((int)Biome.func_185362_a((Biome)world.getBiomeForCoordsBody(event.getPos()))));
        }
        if (!world.field_72995_K && GSConfigCore.enableOxygenForPlantsAndFoods && !player.field_71075_bZ.field_75098_d && world.field_73011_w instanceof IGalacticraftWorldProvider && !((IGalacticraftWorldProvider)world.field_73011_w).hasBreathableAtmosphere() && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player, (boolean)false) && this.checkFood(i)) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needoxygen.food")));
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setCanceled(true);
        }
    }

    private boolean checkFood(ItemStack s) {
        return !s.func_190926_b() && s.func_77973_b() instanceof ItemFood && !(s.func_77973_b() instanceof micdoodle8.mods.galacticraft.core.items.ItemFood) && !(s.func_77973_b() instanceof IItemSpaceFood);
    }

    @SubscribeEvent
    public void onPortalCreated(BlockEvent.PortalSpawnEvent e) {
        World world = e.getWorld();
        if (world != null && world.field_73011_w instanceof IGalacticraftWorldProvider) {
            e.setCanceled(!((IGalacticraftWorldProvider)world.field_73011_w).netherPortalsOperational());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        EntityLivingBase living = event.getEntityLiving();
        World world = living.field_70170_p;
        if (living instanceof EntityPlayer) {
            ItemStack held;
            player = (EntityPlayer)living;
            ItemStack chest = ((EntityPlayer)living).func_184582_a(EntityEquipmentSlot.CHEST);
            if (chest != null && chest.func_77973_b() instanceof IJetpackArmor && !((EntityPlayer)living).field_70122_E && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, (EntityPlayer)living) && ((IJetpackArmor)chest.func_77973_b()).isActivated(chest) && ((EntityPlayer)living).field_70163_u < 256.0) {
                ((EntityPlayer)living).field_70143_R = 0.0f;
                ((EntityPlayer)living).field_70140_Q = 0.6f;
                GalaxySpace.proxy.resetPlayerInAirTime((EntityPlayer)living);
                ((IJetpackArmor)chest.func_77973_b()).decrementFuel(chest);
            }
            if (!player.field_71075_bZ.field_75098_d && ((held = player.func_184614_ca()).func_77973_b() instanceof ItemTier1Rocket || held.func_77973_b() instanceof ItemTier2Rocket || held.func_77973_b() instanceof ItemTier3Rocket || held.func_77973_b() instanceof ItemTier4Rocket || held.func_77973_b() instanceof ItemTier5Rocket || held.func_77973_b() instanceof ItemTier6Rocket)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 4));
            }
        }
        if (living instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)living;
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            StatsCapability gsstats = GSStatsCapability.get((Entity)player);
            LightningStormHandler.spawnLightning((EntityPlayerMP)player);
            if (!world.field_72995_K && world.func_82737_E() % 20L == 0L && world.field_73011_w.func_186058_p() == GCPlanetDimensions.MARS) {
                MarsSaveData msd = MarsSaveData.get(world);
                GalaxySpace.packetPipeline.sendTo((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.C_UPDATE_MSD_USER, world, new Object[]{msd.isDustStorm, msd.tickDustStorm, msd.clearWeatherTime, Float.valueOf(msd.prevStormStrength), Float.valueOf(msd.stormStrength)}), (EntityPlayerMP)player);
                if (msd.isDustStorm) {
                    boolean flag = true;
                    for (int y = 256; y > player.func_180425_c().func_177956_o(); --y) {
                        if (world.func_175623_d(new BlockPos(player.func_180425_c().func_177958_n(), y, player.func_180425_c().func_177952_p()))) continue;
                        flag = false;
                        break;
                    }
                    if (flag) {
                        player.func_70097_a(DamageSource.field_76367_g, 0.5f);
                    }
                }
            }
            if (world.func_82737_E() % 15L == 0L) {
                if (!GSEventHandler.getProtectArmor((EntityPlayerMP)player) && world.field_73011_w instanceof WorldProviderTitan && world.func_72896_J()) {
                    boolean flag = true;
                    for (int y = 256; y > player.func_180425_c().func_177956_o(); --y) {
                        if (world.func_175623_d(new BlockPos(player.func_180425_c().func_177958_n(), y, player.func_180425_c().func_177952_p()))) continue;
                        flag = false;
                        break;
                    }
                    if (flag) {
                        player.func_70097_a((DamageSource)GSDamageSource.acid, 0.5f);
                    }
                }
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderKuiperBelt && player.field_70163_u <= -20.0) {
                player.field_71135_a.func_147364_a(player.field_70165_t, 188.0, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            }
            if (!player.field_71075_bZ.field_75098_d && player.func_110143_aJ() <= 5.0f) {
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    int[] pos;
                    if (stack.func_77973_b() != GSItems.BASIC || stack.func_77952_i() != 18) continue;
                    if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("turnonoff") || (pos = stack.func_77978_p().func_74759_k("position")) == null || pos.length < 3 || player.field_70170_p.field_73011_w.getDimension() != pos[3]) break;
                    player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.AQUA + GCCoreUtil.translateWithFormat((String)"gui.message.emergency_teleport", (Object[])new Object[0]) + " x:" + pos[0] + " y:" + pos[1] + " z:" + pos[2]));
                    player.field_71135_a.func_147364_a((double)pos[0], (double)pos[1], (double)pos[2], player.field_70177_z, player.field_70125_A);
                    stack.func_190918_g(1);
                    break;
                }
            }
            if (stats.getShieldControllerInSlot().func_77969_a(new ItemStack(GSItems.BASIC, 1, 16))) {
                ItemStack shield = stats.getShieldControllerInSlot();
                if (shield.func_77942_o()) {
                    int shieldtime = shield.func_77978_p().func_74762_e("shieldtime");
                    if (!player.field_71075_bZ.field_75098_d && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getCelestialBody().atmosphere.isCorrosive()) {
                        if (shieldtime >= 1) {
                            if (player.field_70173_aa % 20 == 0) {
                                shield.func_77978_p().func_74768_a("shieldtime", --shieldtime);
                            }
                        } else {
                            shield.func_190918_g(1);
                            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translateWithFormat((String)"gui.message.now_noshield", (Object[])new Object[0])));
                        }
                    }
                } else {
                    shield.func_77982_d(new NBTTagCompound());
                    shield.func_77978_p().func_74768_a("shieldtime", 600);
                }
                int gearID = GalacticraftRegistry.findMatchingGearID((ItemStack)stats.getShieldControllerInSlot(), (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER);
                if (gearID >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket((EntityPlayerMP)player, (GCPlayerHandler.EnumModelPacketType)GCPlayerHandler.EnumModelPacketType.ADD, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER, (int)gearID);
                }
            }
            ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
            IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSpaceSuit && player.func_70090_H() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("water_breathing")) {
                int count = 300;
                int air = player.func_70086_ai();
                for (int i = 2; i <= 3; ++i) {
                    if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77952_i() == inv.func_70301_a(i).func_77958_k()) continue;
                    if (air >= count) break;
                    player.func_70050_g(count);
                    if (inv.func_70301_a(i).func_77973_b() == GCItems.oxygenCanisterInfinite) break;
                    inv.func_70301_a(i).func_77964_b(inv.func_70301_a(i).func_77952_i() + 1);
                    break;
                }
            }
            if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player) || player.field_70170_p.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
                for (int i = 2; i <= 3; ++i) {
                    ItemStack tank;
                    if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77973_b() != GSItems.OXYGENTANK_TIER_EPP && (!inv.func_70301_a(i).func_77942_o() || !inv.func_70301_a(i).func_77978_p().func_74764_b("epp")) || (tank = inv.func_70301_a(i)).func_77952_i() == 0 || player.field_70173_aa % 10 != 0) continue;
                    tank.func_77964_b(tank.func_77952_i() - 2);
                }
            }
        }
    }

    public static void consumeOxygenFromTank(EntityPlayerMP player, int consume_count) {
        IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
        for (int i = 2; i <= 3; ++i) {
            ItemStack tank;
            if (inv.func_70301_a(i).func_190926_b() || (tank = inv.func_70301_a(i)).func_77952_i() == tank.func_77958_k()) continue;
            if (player.field_70173_aa % 10 != 0) break;
            tank.func_77964_b(tank.func_77952_i() + consume_count);
            break;
        }
    }

    public static boolean isValidOxygenTanks(EntityPlayerMP player) {
        boolean valid = false;
        IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
        for (int i = 2; i <= 3; ++i) {
            ItemStack tank;
            if (inv.func_70301_a(i).func_190926_b() || (tank = inv.func_70301_a(i)).func_77952_i() == tank.func_77958_k()) continue;
            valid = true;
            break;
        }
        return valid;
    }

    @SubscribeEvent
    public void onThermalArmorEvent(GCPlayerHandler.ThermalArmorEvent event) {
        if (event.armorStack == ItemStack.field_190927_a) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.REMOVE);
            return;
        }
        if (event.armorStack.func_77973_b() instanceof ItemThermalPaddingBase && event.armorStack.func_77952_i() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.NOTHING);
    }

    @SubscribeEvent
    public void onPlanetDecorated(GCCoreEventPopulate.Post event) {
        if (GSConfigCore.enableMarsNewOres && (event.world.field_73011_w instanceof WorldProviderMars || event.world.field_73011_w instanceof WorldProviderMars_WE)) {
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 4, 0, true, MarsBlocks.marsBlock, 9), 6, 4, 18);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 6, 1, true, MarsBlocks.marsBlock, 9), 10, 6, 30);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 16, 2, true, MarsBlocks.marsBlock, 9), 15, 6, 70);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 10, 3, true, MarsBlocks.marsBlock, 9), 10, 6, 20);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 8, 4, true, MarsBlocks.marsBlock, 9), 4, 6, 20);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 6, 5, true, MarsBlocks.marsBlock, 9), 16, 6, 45);
        }
    }

    void genOre(World world, BlockPos pos, WorldGenerator wg, int amountPerChunk, int minY, int maxY) {
        BlockPos pos1 = pos.func_177982_a(world.field_73012_v.nextInt(16), world.field_73012_v.nextInt(maxY - minY) + minY, world.field_73012_v.nextInt(16));
        for (int i = 0; i < amountPerChunk; ++i) {
            wg.func_180709_b(world, world.field_73012_v, pos1);
        }
    }

    @SubscribeEvent
    public void onZeroGravity(ZeroGravityEvent.InFreefall event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (GSEventHandler.inGravityZone(entity.func_130014_f_(), entity, false)) {
            event.setCanceled(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public void onRadiation(RadiationEvent event) {
        block3: {
            living = (EntityLivingBase)event.getEntity();
            if (!(living instanceof EntityPlayerMP)) break block3;
            player = (EntityPlayerMP)living;
            checkAirLock = false;
            for (y = 0; y < 255; ++y) {
                if (player.field_70170_p.func_180495_p(player.func_180425_c().func_177981_b(y)).func_177230_c() != GCBlocks.airLockSeal) continue;
                checkAirLock = true;
                break;
            }
            if (player.field_71075_bZ.field_75098_d) break block3;
            if (checkAirLock || !GSConfigCore.enableRadiationSystem) ** GOTO lbl-1000
            if (GSEventHandler.getProtectArmor(player) || player.func_184187_bx() instanceof EntityLanderBase || player.func_184187_bx() instanceof EntityTieredRocket) ** GOTO lbl-1000
            if (GSEventHandler.inRadiationBubble(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v)) lbl-1000:
            // 3 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            event.setCanceled(v0);
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public void onPressure(PressureEvent event) {
        block2: {
            living = (EntityLivingBase)event.getEntity();
            if (!(living instanceof EntityPlayerMP)) break block2;
            player = (EntityPlayerMP)living;
            world = player.func_130014_f_();
            level = event.getPressureLevel();
            if (player.field_71075_bZ.field_75098_d) break block2;
            if (!GSConfigCore.enablePressureSystem) ** GOTO lbl-1000
            if (GSEventHandler.getProtectArmor(player)) ** GOTO lbl-1000
            if (GSEventHandler.inGravityZone(world, (EntityLivingBase)player, true) || player.func_184187_bx() instanceof EntityLanderBase || player.func_184187_bx() instanceof EntityTieredRocket) lbl-1000:
            // 3 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            event.setCanceled(v0);
        }
    }

    public static boolean getProtectArmor(EntityPlayerMP player) {
        boolean[] check = new boolean[4];
        for (String string : GSConfigCore.radiation_armor) {
            int i;
            String[] meta = string.split(":");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (meta.length > 2) {
                for (i = 0; i <= 3; ++i) {
                    ItemStack itemstack = new ItemStack(item, 1, Integer.parseInt(meta[2]));
                    boolean bl = check[i] = !((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() && player.field_71071_by.field_70460_b.get(i) == itemstack;
                    if (!check[i]) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i <= 3; ++i) {
                    boolean bl = check[i] = !((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() == item;
                    if (!check[i]) {
                        continue;
                    }
                    break;
                }
            }
            if (check[0] && check[1] && check[2] && check[3]) break;
        }
        return check[0] && check[1] && check[2] && check[3];
    }

    public static boolean inGravityZone(World world, EntityLivingBase player, boolean checkStabilisationModule) {
        for (BlockVec3Dim blockVec : TileEntityGravitationModule.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.getDimension() || !((tile = world.func_175625_s(blockVec.toBlockPos())) instanceof TileEntityGravitationModule)) continue;
            TileEntityGravitationModule gravity = (TileEntityGravitationModule)tile;
            if (gravity.disabled || !gravity.hasEnoughEnergyToRun || !gravity.inGravityZone(world, player)) continue;
            if (!checkStabilisationModule) {
                return true;
            }
            if (!checkStabilisationModule) continue;
            for (int i = 0; i < 4; ++i) {
                if (!gravity.func_70301_a(i + 1).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 1))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean inRadiationBubble(World world, double avgX, double avgY, double avgZ) {
        for (BlockVec3Dim blockVec : TileEntityRadiationStabiliser.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.getDimension() || !((tile = world.func_175625_s(blockVec.toBlockPos())) instanceof TileEntityRadiationStabiliser) || !((TileEntityRadiationStabiliser)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }

    public static boolean inShieldBubble(World world, double avgX, double avgY, double avgZ) {
        for (BlockVec3Dim blockVec : TileEntityPlanetShield.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.getDimension() || !((tile = world.func_175625_s(blockVec.toBlockPos())) instanceof TileEntityPlanetShield) || !((TileEntityPlanetShield)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeItemStack(IInventory inventory, ItemStack stack) {
        if (GSEventHandler.getAmount(inventory, stack) >= stack.func_190916_E()) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!GSEventHandler.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
                int amount = Math.min(stack.func_190916_E(), inventory.func_70301_a(i).func_190916_E());
                if (amount > 0) {
                    inventory.func_70301_a(i).func_190918_g(amount);
                    if (inventory.func_70301_a(i).func_190916_E() <= 0) {
                        inventory.func_70299_a(i, ItemStack.field_190927_a);
                    }
                    stack.func_190918_g(amount);
                }
                if (stack.func_190916_E() > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getAmount(IInventory inventory, ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!GSEventHandler.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
            amount += inventory.func_70301_a(i).func_190916_E();
        }
        return amount;
    }

    public static boolean isItemStackEqual(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == stack2.func_77952_i() || stack2.func_77952_i() == Short.MAX_VALUE);
    }

    protected void updateSchematics(EntityPlayerMP player, GCPlayerStats playerStats) {
    }

    public static void enableFlight(EntityPlayer player, boolean state) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chest != null && chest.func_77973_b() instanceof IJetpackArmor) {
            ((IJetpackArmor)chest.func_77973_b()).switchState(chest, state);
        }
    }

    protected void throwMeteors(EntityPlayerMP player) {
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof IAdvancedSpace && !world.field_72995_K && ((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() > 0.0 && ConfigManagerCore.meteorSpawnMod > 0.0) {
            EntityPlayer closestPlayer;
            boolean f = true;
            if (world.field_73012_v.nextInt(1) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                int x = world.field_73012_v.nextInt(1) - 4;
                int y = world.field_73012_v.nextInt(20) + 200;
                int z = world.field_73012_v.nextInt(1) - 4;
                double motX = world.field_73012_v.nextDouble() * 1.0;
                double motZ = world.field_73012_v.nextDouble() * 1.0;
                EntityMeteor meteor = new EntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 0.5, 0.0, motZ - 0.5, 1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
        }
    }

    static {
        items_to_change.add(new ItemsToChange(new ItemStack(Blocks.field_150460_al), Blocks.field_150350_a.func_176223_P()).setOxygenCheck(true));
        block_to_change.add(new BlockToChange(Blocks.field_150355_j.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), 0.0f, true).setParticle("waterbubbles").setOxygenCheck(false));
    }

    private static class ItemsToChange {
        private ItemStack itemstack = ItemStack.field_190927_a;
        private IBlockState replaced;
        private boolean need_check_temp;
        private boolean need_check_oxygen;
        private boolean only_gs_dim = false;

        ItemsToChange(ItemStack stack, IBlockState placed) {
            this.itemstack = stack;
            this.replaced = placed;
        }

        public ItemsToChange setOnlyGSDim() {
            this.only_gs_dim = true;
            return this;
        }

        public ItemsToChange setOxygenCheck(boolean check) {
            this.need_check_oxygen = check;
            return this;
        }

        public ItemsToChange setTempCheck(boolean check) {
            this.need_check_temp = check;
            return this;
        }
    }

    private static class BlockToChange {
        private IBlockState state;
        private IBlockState hot_replaced;
        private IBlockState cold_replaced;
        private float temp;
        private boolean need_check_temp;
        private boolean need_check_oxygen;
        private boolean only_gs_dim = false;
        private String particle_name = "";

        BlockToChange(IBlockState state, IBlockState hot_replaced, IBlockState cold_replaced, float temp, boolean need_check_temp) {
            this.state = state;
            this.hot_replaced = hot_replaced;
            this.cold_replaced = cold_replaced;
            this.temp = temp;
            this.need_check_temp = need_check_temp;
        }

        public BlockToChange setParticle(String s) {
            this.particle_name = s;
            return this;
        }

        public BlockToChange setOnlyGSDim() {
            this.only_gs_dim = true;
            return this;
        }

        public BlockToChange setOxygenCheck(boolean check) {
            this.need_check_oxygen = check;
            return this;
        }

        void spawnParticleHotTemp(World world, BlockPos pos) {
            if (!this.particle_name.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    GalaxySpace.proxy.spawnParticle(this.particle_name, new Vector3((double)pos.func_177958_n() + world.field_73012_v.nextDouble(), (double)pos.func_177956_o() + 1.0 + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + world.field_73012_v.nextDouble()), new Vector3(0.0, 0.001, 0.0), new Object[]{10, 5, false, new Vector3(1.0, 1.0, 1.0), 1.0});
                }
            }
        }
    }
}

