/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview;

import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pregenerator.ConfigManager;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.gui.GuiSlider;
import pregenerator.base.impl.misc.PregenEvent;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.client.preview.GuiKeepWorld;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.MapManager;
import pregenerator.impl.client.preview.data.SubProcessor;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.CustomServer;
import pregenerator.impl.client.preview.world.WorldInstance;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.storage.TaskStorage;

public class GuiSeedPreview
extends GuiPregenBase
implements GuiSlider.ISlider {
    public static final Color SLIME_COLOR = new Color(0, 255, 255, 128);
    public static final DecimalFormat BIG_FORMAT = new DecimalFormat("###,###");
    WorldSeed seed;
    Map<Integer, WorldInstance> dimensions = new ConcurrentHashMap<Integer, WorldInstance>();
    SelectionList<Integer> allDimensions = new SelectionList();
    SelectionList<String> mapViews = new SelectionList<String>(Arrays.asList("Block Colors", "Biome(Foliage) Colors", "Biome(Grass) Colors"));
    GuiTextField seedName;
    boolean terrainOnly = true;
    boolean slimeChunks = false;
    boolean structures = false;
    public MapManager mapData = new MapManager();
    SubProcessor processor = new SubProcessor();
    CustomServer fakeServer = null;
    MoveableTexture displayTexture = new MoveableTexture(3200);
    int oldScale;
    int newScale = -1;
    FilePos lastPos = null;
    boolean dragging = false;
    float scale = 0.2f;
    int globalRadius = 100;
    boolean globalSquare = true;
    boolean keepWorld = false;
    boolean pregenRuns = false;

    public GuiSeedPreview(GuiCreateWorld gui) {
        this.seed = new WorldSeed(gui);
        this.seed.removePreview(false);
        this.seed.createPaths();
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        set.addAll(ConfigManager.getDimensions());
        if (!ConfigManager.orderOnly) {
            set.addAll(Arrays.asList(DimensionManager.getStaticDimensionIDs()));
        }
        this.allDimensions.addValues(new ArrayList(set));
        this.oldScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        this.onReopening();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void onReopening() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.displayTexture.createTextureIfMissing();
        this.displayTexture.centerTexture();
        if (this.newScale != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.newScale;
        }
    }

    @SubscribeEvent
    public void onChunkPreviewed(PregenEvent event) {
        Chunk chunk = event.getChunk();
        WorldInstance instance = this.dimensions.get(chunk.func_177412_p().field_73011_w.getDimension());
        if (instance == null) {
            return;
        }
        instance.addChunk(chunk);
    }

    @SubscribeEvent
    public void onChunkSaved(ChunkDataEvent.Save event) {
        Chunk chunk = event.getChunk();
        WorldInstance instance = this.dimensions.get(chunk.func_177412_p().field_73011_w.getDimension());
        if (instance == null) {
            return;
        }
        instance.addChunk(chunk);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerUnmovedButton(0, 30, 52, 79, 14, "Random");
        this.registerUnmovedButton(1, 111, 52, 79, 14, "Apply Seed");
        WorldInstance instance = this.getCurrentWorld();
        this.registerButton(new GuiSlider(3, 51, 78, 118, 14, "Radius: ", " Chunks", 1.0, 1000.0, instance != null ? (double)instance.getRadius() : (double)this.globalRadius, false, true, this).setScrollEffect(1.0));
        this.registerUnmovedButton(4, 30, 78, 20, 14, "<");
        this.registerUnmovedButton(5, 170, 78, 20, 14, ">");
        this.registerUnmovedButton(20, 30, 93, 79, 14, "Shape: Square");
        this.registerUnmovedButton(2, 111, 93, 79, 14, "Apply Size");
        this.registerUnmovedButton(6, 30, 108, 79, 14, this.terrainOnly ? "Terrain Gen" : "Full Gen");
        this.registerUnmovedButton(7, 111, 108, 79, 14, "Add Post");
        this.registerUnmovedButton(8, 30, 123, 160, 14, "Dim: " + this.allDimensions.getValue() + " (" + WorldSeed.getDimensionName(this.allDimensions.getValue()) + ")");
        this.registerUnmovedButton(9, 30, 148, 79, 14, "Start Gen");
        this.registerUnmovedButton(10, 111, 148, 79, 14, "Stop Gen");
        this.registerButton(new GuiSlider(11, 51, 163, 118, 14, "Speed: ", " ms/t", 10.0, 1000.0, ChunkProcessor.INSTANCE.getMaxTime(), false, true, this).setScrollEffect(1.0));
        this.registerUnmovedButton(12, 30, 163, 20, 14, "<");
        this.registerUnmovedButton(13, 170, 163, 20, 14, ">");
        this.registerUnmovedButton(14, 30, 189, 160, 14, "Map View: " + this.mapViews.getValue());
        this.registerUnmovedButton(15, 30, 204, 79, 14, "Slime Chunks");
        this.registerUnmovedButton(16, 111, 204, 79, 14, "Structures");
        this.registerUnmovedButton(30, 30, this.field_146295_m - 36, 79, 14, "Back");
        this.registerUnmovedButton(31, 111, this.field_146295_m - 36, 79, 14, "Keep World");
        this.registerUnmovedButton(99, 0, 0, 70, 15, "Lower Scale");
        this.registerUnmovedButton(100, this.field_146294_l - 202, 20, 20, 15, "GC");
        this.seedName = new GuiTextField(32, this.field_146297_k.field_71466_p, 31, 40, 158, 10);
        this.seedName.func_146205_d(true);
        this.seedName.func_146180_a(this.seed.getTextSeed());
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void updateButtons() {
        WorldInstance instance;
        boolean isRunning = ChunkProcessor.INSTANCE.isRunning();
        if (isRunning) {
            this.seedName.func_146195_b(false);
        }
        this.getIDButton((int)0).field_146124_l = !isRunning;
        this.getIDButton((int)1).field_146124_l = !isRunning;
        this.getIDButton((int)2).field_146124_l = !isRunning;
        this.getIDButton((int)3).field_146124_l = !isRunning;
        this.getIDButton((int)4).field_146124_l = !isRunning;
        this.getIDButton((int)5).field_146124_l = !isRunning;
        this.getIDButton((int)6).field_146124_l = !isRunning;
        this.getIDButton((int)7).field_146124_l = !isRunning;
        this.getIDButton((int)8).field_146124_l = !isRunning;
        this.getIDButton((int)9).field_146124_l = !isRunning;
        this.getIDButton((int)10).field_146124_l = isRunning;
        this.getIDButton((int)20).field_146124_l = !isRunning;
        this.getIDButton((int)30).field_146124_l = !isRunning;
        this.getIDButton((int)31).field_146124_l = !isRunning;
        this.getIDButton((int)15).field_146125_m = this.field_146295_m >= 255;
        this.getIDButton((int)16).field_146125_m = this.field_146295_m >= 255;
        boolean bl = this.getIDButton((int)99).field_146125_m = this.field_146295_m < 255;
        if (ChunkProcessor.INSTANCE.isRunning()) {
            this.pregenRuns = true;
        } else if (this.pregenRuns) {
            this.stopTask();
        }
        if (this.fakeServer == null) {
            this.createServer();
        }
        boolean shape = (instance = this.getCurrentWorld()) == null ? this.globalSquare : instance.isSquare();
        this.getIDButton((int)20).field_146126_j = "Shape: " + (shape ? "Square" : "Circle");
    }

    public void func_146281_b() {
        this.stopTask();
        if (Minecraft.func_71410_x().field_71474_y.field_74335_Z != this.oldScale) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.oldScale;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        if (!this.keepWorld) {
            this.removePreview(false);
        }
        this.displayTexture.removeTexture();
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public boolean removePreview(boolean tempOnly) {
        this.mapData.shutdown();
        this.processor.terminate();
        return this.seed.forceRemovePreview(tempOnly);
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.seedName.func_146180_a(Long.toString(new Random().nextLong()));
        } else if (id == 1) {
            this.applyChanges();
        } else if (id == 2) {
            this.applyNewSize();
        } else if (id == 4 || id == 5) {
            GuiSlider slider = (GuiSlider)this.getIDButton(3);
            int value = id == 5 ? 1 : -1;
            slider.setValue(slider.getValueInt() + (value *= GuiScreen.func_146271_m() ? 10 : 1));
            slider.updateSlider();
        } else if (id == 6) {
            this.terrainOnly = !this.terrainOnly;
            button.field_146126_j = this.terrainOnly ? "Terrain Gen" : "Full Gen";
        } else if (id == 7) {
            this.startTask(2);
        } else if (id == 8) {
            if (GuiScreen.func_146272_n()) {
                this.allDimensions.prev();
            } else {
                this.allDimensions.next();
            }
            button.field_146126_j = "Dim: " + this.allDimensions.getValue() + " (" + WorldSeed.getDimensionName(this.allDimensions.getValue()) + ")";
            this.toggleDimension();
        } else if (id == 9) {
            this.startTask(this.terrainOnly ? 0 : 1);
        } else if (id == 10) {
            this.stopTask();
        } else if (id == 12 || id == 13) {
            GuiSlider slider = (GuiSlider)this.getIDButton(11);
            int value = id == 13 ? 1 : -1;
            slider.setValue(slider.getValueInt() + (value *= GuiScreen.func_146271_m() ? 10 : 1));
            slider.updateSlider();
        } else if (id == 14) {
            if (GuiScreen.func_146272_n()) {
                this.mapViews.prev();
            } else {
                this.mapViews.next();
            }
            button.field_146126_j = "Map View: " + this.mapViews.getValue();
            this.updateTexture();
        } else if (id == 15) {
            this.slimeChunks = !this.slimeChunks;
        } else if (id == 16) {
            this.structures = !this.structures;
        } else if (id == 20) {
            WorldInstance instance = this.getCurrentWorld();
            if (instance != null) {
                instance.toggleShape();
            } else {
                this.globalSquare = !this.globalSquare;
            }
        } else if (id == 30) {
            this.field_146297_k.func_147108_a((GuiScreen)this.seed.getPrevGui());
        } else if (id == 31) {
            boolean save = true;
            for (WorldInstance instance : this.dimensions.values()) {
                if (instance.isSaveToUse()) continue;
                save = false;
            }
            this.keepWorld = true;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiKeepWorld(this, save));
            this.keepWorld = false;
        } else if (id == 99) {
            if (this.field_146295_m >= 255) {
                return;
            }
            int oldScale = this.oldScale;
            this.field_146297_k.field_71474_y.field_74335_Z = new ScaledResolution(this.field_146297_k).func_78325_e() - 1;
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            this.func_146280_a(this.field_146297_k, i, j);
            this.oldScale = oldScale;
        } else if (id == 100) {
            System.gc();
        }
    }

    @Override
    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.field_146127_k == 3) {
            this.globalRadius = slider.getValueInt();
        }
        if (slider.field_146127_k == 11) {
            ChunkProcessor.INSTANCE.setMaxTime(slider.getValueInt());
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.seedName.func_146206_l()) {
            this.seedName.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.seedName.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.seedName.func_146206_l()) {
            return;
        }
        if (this.isInFrame(mouseX, mouseY)) {
            this.dragging = true;
            this.lastPos = new FilePos(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.dragging = false;
    }

    public void applyChanges() {
        long newSeed = WorldSeed.makeSeed(this.seedName.func_146179_b());
        if (newSeed == this.seed.getSeed()) {
            return;
        }
        this.seed.setSeed(this.seedName.func_146179_b());
        if (this.fakeServer != null) {
            this.seed.destroyServer(this.fakeServer);
            this.fakeServer = null;
        }
        for (Integer value : this.dimensions.keySet()) {
            this.mapData.removeDimension(value);
        }
        this.dimensions.clear();
        this.seed.removePreview(false);
        this.displayTexture.centerTexture();
        this.displayTexture.clearTexture();
        this.updateTexture();
    }

    public void applyNewSize() {
        int radius = ((GuiSlider)this.getIDButton(3)).getValueInt();
        this.displayTexture.resizeTexture(radius * 32);
        this.displayTexture.centerTexture();
        this.updateTexture();
        WorldInstance current = this.getCurrentWorld();
        if (current != null) {
            current.setRadius(radius);
        }
    }

    public void toggleDimension() {
        for (WorldInstance instance : this.dimensions.values()) {
            instance.setFocus(this.allDimensions.getValue(), this.mapViews.getIndex());
        }
        WorldInstance instance = this.getCurrentWorld();
        if (instance != null) {
            GuiSlider slider = (GuiSlider)this.getIDButton(3);
            slider.setValue(instance.getRadius());
            slider.updateSlider();
        }
        this.displayTexture.resizeTexture(((GuiSlider)this.getIDButton(3)).getValueInt() * 32);
        this.displayTexture.centerTexture();
        this.displayTexture.clearTexture();
        this.updateTexture();
    }

    public void updateTexture() {
        WorldInstance instance = this.getCurrentWorld();
        if (instance != null) {
            instance.reload(this.mapViews.getIndex());
        }
    }

    public void createServer() {
        this.fakeServer = this.seed.createServer();
    }

    public void startServer() {
        if (this.fakeServer.func_71200_ad()) {
            return;
        }
        this.fakeServer.func_71256_s();
        while (!this.fakeServer.func_71200_ad()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public void startTask(int state) {
        if (ChunkProcessor.INSTANCE.isRunning()) {
            return;
        }
        this.startServer();
        TaskStorage.getStorage().clearAll();
        WorldInstance instance = this.getOrCreateWorld();
        ChunkProcessor.INSTANCE.startTask(instance.createTask(state).setPreview());
    }

    public void stopTask() {
        this.pregenRuns = false;
        this.seed.destroyServer(this.fakeServer);
        this.fakeServer = null;
    }

    public WorldInstance getOrCreateWorld() {
        WorldInstance instance = this.dimensions.get(this.allDimensions.getValue());
        if (instance == null) {
            instance = new WorldInstance(this.allDimensions.getValue(), this.globalSquare, this.mapData.createDimension(this.allDimensions.getValue()));
            this.dimensions.put(this.allDimensions.getValue(), instance);
            int radius = ((GuiSlider)this.getIDButton(3)).getValueInt();
            instance.setRadius(radius);
            this.displayTexture.resizeTexture(radius * 32);
            this.displayTexture.centerTexture();
        }
        return instance;
    }

    public WorldInstance getCurrentWorld() {
        return this.dimensions.get(this.allDimensions.getValue());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int effect;
        this.updateButtons();
        this.process();
        this.func_146276_q_();
        this.drawFrame();
        if (this.seedName != null) {
            this.seedName.func_146194_f();
        }
        if (this.isInFrame(mouseX, mouseY) && (effect = Mouse.getDWheel() / 120) != 0) {
            float data = 1.0f + (GuiSeedPreview.func_146272_n() ? 2.0f : 0.1f) * (float)effect;
            this.scale *= data;
            if (this.scale < 0.01f) {
                this.scale = 0.01f;
            } else if (this.scale > 60.0f) {
                this.scale = 60.0f;
            }
        }
        if (this.dragging) {
            this.displayTexture.moveTexture(-((float)(this.lastPos.x - mouseX) / this.scale), -((float)(this.lastPos.z - mouseY) / this.scale));
            this.lastPos = new FilePos(mouseX, mouseY);
        }
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        double scaleW = (double)this.field_146297_k.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.field_146297_k.field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)(200.0 * scaleW)), (int)((int)(40.0 * scaleH)), (int)((int)((double)this.field_146297_k.field_71443_c - 240.0 * scaleW)), (int)((int)((double)this.field_146297_k.field_71440_d - 80.0 * scaleH)));
        GlStateManager.func_179094_E();
        this.displayTexture.translate((float)this.centerX + 70.0f, this.centerY, this.scale);
        this.displayTexture.render(this.slimeChunks, new MoveableTexture.IRenderFunction(){

            @Override
            public void render(float x, float y, int width, int height) {
                GuiSeedPreview.this.renderTexture(x, y, width, height, GuiSeedPreview.this.field_73735_i);
            }
        });
        this.drawExtras();
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3089);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawPostFrame();
        if (!this.isInFrame(mouseX, mouseY)) {
            this.handleButtonToolTips(mouseX, mouseY);
            return;
        }
        WorldInstance data = this.getCurrentWorld();
        if (data == null) {
            return;
        }
        FilePos pos = this.getMousePosition(data.getRadius() * 16, mouseX, mouseY);
        if (pos == null) {
            return;
        }
        IChunkData chunk = data.getChunk(pos.x >> 4, pos.z >> 4);
        if (chunk == null) {
            return;
        }
        int x = pos.x & 0xF;
        int z = pos.z & 0xF;
        ArrayList<String> toDraw = new ArrayList<String>();
        toDraw.add("Position: [X=" + pos.x + ", Y=" + chunk.getHeight(x, z) + ", Z=" + pos.z + "]");
        toDraw.add("Chunk: [X=" + (pos.x >> 4) + ", Z=" + (pos.z >> 4) + "]");
        toDraw.add("Biome: " + Biome.func_180276_a((int)chunk.getBiome(x, z), (Biome)Biomes.field_76772_c).func_185359_l());
        if (chunk.isSlimeChunk()) {
            toDraw.add("Slime Chunk");
        }
        block0: for (Map.Entry<String, Set<StructureStart>> entry : data.getStructures().entrySet()) {
            String name = entry.getKey();
            for (StructureStart start : entry.getValue()) {
                int growth = name.equalsIgnoreCase("temple") ? 20 : 0;
                StructureBoundingBox box = start.func_75071_a();
                if (!start.func_75069_d() || pos.x < box.field_78897_a - growth || pos.x > box.field_78893_d + growth || pos.z < box.field_78896_c - growth || pos.z > box.field_78892_f + growth) continue;
                toDraw.add(name);
                continue block0;
            }
        }
        this.drawListText(toDraw, mouseX, mouseY);
    }

    public void process() {
        for (WorldInstance instance : this.dimensions.values()) {
            instance.update(this.mapViews.getIndex(), this.processor);
            if (!instance.isFocus()) continue;
            instance.render(this.displayTexture);
        }
    }

    public FilePos getMousePosition(int radius, int mouseX, int mouseY) {
        int posX = (int)(this.displayTexture.getX() - (float)(mouseX - (this.field_146294_l + 140) / 2) / this.scale);
        int posZ = (int)(this.displayTexture.getY() - (float)(mouseY - this.field_146295_m / 2) / this.scale);
        return posX > 0 || posZ > 0 || posX <= radius * -2 || posZ <= radius * -2 ? null : new FilePos(Math.abs(posX) - radius, Math.abs(posZ) - radius);
    }

    public void drawExtras() {
        WorldInstance data = this.getCurrentWorld();
        if (data != null) {
            GlStateManager.func_179109_b((float)((float)this.displayTexture.getWidth() / 2.0f), (float)((float)this.displayTexture.getHeight() / 2.0f), (float)0.0f);
            float offsetX = this.displayTexture.getX();
            float offsetY = this.displayTexture.getY();
            if (this.slimeChunks) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder builder = tessellator.func_178180_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_179090_x();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int color = SLIME_COLOR.getRGB();
                GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
                builder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                for (FilePos pos : data.getSlimeChunks()) {
                    float minX = (float)(pos.x * 16) + offsetX;
                    float minY = (float)(pos.z * 16) + offsetY;
                    this.drawArea(minX, minY, minX + 16.0f, minY + 16.0f, SLIME_COLOR.getRGB(), builder);
                }
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
            if (this.structures) {
                int range = data.getRadius() * 16;
                for (Map.Entry<String, Set<StructureStart>> starts : data.getStructures().entrySet()) {
                    String name = starts.getKey();
                    if (name.equalsIgnoreCase("mineshaft") && !GuiScreen.func_146272_n()) continue;
                    int color = Integer.MIN_VALUE | (name.hashCode() & 0xAAAAAA) + 0x444444 & 0xFFFFFF;
                    int growth = name.equalsIgnoreCase("temple") ? 20 : 0;
                    for (StructureStart start : starts.getValue()) {
                        StructureBoundingBox box = start.func_75071_a();
                        if (!start.func_75069_d() || box.field_78893_d + growth <= -range || box.field_78897_a - growth >= range || box.field_78892_f + growth <= -range || box.field_78896_c - growth >= range) continue;
                        this.drawArea((float)box.field_78897_a + offsetX - (float)growth, (float)box.field_78896_c + offsetY - (float)growth, (float)box.field_78893_d + offsetX + (float)growth, (float)box.field_78892_f + offsetY + (float)growth, color);
                    }
                }
            }
        }
    }

    public void drawPostFrame() {
        this.drawSimpleText("Seed: ", 30, 30, 0x404040);
        this.drawSimpleText("Generation Options: ", 30, 70, 0x404040);
        this.drawSimpleText("Generation Control", 30, 140, 0x404040);
        this.drawSimpleText("Toggle Overlays", 30, 180, 0x404040);
        if (this.field_146295_m < 255) {
            this.drawSimpleText("Window height is to small", 30, 21, Color.RED.getRGB());
        }
        long[] data = WorldSeed.getData();
        this.drawSimpleText("Ram: " + WorldSeed.value(data[0]) + " MB / " + WorldSeed.value(data[2]) + " MB", this.field_146294_l - 178, 24, 0x404040);
        ChunkProcessor instance = ChunkProcessor.INSTANCE;
        this.drawSimpleText(instance.getCurrentProcessed() + " / " + instance.getMaxProcess() + " Chunks", 201, this.field_146295_m - 31, 0x404040);
    }

    public void drawFrame() {
        this.drawSimpleRect(20, 20, this.field_146294_l - 20, this.field_146295_m - 20, -3750202, false);
        this.drawSimpleRect(200, 40, this.field_146294_l - 40, this.field_146295_m - 40, -7631989, true);
        long[] data = WorldSeed.getData();
        this.drawSimpleRect(this.field_146294_l - 180, 22, this.field_146294_l - 40, 33, -7631989, true);
        this.drawSimpleRect(200, this.field_146295_m - 35, this.field_146294_l - 40, this.field_146295_m - 22, -7631989, true);
        double value = (double)data[0] / (double)data[2];
        GuiSeedPreview.func_73734_a((int)(this.field_146294_l - 180), (int)22, (int)(this.field_146294_l - 40 - (int)(140.0 - 140.0 * value)), (int)33, (int)Color.GREEN.getRGB());
        ChunkProcessor instance = ChunkProcessor.INSTANCE;
        value = instance.getTask() != null ? (double)instance.getCurrentProcessed() / (double)instance.getMaxProcess() : 0.0;
        int toRender = this.field_146294_l - 200 - 40;
        GuiSeedPreview.func_73734_a((int)200, (int)(this.field_146295_m - 35), (int)(this.field_146294_l - 40 - (int)((double)toRender - (double)toRender * value)), (int)(this.field_146295_m - 22), (int)Color.GREEN.getRGB());
    }

    public void handleButtonToolTips(int mouseX, int mouseY) {
        ArrayList<String> list;
        GuiButton button = this.getIDButton(3);
        if (button.func_146115_a()) {
            list = new ArrayList<String>();
            int radius = ((GuiSlider)button).getValueInt();
            int worldSize = radius * 32;
            int value = radius * 2;
            value *= value;
            list.add("WorldSize: " + worldSize + "x" + worldSize + " Blocks");
            list.add("");
            list.add("Expected Memory Usage");
            list.add("Ram Usage: ");
            list.add("PregenTask: +" + BIG_FORMAT.format(WorldSeed.value((long)value * 320L)) + " MB");
            list.add("");
            list.add("GPU Ram Usage: " + BIG_FORMAT.format(WorldSeed.value((long)value * 1024L)) + " MB");
            list.add("");
            list.add("Hard Drive Usage: (Accumulate Per Generated Dimension)");
            list.add("World Usage: +" + BIG_FORMAT.format(WorldSeed.value((long)value * 8192L)) + " MB");
            list.add("Preview Texture: +" + BIG_FORMAT.format(WorldSeed.value((long)value * IFileProvider.FileType.Chunk_Data.getOffset())) + " MB (Temporary)");
            list.add("HeightMap: +" + BIG_FORMAT.format(WorldSeed.value((long)value * IFileProvider.FileType.HeightData.getOffset())) + " MB (Temporary)");
            this.drawListText(list, mouseX, mouseY + 30);
        }
        if ((button = this.getIDButton(11)).func_146115_a() && ((GuiSlider)button).getValueInt() > 250) {
            list = new ArrayList();
            list.add("Anything above makes 250ms/t makes no sense and actually slows down the speed");
            this.drawListText(list, mouseX, mouseY - 15);
        }
        if (this.getIDButton(6).func_146115_a()) {
            this.drawListText(Arrays.asList("Press to toggle if only the Terrain should be generated or if the World should be fully Generated"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(15).func_146115_a()) {
            this.drawListText(Arrays.asList("Press To Toggle the Slime Chunk Rendering on Map"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(16).func_146115_a()) {
            this.drawListText(Arrays.asList("Press To Toggle the Structure Rendering on Map"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(100).func_146115_a()) {
            this.drawListText(Arrays.asList("Java Memory Cleanup (also known as Garbage Collection)", "Will Freeze the Game for a couple seconds!"), mouseX, mouseY + 30);
        }
    }

    public boolean isInFrame(int mouseX, int mouseY) {
        return mouseX >= 200 && mouseX <= this.field_146294_l - 40 && mouseY >= 40 && mouseY <= this.field_146295_m - 40;
    }
}

