/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo.detailed;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.detailed.DetailedEntry;
import pregenerator.impl.tracking.WorldTracker;

public class DimensionEntry
extends DetailedEntry {
    long usage;
    long average;

    public DimensionEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "Dim-Usage";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        WorldTracker tracker = this.getWorld();
        buf.writeLong(tracker != null ? tracker.getAverage() : 0L);
        buf.writeLong(tracker != null ? tracker.getCurrent() : 0L);
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        this.average = buf.readLong();
        this.usage = buf.readLong();
    }

    @Override
    public int getYOffset() {
        return 12;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        long actual = this.average;
        int value = this.getValue(actual);
        progress = this.clamp(0.0f, 1.0f, (float)value / 50.0f);
        int progresBar = (int)(progress * (float)width);
        helper.renderBar(x - width / 2, y, width, progresBar, "Average: " + value + " / 50 ms (" + actual / 1000L + " qs)");
        actual = this.usage;
        value = this.getValue(actual);
        progress = this.clamp(0.0f, 1.0f, (float)value / 50.0f);
        progresBar = (int)(progress * (float)width);
        helper.renderBar(x - width / 2, y += 6, width, progresBar, "Usage: " + value + " / 50 ms (" + actual / 1000L + " qs)");
    }
}

