/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.recipe.crafting;

import ic2.api.classic.recipe.ICustomRecipeInput;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class RecipeInputFluid
implements ICustomRecipeInput {
    private static final Map<Fluid, List<ItemStack>> map = new LinkedHashMap<Fluid, List<ItemStack>>();
    private static boolean init = false;
    public final FluidStack fluid;
    public final int stacksize;
    private List<ItemStack> list = null;

    public RecipeInputFluid(Fluid fluid) {
        this(new FluidStack(fluid, 1000), 1);
    }

    public RecipeInputFluid(Fluid fluid, int stacksize) {
        this(new FluidStack(fluid, 1000), stacksize);
    }

    public RecipeInputFluid(FluidStack fluid) {
        this(fluid, 1);
    }

    public RecipeInputFluid(FluidStack fluid, int stacksize) {
        this.fluid = fluid.copy();
        this.stacksize = stacksize;
    }

    @Override
    public boolean matches(ItemStack subject) {
        FluidStack otherFluid = FluidUtil.getFluidContained((ItemStack)subject);
        return otherFluid != null && otherFluid.containsFluid(this.fluid);
    }

    @Override
    public int getAmount() {
        return this.stacksize;
    }

    @Override
    public List<ItemStack> getInputs() {
        if (this.list == null) {
            this.list = this.getFluids();
        }
        return this.list;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public boolean isOreDict() {
        return false;
    }

    @Override
    public String getOreDictEntry() {
        return null;
    }

    private List<ItemStack> getFluids() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : RecipeInputFluid.getList(this.fluid.getFluid())) {
            list.add(stack.func_77946_l());
        }
        return list;
    }

    static List<ItemStack> getList(Fluid fluid) {
        if (!init) {
            RecipeInputFluid.init();
        }
        return map.getOrDefault(fluid, new ArrayList());
    }

    static void init() {
        for (Item item : Item.field_150901_e) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            for (ItemStack stack : list) {
                FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
                if (fluid == null) continue;
                List<ItemStack> resultList = map.get(fluid.getFluid());
                if (resultList == null) {
                    resultList = new ArrayList<ItemStack>();
                    map.put(fluid.getFluid(), resultList);
                }
                resultList.add(stack);
            }
        }
    }
}

