/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base;

import ic2.core.block.base.BlockCommonContainer;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.platform.textures.obj.IFacingBlock;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBlockStateLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMultiID
extends BlockCommonContainer
implements IBlockStateLoader,
ITexturedBlock,
IFacingBlock {
    public static int[][] sideAndFacingToSpriteOffset = new int[][]{{3, 2, 0, 0, 0, 0}, {2, 3, 1, 1, 1, 1}, {1, 1, 3, 2, 5, 4}, {0, 0, 2, 3, 4, 5}, {4, 5, 4, 5, 3, 2}, {5, 4, 5, 4, 2, 3}};
    public static PropertyInteger metadata = PropertyInteger.func_177719_a((String)"metadata", (int)0, (int)15);
    public static PropertyDirection allFacings = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.field_82609_l));
    public static PropertyBool active = PropertyBool.func_177716_a((String)"active");

    public BlockMultiID(Material materialIn) {
        super(materialIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{this.getMetadataProperty(), allFacings, active});
    }

    public PropertyInteger getMetadataProperty() {
        return metadata;
    }

    @Override
    public EnumFacing getRotation(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)allFacings);
    }

    @Override
    public boolean hasRotation(IBlockState state) {
        return this.hasFacing();
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getMetadataProperty());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta));
    }

    @Override
    public IBlockState getDefaultBlockState() {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false));
        if (this.hasFacing()) {
            state = state.func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.NORTH);
        }
        return state;
    }

    @Override
    public List<IBlockState> getValidStates(IBlockState defaultState) {
        this.func_180632_j(defaultState);
        this.func_180632_j(this.getDefaultBlockState());
        return this.getValidStateList();
    }

    public abstract List<IBlockState> getValidStateList();

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing side) {
        int meta = this.func_176201_c(state);
        int extraMeta = this.getIconMeta(state);
        return this.getTextureFromState(state, meta, extraMeta, side);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, int meta, int extraMeta, EnumFacing side) {
        EnumFacing facing;
        EnumFacing enumFacing = facing = this.hasFacing() ? (EnumFacing)state.func_177229_b((IProperty)allFacings) : EnumFacing.NORTH;
        if (((Boolean)state.func_177229_b((IProperty)active)).booleanValue()) {
            return this.getIconSheet(meta)[extraMeta + (sideAndFacingToSpriteOffset[side.func_176745_a()][facing.func_176745_a()] + 6) * this.getMaxSheetSize(meta)];
        }
        return this.getIconSheet(meta)[extraMeta + sideAndFacingToSpriteOffset[side.func_176745_a()][facing.func_176745_a()] * this.getMaxSheetSize(meta)];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        int meta = this.func_176201_c(state);
        return this.getIconSheet(meta)[this.getIconMeta(state) + sideAndFacingToSpriteOffset[EnumFacing.func_176741_a((Random)RANDOM).func_176745_a()][3] * this.getMaxSheetSize(meta)];
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityBlock block = (TileEntityBlock)worldIn.func_175625_s(pos);
        if (block != null) {
            if (this.hasFacing()) {
                state = state.func_177226_a((IProperty)allFacings, (Comparable)block.getFacing());
            }
            return state.func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(block.getActive()));
        }
        if (this.hasFacing()) {
            state = state.func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.NORTH);
        }
        return state.func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176203_a(stack.func_77960_j());
    }

    public abstract TileEntityBlock createNewTileEntity(World var1, int var2);

    public abstract List<Integer> getValidMetas();

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite[] getIconSheet(int var1);

    public boolean hasFacing() {
        return true;
    }

    public int getMaxSheetSize(int meta) {
        return 16;
    }

    public int getIconMeta(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Integer meta : this.getValidMetas()) {
            items.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, meta.intValue()));
        }
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }
}

