/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.inv.container.ContainerBaseFluidMoveUpgrade;
import ic2.core.item.inv.inventories.BaseFluidMoveUpgradeInv;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseFluidFilteredUpgrade
extends BaseMetaUpgrade {
    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTips) {
        super.addInfo(par1, par2, par3, toolTips);
        Tuple<Boolean, List<FluidStack>> targets = this.getFluids(par1);
        if (targets != null) {
            List<String> altList = toolTips.get((Object)ToolTipType.Alt);
            if (((Boolean)targets.func_76341_a()).booleanValue()) {
                altList.add(Ic2InfoLang.isInverted.getLocalized());
                altList.add("");
            }
            for (FluidStack fluid : (List)targets.func_76340_b()) {
                altList.add(fluid.getLocalizedName());
            }
        }
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isSideinventoryKeyDown(player)) {
            IC2.platform.launchGui(player, this.getInventory(player, hand, item), hand);
        }
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new BaseFluidMoveUpgradeInv(player, (IHandHeldInventory)stack.func_77973_b(), stack);
    }

    public Set<String> getTargets(ItemStack stack) {
        LinkedHashSet<String> text = new LinkedHashSet<String>();
        NBTTagList list = StackUtil.getNbtData(stack).func_150295_c("FluidData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (fluid == null) continue;
            text.add(fluid.getLocalizedName());
        }
        return text;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, ItemStack stack, int key) {
        if (player != null && player.field_71070_bA instanceof ContainerBaseFluidMoveUpgrade) {
            BaseFluidMoveUpgradeInv inv = (BaseFluidMoveUpgradeInv)((ContainerBaseFluidMoveUpgrade)player.field_71070_bA).getGuiHolder();
            if (key == 0) {
                inv.inverted = !inv.inverted;
            }
        }
    }

    public Tuple<Boolean, List<FluidStack>> getFluids(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        NBTTagList list = nbt.func_150295_c("FluidData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (fluid == null) continue;
            fluids.add(fluid);
        }
        return new Tuple((Object)nbt.func_74767_n("isInverted"), fluids);
    }

    public boolean isValidFluid(Tuple<Boolean, List<FluidStack>> data, FluidStack fluid) {
        boolean bool = (Boolean)data.func_76341_a();
        for (FluidStack entry : (List)data.func_76340_b()) {
            if (!entry.isFluidEqual(fluid)) continue;
            return !bool;
        }
        return bool;
    }

    @Override
    public boolean hasInventory(ItemStack stack) {
        return true;
    }
}

