/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.meteor;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.gson.Serializers;
import WayofTime.bloodmagic.meteor.Meteor;
import WayofTime.bloodmagic.meteor.MeteorComponent;
import WayofTime.bloodmagic.meteor.MeteorRegistry;
import WayofTime.bloodmagic.util.BMLog;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MeteorConfigHandler {
    private static final Map<String, Meteor> DEFAULT_METEORS = Maps.newHashMap();
    private static File meteorDir;

    public static void init(File meteorDirectory) {
        meteorDir = meteorDirectory;
        MeteorConfigHandler.handleMeteors(true);
    }

    /*
     * WARNING - void declaration
     */
    public static void handleMeteors(boolean checkNewVersion) {
        if (meteorDir == null) {
            BMLog.DEFAULT.error("Attempted to handle meteor config but the folder has not been initialized. Was this run too early?", new Object[0]);
            return;
        }
        MeteorRegistry.meteorMap.clear();
        List<Pair<String, Meteor>> defaultMeteors = MeteorConfigHandler.getDefaultMeteors();
        try {
            void var6_15;
            File[] meteorFiles;
            if (!meteorDir.exists() && meteorDir.mkdir()) {
                for (Pair<String, Meteor> meteor : defaultMeteors) {
                    String string = Serializers.GSON.toJson(meteor.getRight());
                    FileWriter writer = new FileWriter(new File(meteorDir, (String)meteor.getLeft() + ".json"));
                    writer.write(string);
                    writer.close();
                }
            }
            if ((meteorFiles = meteorDir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
                return;
            }
            ArrayList meteors = Lists.newArrayList();
            File[] fileArray = meteorFiles;
            int writer = fileArray.length;
            boolean bl = false;
            while (var6_15 < writer) {
                File meteorFile = fileArray[var6_15];
                FileReader reader = new FileReader(meteorFile);
                Meteor meteor = (Meteor)Serializers.GSON.fromJson((Reader)reader, Meteor.class);
                meteors.add(Pair.of((Object)FilenameUtils.removeExtension((String)meteorFile.getName()), (Object)meteor));
                reader.close();
                ++var6_15;
            }
            if (checkNewVersion && ConfigHandler.values.shouldResyncMeteors) {
                HashSet hashSet = Sets.newHashSet();
                for (Pair pair : meteors) {
                    Meteor defaultMeteor = DEFAULT_METEORS.get(pair.getLeft());
                    if (defaultMeteor == null) continue;
                    hashSet.add(pair.getLeft());
                    if (defaultMeteor.version <= ((Meteor)pair.getRight()).version) continue;
                    MeteorConfigHandler.writeMeteor((String)pair.getLeft(), defaultMeteor);
                    meteors.set(meteors.indexOf(pair), Pair.of((Object)pair.getLeft(), (Object)defaultMeteor));
                }
                for (Map.Entry entry : DEFAULT_METEORS.entrySet()) {
                    if (hashSet.contains(entry.getKey())) continue;
                    MeteorConfigHandler.writeMeteor((String)entry.getKey(), (Meteor)entry.getValue());
                }
            }
            for (Pair meteor : meteors) {
                MeteorRegistry.registerMeteor(((Meteor)meteor.getRight()).getCatalystStack(), (Meteor)meteor.getRight());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<Pair<String, Meteor>> getDefaultMeteors() {
        ArrayList holders = Lists.newArrayList();
        ArrayList ironMeteorList = Lists.newArrayList();
        ironMeteorList.add(new MeteorComponent(400, "oreIron"));
        ironMeteorList.add(new MeteorComponent(200, "oreCopper"));
        ironMeteorList.add(new MeteorComponent(140, "oreTin"));
        ironMeteorList.add(new MeteorComponent(70, "oreSilver"));
        ironMeteorList.add(new MeteorComponent(80, "oreLead"));
        ironMeteorList.add(new MeteorComponent(30, "oreGold"));
        ironMeteorList.add(new MeteorComponent(60, "oreLapis"));
        ironMeteorList.add(new MeteorComponent(100, "oreRedstone"));
        Meteor ironMeteor = new Meteor(new ItemStack(Blocks.field_150339_S), ironMeteorList, 15.0f, 5);
        ironMeteor.setVersion(3);
        ironMeteor.setCost(1000000);
        ArrayList goldMeteorList = Lists.newArrayList();
        goldMeteorList.add(new MeteorComponent(200, "oreIron"));
        goldMeteorList.add(new MeteorComponent(100, "oreCopper"));
        goldMeteorList.add(new MeteorComponent(60, "oreTin"));
        goldMeteorList.add(new MeteorComponent(100, "oreGold"));
        goldMeteorList.add(new MeteorComponent(120, "oreLapis"));
        goldMeteorList.add(new MeteorComponent(30, "oreDiamond"));
        goldMeteorList.add(new MeteorComponent(20, "oreEmerald"));
        goldMeteorList.add(new MeteorComponent(20, "oreCoal"));
        Meteor goldMeteor = new Meteor(new ItemStack(Blocks.field_150340_R), goldMeteorList, 18.0f, 6);
        goldMeteor.setVersion(4);
        goldMeteor.setCost(2500000);
        ArrayList diamondMeteorList = Lists.newArrayList();
        diamondMeteorList.add(new MeteorComponent(50, "oreIron"));
        diamondMeteorList.add(new MeteorComponent(100, "oreGold"));
        diamondMeteorList.add(new MeteorComponent(10, "oreLapis"));
        diamondMeteorList.add(new MeteorComponent(250, "oreDiamond"));
        diamondMeteorList.add(new MeteorComponent(180, "oreEmerald"));
        diamondMeteorList.add(new MeteorComponent(50, "oreRedstone"));
        diamondMeteorList.add(new MeteorComponent(400, "oreDiamond"));
        Meteor diamondMeteor = new Meteor(new ItemStack(Blocks.field_150484_ah), diamondMeteorList, 10.0f, 3);
        diamondMeteor.setVersion(4);
        diamondMeteor.setCost(5000000);
        holders.add(Pair.of((Object)"iron", (Object)ironMeteor));
        DEFAULT_METEORS.put("iron", ironMeteor);
        holders.add(Pair.of((Object)"gold", (Object)goldMeteor));
        DEFAULT_METEORS.put("gold", goldMeteor);
        holders.add(Pair.of((Object)"diamond", (Object)diamondMeteor));
        DEFAULT_METEORS.put("diamond", diamondMeteor);
        return holders;
    }

    private static void writeMeteor(String name, Meteor meteor) {
        try {
            String json = Serializers.GSON.toJson((Object)meteor);
            File meteorFile = new File(meteorDir, name + ".json");
            new PrintWriter(meteorFile).close();
            FileWriter fileWriter = new FileWriter(meteorFile);
            fileWriter.write(json);
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

