/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block.entity;

import fossilsarcheology.server.block.WorktableBlock;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import fossilsarcheology.server.recipe.RecipeWorktable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityWorktable
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable {
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2};
    private static final int[] slots_sides = new int[]{0};
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private String customName;

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    @Nullable
    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStackHelper.func_188382_a(this.stacks, (int)slot, (int)amount);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)var1, this.stacks);
        this.furnaceBurnTime = var1.func_74765_d("BurnTime");
        this.furnaceCookTime = var1.func_74765_d("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime((ItemStack)this.stacks.get(1));
        if (var1.func_74764_b("CustomName")) {
            this.customName = var1.func_74779_i("CustomName");
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceCookTime;
            }
            case 1: {
                return this.furnaceBurnTime;
            }
            case 2: {
                return this.currentItemBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceCookTime = value;
                break;
            }
            case 1: {
                this.furnaceBurnTime = value;
                break;
            }
            case 2: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public int getCookProgressScaled(int var1) {
        return this.furnaceCookTime * var1 / this.timeToSmelt();
    }

    public int getBurnTimeRemainingScaled(int var1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.timeToSmelt();
        }
        return this.furnaceBurnTime * var1 / this.currentItemBurnTime;
    }

    private int timeToSmelt() {
        if (((ItemStack)this.stacks.get(0)).func_190926_b()) {
            return 3000;
        }
        if (((ItemStack)this.stacks.get(0)).func_77973_b() == FAItemRegistry.BROKEN_HELMET) {
            return 3000;
        }
        if (((ItemStack)this.stacks.get(0)).func_77973_b() == FAItemRegistry.BROKEN_SWORD) {
            return 3000;
        }
        return 300;
    }

    public void func_73660_a() {
        boolean var1 = this.furnaceBurnTime > 0;
        boolean var2 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime((ItemStack)this.stacks.get(1));
                if (this.furnaceBurnTime > 0) {
                    var2 = true;
                    if (!((ItemStack)this.stacks.get(1)).func_190926_b()) {
                        if (((ItemStack)this.stacks.get(1)).func_77973_b().hasContainerItem(null)) {
                            this.stacks.set(1, (Object)new ItemStack(((ItemStack)this.stacks.get(1)).func_77973_b().func_77668_q()));
                        } else {
                            ((ItemStack)this.stacks.get(1)).func_190918_g(1);
                        }
                        if (((ItemStack)this.stacks.get(1)).func_190916_E() == 0) {
                            this.stacks.set(1, (Object)ItemStack.field_190927_a);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.timeToSmelt()) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (var1 != this.furnaceBurnTime > 0) {
                var2 = true;
                WorktableBlock.setState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (var2) {
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private ItemStack checkSmelt(ItemStack itemstack) {
        RecipeWorktable recipeWorktable = FAMachineRecipeRegistry.getWorktableRecipeForItem(itemstack);
        if (recipeWorktable != null) {
            return recipeWorktable.getOutput();
        }
        return null;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack var1 = this.checkSmelt((ItemStack)this.stacks.get(0));
            if (((ItemStack)this.stacks.get(2)).func_190926_b()) {
                if (var1 != null) {
                    this.stacks.set(2, (Object)var1.func_77946_l());
                }
            } else if (((ItemStack)this.stacks.get(2)).func_77973_b() == var1.func_77973_b()) {
                ((ItemStack)this.stacks.get(2)).func_190917_f(var1.func_190916_E());
            }
            if (((ItemStack)this.stacks.get(0)).func_77973_b().hasContainerItem(ItemStack.field_190927_a)) {
                this.stacks.set(0, (Object)new ItemStack(((ItemStack)this.stacks.get(0)).func_77973_b().func_77668_q()));
            } else {
                ((ItemStack)this.stacks.get(0)).func_190918_g(1);
            }
            if (((ItemStack)this.stacks.get(0)).func_190916_E() <= 0) {
                this.stacks.set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.stacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack var1 = this.checkSmelt((ItemStack)this.stacks.get(0));
        return var1 != null && !var1.func_190926_b() && (((ItemStack)this.stacks.get(2)).func_190926_b() || ((ItemStack)this.stacks.get(2)).func_77969_a(var1) && (((ItemStack)this.stacks.get(2)).func_190916_E() < this.func_70297_j_() && ((ItemStack)this.stacks.get(2)).func_190916_E() < ((ItemStack)this.stacks.get(2)).func_77976_d() || ((ItemStack)this.stacks.get(2)).func_190916_E() < var1.func_77976_d()));
    }

    private int getItemBurnTime(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return 0;
        }
        Item var2 = itemstack.func_77973_b();
        RecipeWorktable recipeWorktable = FAMachineRecipeRegistry.getWorktableRecipeForItem((ItemStack)this.stacks.get(0));
        if (recipeWorktable != null) {
            return var2 == recipeWorktable.getFuel().func_77973_b() ? 300 : 0;
        }
        return 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        if (this.customName != null) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        return nbt;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_sides : slots_top);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN || index != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }

    public String func_70005_c_() {
        return this.customName != null ? this.customName : "tile.worktable.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager netManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

