/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.server.entity.EntityFishBase;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityNautilus
extends EntityFishBase {
    private static final DataParameter<Boolean> ISINSHELL = EntityDataManager.func_187226_a(EntityNautilus.class, (DataSerializer)DataSerializers.field_187198_h);
    public float shellProgress;
    public boolean isInShell;
    public int ticksToShell;

    public EntityNautilus(World world) {
        super(world, PrehistoricEntityType.NAUTILUS);
        this.func_70105_a(0.8f, 0.95f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ISINSHELL, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("InShell", this.isInShell);
        compound.func_74768_a("ShellTick", this.ticksToShell);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.setInShell(compound.func_74767_n("InShell"));
        this.ticksToShell = compound.func_74762_e("ShellTick");
    }

    public boolean isInShell() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSleeping;
            this.isInShell = isSleeping = ((Boolean)this.field_70180_af.func_187225_a(ISINSHELL)).booleanValue();
            return isSleeping;
        }
        return this.isInShell;
    }

    public void setInShell(boolean inShell) {
        this.field_70180_af.func_187227_b(ISINSHELL, (Object)inShell);
        if (!this.field_70170_p.field_72995_K) {
            this.isInShell = inShell;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean inshell = this.isInShell();
        if (inshell && this.shellProgress < 20.0f) {
            this.shellProgress += 0.5f;
        } else if (!inshell && this.shellProgress > 0.0f) {
            this.shellProgress -= 0.5f;
        }
        if (this.ticksToShell > 0) {
            --this.ticksToShell;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isThereNearbyMobs() && this.ticksToShell == 0 || !this.func_70090_H() && this.field_70122_E && this.ticksToShell == 0) {
                if (!this.isInShell()) {
                    this.setInShell(true);
                }
            } else if (this.isInShell()) {
                this.setInShell(false);
            }
        }
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.NAUTILUS_LOOT;
    }

    public boolean isThereNearbyMobs() {
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0), null);
        return list.stream().anyMatch(this::isAScaryAnimal);
    }

    public boolean isAScaryAnimal(Entity entity) {
        if (entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_()) {
            return true;
        }
        if (entity instanceof EntityPrehistoric) {
            return ((EntityPrehistoric)entity).type.diet.getFearIndex() >= 2;
        }
        return (double)entity.field_70130_N >= 1.2;
    }

    public boolean func_70097_a(DamageSource dmg, float f) {
        if (f > 0.0f && this.isInShell() && dmg.func_76346_g() != null) {
            this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, this.func_70681_au().nextFloat() + 0.8f);
            if (this.func_184187_bx() != null) {
                return super.func_70097_a(dmg, f);
            }
            return false;
        }
        if (!this.isInShell()) {
            this.setInShell(true);
        }
        return super.func_70097_a(dmg, f);
    }

    @Override
    public String getTexture() {
        return "fossil:textures/model/fish/nautilus.png";
    }

    @Override
    protected double getSwimSpeed() {
        return 0.15;
    }
}

