/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFindWaterTarget;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIGetInWater;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILeaveWater;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.prehistoric.IScaryDinosaur;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.entity.utility.EntityToyBase;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.function.Predicate;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySpinosaurus
extends EntityPrehistoricSwimming
implements IScaryDinosaur {
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntitySpinosaurus.class, (DataSerializer)DataSerializers.field_187198_h);
    public final Animation SHAKE_ANIMATION = Animation.create((int)65);
    public float swimProgress;
    private boolean isSwimming;

    public EntitySpinosaurus(World world) {
        super(world, PrehistoricEntityType.SPINOSAURUS, 2.0, 14.0, 15.0, 86.0, 0.25, 0.35, 10.0, 20.0);
        this.setActualSize(1.5f, 1.0f);
        this.isAmphibious = true;
        this.FISH_ANIMATION = Animation.create((int)40);
        this.minSize = 0.25f;
        this.maxSize = 3.1f;
        this.teenAge = 5;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.hasBabyTexture = true;
        this.ridingY = 1.21f;
        this.ridingXZ = -0.3f;
        this.pediaScale = 26.0f;
    }

    @Override
    public float getTargetScale() {
        return 1.5f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFindWaterTarget((EntityCreature)this, 10, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIGetInWater(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAILeaveWater(this, 1.0));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.DROWN;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.BLUEGEM;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.SEMIAQUATIC;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.ATTACK;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    public boolean breaksBoats() {
        return true;
    }

    @Override
    public Item getOrderItem() {
        return FAItemRegistry.SKULL_STICK;
    }

    @Override
    public int getAdultAge() {
        return 12;
    }

    @Override
    public int getTailSegments() {
        return 3;
    }

    @Override
    public int getMaxHunger() {
        return 175;
    }

    @Override
    public double swimSpeed() {
        return 1.0;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLivingBase && this.getRidingPlayer() == null || this.getRidingPlayer() != null && passenger != this.getRidingPlayer()) {
            Entity riddenByEntity = passenger;
            if (this.getAnimationTick() > 55 || this.getAnimation() == NO_ANIMATION) {
                if (riddenByEntity instanceof EntityToyBase) {
                    riddenByEntity.func_184210_p();
                    this.func_70624_b(null);
                    this.doPlayBonus(((EntityToyBase)riddenByEntity).toyBonus);
                    riddenByEntity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    riddenByEntity = null;
                    return;
                }
                if (passenger instanceof EntityLivingBase) {
                    riddenByEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getStrongAttackPower());
                    riddenByEntity.func_184210_p();
                    riddenByEntity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70074_a((EntityLivingBase)riddenByEntity);
            }
            riddenByEntity.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + riddenByEntity.func_70033_W(), this.field_70161_v);
            float modTick_0 = this.getAnimationTick() - 15;
            float modTick_1 = this.getAnimationTick() > 15 ? 6.0f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)(modTick_0 * 0.275f)))) : 0.0f;
            float modTick_2 = this.getAnimationTick() > 15 ? 15.0f : (float)this.getAnimationTick();
            this.field_70177_z *= 0.0f;
            riddenByEntity.field_70177_z = this.field_70177_z + this.field_70759_as + 180.0f;
            this.field_70177_z = this.field_70761_aq;
            float radius = 0.6f * (0.7f * this.getAgeScale()) * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f + modTick_1 * 1.75f * 0.05f;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = (double)0.8f * ((double)this.getAgeScale() + (double)modTick_1 * 0.05 + (double)modTick_2 * 0.15 - 2.5);
            double waterMinus = this.getAgeScale() * (this.swimProgress / 20.0f) * 0.5f;
            super.func_70098_U();
            riddenByEntity.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY - waterMinus, this.field_70161_v + extraZ);
        }
    }

    public void func_70098_U() {
        if (this.getRidingPlayer() != null && this.func_152114_e((EntityLivingBase)this.getRidingPlayer())) {
            super.func_70098_U();
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean swimming = this.isSwimming();
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        }
        if (this.isSwimming() && (this.func_70906_o() || this.isSleeping())) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (this.func_70638_az() != null && this.canReachPrey()) {
            this.func_70652_k((Entity)this.func_70638_az());
            if (!EntitySpinosaurus.isEntitySmallerThan((Entity)this.func_70638_az(), 2.0f * (this.getAgeScale() / this.maxSize)) || this.func_70681_au().nextInt(5) != 0) {
                if (this.getAnimation() != this.ATTACK_ANIMATION && this.getAnimation() != this.SHAKE_ANIMATION) {
                    this.setAnimation(this.ATTACK_ANIMATION);
                }
                this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() > 10) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.destroyBoat((Entity)this.func_70638_az());
                }
            } else if (this.getAnimation() != this.ATTACK_ANIMATION) {
                this.destroyBoat((Entity)this.func_70638_az());
                this.func_70638_az().func_184220_m((Entity)this);
                if (this.getAnimation() != this.SHAKE_ANIMATION) {
                    this.setAnimation(this.SHAKE_ANIMATION);
                }
            }
        }
        if (this.isInWaterMaterial()) {
            this.setSwimming(true);
        } else {
            this.setSwimming(false);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return !this.func_70090_H();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Swimming", this.isSwimming);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSwimming(compound.func_74767_n("Swimming"));
    }

    public boolean isSwimming() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSwimming;
            this.isSwimming = isSwimming = ((Boolean)this.field_70180_af.func_187225_a(SWIMMING)).booleanValue();
            return isSwimming;
        }
        return this.isSwimming;
    }

    public void setSwimming(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    @Override
    public int getAttackLength() {
        return 25;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, this.SHAKE_ANIMATION, this.FISH_ANIMATION};
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.SPINOSAURUS_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.SPINOSAURUS_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.SPINOSAURUS_DEATH;
    }

    @Override
    public float getProximityToNextPathSkip() {
        return (float)this.func_174813_aQ().func_72320_b() * 0.8f;
    }
}

