/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.world;

import fossilsarcheology.Revival;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.entity.FAVillagerRegistry;
import fossilsarcheology.server.entity.prehistoric.EntityAlligatorGar;
import fossilsarcheology.server.entity.prehistoric.EntityCoelacanth;
import fossilsarcheology.server.entity.prehistoric.EntityNautilus;
import fossilsarcheology.server.entity.prehistoric.EntitySturgeon;
import fossilsarcheology.server.structure.StructureUtils;
import fossilsarcheology.server.world.gen.HellBoatWorldGen;
import fossilsarcheology.server.world.gen.WorldGenPalm;
import fossilsarcheology.server.world.gen.WorldGenPermafrost;
import fossilsarcheology.server.world.gen.WorldGenTarPit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FAWorldGenerator
implements IWorldGenerator {
    public static final ResourceLocation ANU_CASTLE = new ResourceLocation("fossil", "anu_castle");
    private static final ResourceLocation TAR_SITE = new ResourceLocation("fossil", "tar_site");
    private static final ResourceLocation FOSSIL_SITE = new ResourceLocation("fossil", "fossil_site");
    private static final ResourceLocation FOSSIL_SITE_TENT = new ResourceLocation("fossil", "fossil_site_tent");
    private static final ResourceLocation MOAI = new ResourceLocation("fossil", "moai");
    private static final ResourceLocation MOAI_WITH_HAT = new ResourceLocation("fossil", "moai_with_hat");
    private static final ResourceLocation AZTEC_TEMPLE = new ResourceLocation("fossil", "aztec_temple");
    private static final ResourceLocation AZTEC_WEAPONS_SHOP = new ResourceLocation("fossil", "aztec_weapons_shop");
    private static final ResourceLocation EGYPTIAN_ACADEMY = new ResourceLocation("fossil", "egyptian_academy");
    private static final ResourceLocation TREASURE_ROOM = new ResourceLocation("fossil", "treasure_room");
    private static final ResourceLocation AZTEC_WEAPONS_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "aztec_weapons_shop"));
    private static final ResourceLocation ANU_CASTLE_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "anu_castle"));
    private static final BlockPos ANU_CASTLE_POS = new BlockPos(-70, 63, -70);
    private static final BlockPos TREASURE_ROOM_POS = new BlockPos(0, 56, 0);
    public static ResourceLocation AZTEC_TEMPLE_CHEST;
    public static ResourceLocation EGYPTIAN_ACADEMY_CHEST;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int why;
        int zee;
        int x;
        int z;
        boolean prevLogCascadingWorldGen = ForgeModContainer.logCascadingWorldGeneration;
        if (!Revival.CONFIG_OPTIONS.logCascadingWorldGen) {
            ForgeModContainer.logCascadingWorldGeneration = false;
        }
        int dimensionID = world.field_73011_w.getDimension();
        block0: for (int oreGenDim : Revival.CONFIG_OPTIONS.oreGenerationDimensions) {
            if (dimensionID != oreGenDim) continue;
            if (Revival.CONFIG_OPTIONS.generateFossils) {
                boolean mesa = BiomeDictionary.hasType((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkX * 16 + 8)), (BiomeDictionary.Type)BiomeDictionary.Type.MESA);
                for (int i = 0; i < (mesa ? Revival.CONFIG_OPTIONS.fossilOreRarity * 2 : Revival.CONFIG_OPTIONS.fossilOreRarity); ++i) {
                    int Xcoord = chunkX * 16 + random.nextInt(16);
                    int Ycoord = random.nextInt(100);
                    int Zcoord = chunkZ * 16 + random.nextInt(16);
                    new WorldGenMinable(FABlockRegistry.FOSSIL.func_176223_P(), 5 + random.nextInt(6)).func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
                }
            }
            if (!Revival.CONFIG_OPTIONS.generatePermafrost) continue;
            int i = 0;
            while (true) {
                float f = i;
                float f2 = BiomeDictionary.hasType((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) ? (float)Revival.CONFIG_OPTIONS.permafrostOreRarity * 2.5f : (float)Revival.CONFIG_OPTIONS.permafrostOreRarity;
                if (!(f < f2)) continue block0;
                int Xcoord = chunkX * 16 + random.nextInt(16);
                int Ycoord = random.nextInt(30);
                int Zcoord = chunkZ * 16 + random.nextInt(16);
                new WorldGenPermafrost(FABlockRegistry.PERMAFROST.func_176223_P(), 6 + random.nextInt(4)).func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
                ++i;
            }
        }
        if (FAWorldGenerator.canStructureSpawnInDim(dimensionID)) {
            int x2 = chunkX * 16 + random.nextInt(16);
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(new BlockPos(x2, 0, z = chunkZ * 16 + random.nextInt(16))), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && random.nextInt(500) == 0) {
                if (Revival.CONFIG_OPTIONS.generateTarSites) {
                    for (int k = 0; k < 10; ++k) {
                        int y = random.nextInt(128);
                        new WorldGenTarPit((Block)FABlockRegistry.TAR).func_180709_b(world, random, new BlockPos(x2, y, z));
                    }
                }
                if (Revival.CONFIG_OPTIONS.generatePrehistoricTrees) {
                    for (int count = 0; count < 2; ++count) {
                        BlockPos pos = world.func_175645_m(new BlockPos(x2, 0, z));
                        new WorldGenPalm().func_180709_b(world, random, pos);
                    }
                }
            }
            if (Revival.CONFIG_OPTIONS.generateVolcanicRock) {
                for (int i = 0; i < 10; ++i) {
                    int y = random.nextInt(16);
                    new WorldGenPermafrost(FABlockRegistry.VOLCANIC_ROCK.func_176223_P(), 6 + random.nextInt(3)).func_180709_b(world, random, new BlockPos(x2, y, z));
                }
            }
        }
        if (Revival.CONFIG_OPTIONS.generateHellShips && dimensionID == -1 && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateHellShipRarity, 1)) == 0 && world.func_180495_p(new BlockPos(x = chunkX * 16 + random.nextInt(16), 31, z = chunkZ * 16 + random.nextInt(16))).func_185904_a() == Material.field_151587_i) {
            new HellBoatWorldGen().func_180709_b(world, random, new BlockPos(x, 32, z));
        }
        x = chunkX * 16 + 8;
        z = chunkZ * 16 + 8;
        BlockPos height = StructureUtils.getGround(x, z, world);
        Biome biome = world.func_180494_b(height);
        if (Revival.CONFIG_OPTIONS.generateTarSites && FAWorldGenerator.canStructureSpawnInDim(dimensionID) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateTarSiteRarity, 1)) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && biome.field_76752_A.func_177230_c() == Blocks.field_150349_c && StructureUtils.canGenOnBlock(world, height) && StructureUtils.generateStructureAtWithRandomRotation(TAR_SITE, world, height.func_177979_c(3), random, true, false)) {
            BlockPos tentPos = random.nextBoolean() ? height.func_177982_a(10 + random.nextInt(6), 10 + random.nextInt(6), 10 + random.nextInt(6)) : height.func_177982_a(-10 - random.nextInt(6), -10 - random.nextInt(6), -10 - random.nextInt(6));
            StructureUtils.generateStructureAtWithRandomRotation(FOSSIL_SITE_TENT, world, StructureUtils.getGround(tentPos, world), random, false, false);
            EntityVillager villager = new EntityVillager(world);
            villager.setProfession(FAVillagerRegistry.PALAEONTOLOGIST_PROFESSION);
            villager.func_70012_b((double)tentPos.func_177958_n() - 0.5, (double)world.func_175645_m(tentPos).func_177956_o() + 1.0, (double)tentPos.func_177952_p() - 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)villager);
        }
        if (Revival.CONFIG_OPTIONS.generateFossilSites && FAWorldGenerator.canStructureSpawnInDim(dimensionID) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateFossilSiteRarity, 1)) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && biome.field_76752_A.func_177230_c() == Blocks.field_150349_c && StructureUtils.canGenOnBlock(world, height) && StructureUtils.generateStructureAtWithRandomRotation(FOSSIL_SITE, world, height.func_177979_c(3), random, true, false)) {
            BlockPos tentPos = random.nextBoolean() ? height.func_177982_a(10 + random.nextInt(6), 10 + random.nextInt(6), 10 + random.nextInt(6)) : height.func_177982_a(-10 - random.nextInt(6), -10 - random.nextInt(6), -10 - random.nextInt(6));
            StructureUtils.generateStructureAtWithRandomRotation(FOSSIL_SITE_TENT, world, StructureUtils.getGround(tentPos, world), random, false, false);
            EntityVillager villager = new EntityVillager(world);
            villager.setProfession(FAVillagerRegistry.PALAEONTOLOGIST_PROFESSION);
            villager.func_70012_b((double)tentPos.func_177958_n() - 0.5, (double)world.func_175645_m(tentPos).func_177956_o() + 1.0, (double)tentPos.func_177952_p() - 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)villager);
        }
        if (Revival.CONFIG_OPTIONS.generateMoai && FAWorldGenerator.canStructureSpawnInDim(dimensionID) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateMoaiRarity, 1)) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && world.func_180495_p(height.func_177977_b()).func_185914_p() && StructureUtils.canGenOnBlock(world, height)) {
            StructureUtils.generateStructureAtWithRandomRotation(random.nextInt(3) == 0 ? MOAI_WITH_HAT : MOAI, world, height.func_177979_c(random.nextInt(5)), random, false, true);
        }
        if (Revival.CONFIG_OPTIONS.generateAztecWeaponShops && FAWorldGenerator.canStructureSpawnInDim(dimensionID) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateWeaponShopRarity, 1)) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && StructureUtils.canGenOnBlock(world, height)) {
            StructureUtils.generateStructureAtWithRandomRotationWithLoot(AZTEC_WEAPONS_SHOP, AZTEC_WEAPONS_CHEST, world, height, random, true, false);
        }
        if (Revival.CONFIG_OPTIONS.generateTemple && FAWorldGenerator.canStructureSpawnInDim(dimensionID) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateTempleRarity, 1)) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && StructureUtils.canGenOnBlock(world, height)) {
            StructureUtils.generateStructureAtWithRandomRotationWithLoot(AZTEC_TEMPLE, AZTEC_TEMPLE_CHEST, world, height, random, true, false);
        }
        if (Revival.CONFIG_OPTIONS.generateAcademy && FAWorldGenerator.canStructureSpawnInDim(dimensionID) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.generateAcademyRarity, 1)) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && StructureUtils.canGenOnBlock(world, height)) {
            StructureUtils.generateStructureAtWithRandomRotationWithLoot(EGYPTIAN_ACADEMY, EGYPTIAN_ACADEMY_CHEST, world, height.func_177977_b(), random, true, false);
        }
        if (world.func_72964_e(chunkX, chunkZ) == world.func_175726_f(ANU_CASTLE_POS) && world.field_73011_w.getDimension() == Revival.CONFIG_OPTIONS.dimensionIDDarknessLair) {
            int counter = 0;
            if (++counter == 1) {
                StructureUtils.generateStructureAtWithRotationWithLoot(ANU_CASTLE, ANU_CASTLE_CHEST, world, new BlockPos(-140, 63, -140), random, Rotation.NONE, false, false);
                int structurebase = 140;
                int base = 14;
                for (int y = 50; y < 63; ++y) {
                    for (int baseX = -70 - --base; baseX < structurebase - 70 + base; ++baseX) {
                        for (int baseZ = -70 - base; baseZ < structurebase - 70 + base; ++baseZ) {
                            world.func_175656_a(new BlockPos(baseX, y, baseZ), Blocks.field_150424_aL.func_176223_P());
                        }
                    }
                }
                world.func_175656_a(new BlockPos(0, 73, 0), FABlockRegistry.SARCOPHAGUS.func_176223_P());
            }
        }
        if (world.func_72964_e(chunkX, chunkZ) == world.func_175726_f(TREASURE_ROOM_POS) && world.field_73011_w.getDimension() == Revival.CONFIG_OPTIONS.dimensionIDTreasure) {
            int counter = 0;
            if (++counter == 1) {
                StructureUtils.generateStructureAt(TREASURE_ROOM, world, TREASURE_ROOM_POS, false);
            }
        }
        if (Revival.CONFIG_OPTIONS.spawnNautilus && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.nautilusSpawnRate, 1)) == 0) {
            for (int i = 0; i < 1 + random.nextInt(3); ++i) {
                int ex = chunkX * 16 + random.nextInt(16);
                zee = chunkZ * 16 + random.nextInt(16);
                why = 30 + random.nextInt(Math.max(world.func_181545_F() - 30, 1));
                if (world.func_180495_p(new BlockPos(ex, why, zee)).func_185904_a() != Material.field_151586_h) continue;
                EntityNautilus fish = new EntityNautilus(world);
                fish.func_70107_b((float)ex + 0.5f, (float)why + 0.5f, (float)zee + 0.5f);
                world.func_72838_d((Entity)fish);
            }
        }
        if (Revival.CONFIG_OPTIONS.spawnCoelacanth && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.coelacanthSpawnRate, 1)) == 0) {
            for (int i = 0; i < 1 + random.nextInt(3); ++i) {
                int ex = chunkX * 16 + random.nextInt(16);
                zee = chunkZ * 16 + random.nextInt(16);
                why = 10 + random.nextInt(25);
                if (world.func_180495_p(new BlockPos(ex, why, zee)).func_185904_a() != Material.field_151586_h) continue;
                EntityCoelacanth fish = new EntityCoelacanth(world);
                fish.func_70107_b((float)ex + 0.5f, (float)why + 0.5f, (float)zee + 0.5f);
                world.func_72838_d((Entity)fish);
            }
        }
        if (Revival.CONFIG_OPTIONS.spawnAlligatorGar && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.alligatorGarSpawnRate, 1)) == 0) {
            for (int i = 0; i < 1 + random.nextInt(3); ++i) {
                int ex = chunkX * 16 + random.nextInt(16);
                zee = chunkZ * 16 + random.nextInt(16);
                why = 40 + random.nextInt(Math.max(world.func_181545_F() - 40, 1));
                if (world.func_180495_p(new BlockPos(ex, why, zee)).func_185904_a() != Material.field_151586_h) continue;
                EntityAlligatorGar fish = new EntityAlligatorGar(world);
                fish.func_70107_b((float)ex + 0.5f, (float)why + 0.5f, (float)zee + 0.5f);
                world.func_72838_d((Entity)fish);
            }
        }
        if (Revival.CONFIG_OPTIONS.spawnSturgeon && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) && random.nextInt(Math.max(Revival.CONFIG_OPTIONS.sturgeonSpawnRate, 1)) == 0) {
            for (int i = 0; i < 1 + random.nextInt(3); ++i) {
                int ex = chunkX * 16 + random.nextInt(16);
                zee = chunkZ * 16 + random.nextInt(16);
                why = 40 + random.nextInt(Math.max(world.func_181545_F() - 40, 1));
                if (world.func_180495_p(new BlockPos(ex, why, zee)).func_185904_a() != Material.field_151586_h) continue;
                EntitySturgeon fish = new EntitySturgeon(world);
                fish.func_70107_b((float)ex + 0.5f, (float)why + 0.5f, (float)zee + 0.5f);
                world.func_72838_d((Entity)fish);
            }
        }
        if (!Revival.CONFIG_OPTIONS.logCascadingWorldGen) {
            ForgeModContainer.logCascadingWorldGeneration = prevLogCascadingWorldGen;
        }
    }

    private static boolean canStructureSpawnInDim(int dimID) {
        for (int ourDimIDs : Revival.CONFIG_OPTIONS.overworldGenerationDimensions) {
            if (ourDimIDs != dimID) continue;
            return true;
        }
        return false;
    }
}

