/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.blocks.BlockIndicator;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;

public class BlockGauge
extends RsBlock
implements ModContent.Colors.ColorTintSupport {
    public static final long GAUGE_DATA_POWER_MASK = 15L;
    public static final int GAUGE_DATA_POWER_SHIFT = 0;
    public static final long GAUGE_DATA_LIGHT_MASK = 240L;
    public static final int GAUGE_DATA_LIGHT_SHIFT = 4;
    public static final long GAUGE_DATA_BLINK_MASK = 3840L;
    public static final int GAUGE_DATA_BLINK_SHIFT = 8;
    public static final long GAUGE_DATA_COLOR_MASK = 61440L;
    public static final int GAUGE_DATA_COLOR_SHIFT = 12;
    public static final long GAUGE_CONFIG_COLOR_TINT_SUPPORT = 65536L;
    public static final long GAUGE_CONFIG_TRANSLUCENT = 131072L;
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    public final long config;
    @Nullable
    public final ModResources.BlockSoundEvent power_on_sound;
    @Nullable
    public final ModResources.BlockSoundEvent power_off_sound;

    public BlockGauge(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(registryName, unrotatedBB, null);
        this.config = config;
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
        this.func_180632_j(this.getBlockStateWithPower(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH), 0));
    }

    public BlockGauge(String registryName, AxisAlignedBB unrotatedBB, long config) {
        this(registryName, unrotatedBB, config, null, null);
    }

    public BlockGauge(String registryName, AxisAlignedBB boundingBox) {
        this(registryName, boundingBox, 0L, null, null);
    }

    public int light_value() {
        return (int)((this.config & 0xF0L) >> 4);
    }

    public int blink_interval() {
        return (int)((this.config & 0xF00L) >> 8) * 200;
    }

    @Override
    public boolean isWallMount() {
        return true;
    }

    public IBlockState getBlockStateWithPower(IBlockState orig, int power) {
        return orig.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power));
    }

    public int getBlockStatePower(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public boolean cmpBlockStatePower(IBlockState state, int power) {
        return (Integer)state.func_177229_b((IProperty)POWER) == power;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
    }

    @Override
    public boolean hasColorMultiplierRGBA() {
        return !ModConfig.optouts.without_color_tinting && (this.config & 0x10000L) != 0L;
    }

    @Override
    public int getColorMultiplierRGBA(@Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        if (pos == null || world == null) {
            return -1;
        }
        TileEntityGauge te = this.getTe(world, pos);
        if (te == null) {
            return -1;
        }
        return ModAuxiliaries.DyeColorFilters.lightTintByIndex(te.color_tint());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return (this.config & 0x20000L) != 0L ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityGauge te = this.getTe(world, pos);
        return this.getBlockStateWithPower(super.func_176221_a(state, world, pos), te == null ? 0 : te.power());
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        if (!this.neighborChangedCheck(state, world, pos, neighborBlock, neighborPos)) {
            return;
        }
        TileEntityGauge te = this.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.reset_timer();
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.onBlockPlacedByCheck(world, pos, state, placer, stack)) {
            world.func_180497_b(pos, state.func_177230_c(), 0, 1);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        TileEntityGauge te = this.getTe((IBlockAccess)world, pos);
        ItemStack item = player.func_184614_ca();
        if (te == null || state == null || item == null) {
            return;
        }
        if (DyeUtils.isDye((ItemStack)item) && (this.config & 0x10000L) != 0L && !ModConfig.optouts.without_color_tinting) {
            int dye = DyeUtils.rawMetaFromStack((ItemStack)item);
            te.color_tint(dye < 0 ? 0 : (dye > 15 ? 15 : dye));
            te.func_70296_d();
            world.markAndNotifyBlock(pos, null, state, state, 23);
            ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.tinting", null, ModAuxiliaries.localizable("switchconfig.tinting." + ModAuxiliaries.DyeColorFilters.nameByIndex[dye & 0xF], null, new Object[0])));
        }
    }

    public int func_149750_m(IBlockState state) {
        return this.light_value();
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWER});
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGauge();
    }

    public TileEntityGauge getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityGauge ? (TileEntityGauge)te : null;
    }

    public static class TileEntityGauge
    extends RsBlock.RsTileEntity
    implements ITickable {
        private long trigger_timer_ = 0L;
        private long scd_ = 0L;
        private boolean force_off_ = false;
        private IBlockState last_state_ = null;

        public int power() {
            return (int)((this.scd_ & 0xFL) >> 0);
        }

        public int color_tint() {
            return (int)((this.scd_ & 0xF000L) >> 12);
        }

        public void power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFFF0L | (long)((p <= 0 ? 0 : (p > 15 ? 15 : p)) << 0) & 0xFL;
        }

        public void color_tint(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFF0FFFL | (long)((p <= 0 ? 0 : (p > 15 ? 15 : p)) << 12) & 0xF000L;
        }

        public boolean force_off() {
            return this.force_off_;
        }

        public void reset_timer() {
            this.trigger_timer_ = 0L;
        }

        public void reset() {
            this.reset((IBlockAccess)this.func_145831_w());
        }

        public void reset(IBlockAccess world) {
            this.trigger_timer_ = 0L;
            if (!(world instanceof World)) {
                this.scd_ = 0L;
            } else {
                try {
                    long current_scd = this.scd_;
                    IBlockState state = world.func_180495_p(this.func_174877_v());
                    if (state.func_177230_c() instanceof BlockGauge) {
                        this.scd_ = (int)((BlockGauge)state.func_177230_c()).config;
                        if (current_scd != this.scd_) {
                            this.func_70296_d();
                        }
                    } else {
                        this.scd_ = 0L;
                    }
                }
                catch (Throwable e) {
                    this.scd_ = 0L;
                }
            }
        }

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            nbt.func_74772_a("scd", this.scd_);
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            this.scd_ = nbt.func_74763_f("scd");
            if (updatePacket && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                this.trigger_timer_ = 0L;
            }
        }

        protected void func_190201_b(World world) {
            super.func_190201_b(world);
            this.reset((IBlockAccess)world);
        }

        public void func_73660_a() {
            if (--this.trigger_timer_ > 0L) {
                return;
            }
            try {
                if (this.field_145850_b.field_72995_K) {
                    this.trigger_timer_ = (long)ModConfig.tweaks.gauge_update_interval * 2L;
                    IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    if (this.last_state_ != (state = ((BlockGauge)state.func_177230_c()).getBlockStateWithPower(state, this.power()))) {
                        this.last_state_ = state;
                        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                    }
                } else {
                    boolean sync;
                    this.trigger_timer_ = ModConfig.tweaks.gauge_update_interval;
                    IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    BlockGauge block = (BlockGauge)state.func_177230_c();
                    BlockPos pos = this.func_174877_v();
                    boolean bl = this.force_off_ = block.blink_interval() > 0 && System.currentTimeMillis() % (long)block.blink_interval() > (long)(block.blink_interval() / 2);
                    if (block.blink_interval() > 0) {
                        this.trigger_timer_ = 5L;
                    }
                    BlockPos neighbourPos = pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)FACING), -1);
                    IBlockState neighborState = this.field_145850_b.func_180495_p(neighbourPos);
                    int p = 0;
                    if (block instanceof BlockIndicator && this.field_145850_b.func_175640_z(this.func_174877_v())) {
                        p = 15;
                    } else if (neighborState != null) {
                        if (neighborState.func_185897_m()) {
                            p = Math.max(neighborState.func_185911_a((IBlockAccess)this.field_145850_b, neighbourPos, ((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176734_d()), neighborState.func_185893_b((IBlockAccess)this.field_145850_b, neighbourPos, ((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176734_d()));
                        } else if (ModConfig.optouts.without_gauge_weak_power_measurement) {
                            p = this.field_145850_b.func_175676_y(neighbourPos);
                        } else {
                            for (EnumFacing nbf : EnumFacing.values()) {
                                int pa;
                                if (p >= 15) break;
                                BlockPos nbp = neighbourPos.func_177972_a(nbf);
                                IBlockState nbs = this.field_145850_b.func_180495_p(nbp);
                                if (nbs == null || !nbs.func_185897_m() || nbs.func_177230_c() instanceof BlockGauge || p >= (pa = Math.max(nbs.func_185893_b((IBlockAccess)this.field_145850_b, nbp, nbf), nbs.func_185911_a((IBlockAccess)this.field_145850_b, nbp, nbf)))) continue;
                                p = pa;
                            }
                        }
                    }
                    if (block.blink_interval() > 0 && this.force_off()) {
                        p = 0;
                    }
                    boolean bl2 = sync = this.power() != p;
                    if (block.power_on_sound != null && this.power() == 0 && p > 0) {
                        block.power_on_sound.play(this.field_145850_b, pos);
                    } else if (block.power_off_sound != null && this.power() > 0 && p == 0) {
                        block.power_off_sound.play(this.field_145850_b, pos);
                    }
                    this.power(p);
                    if (sync) {
                        this.field_145850_b.func_175646_b(pos, (TileEntity)this);
                        this.field_145850_b.func_184138_a(pos, state, block.getBlockStateWithPower(state, p), 22);
                    } else if (!block.cmpBlockStatePower(state, p)) {
                        this.field_145850_b.func_180501_a(pos, block.getBlockStateWithPower(state, p), 20);
                    }
                }
            }
            catch (Throwable e) {
                this.trigger_timer_ = 72000L;
                ModRsGauges.logger.error("TE update() failed: " + e);
            }
        }
    }
}

