/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.blocks.BlockGauge;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModAuxiliaries;

public abstract class RsBlock
extends Block {
    public static final long RSBLOCK_CONFIG_OBSOLETE = Long.MIN_VALUE;
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected final AxisAlignedBB unrotatedBB;
    private static final EnumFacing[][] fast_transform_lut = new EnumFacing[][]{{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}};

    public RsBlock(String registryName, @Nullable AxisAlignedBB unrotatedBoundingBox, @Nullable Material material) {
        super(material != null ? material : ModAuxiliaries.RsMaterials.MATERIAL_METALLIC);
        this.unrotatedBB = unrotatedBoundingBox != null ? unrotatedBoundingBox : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.setRegistryName("rsgauges", registryName);
        this.func_149663_c("rsgauges." + registryName);
        this.func_149713_g(1);
        this.func_149752_b(2.0f);
        if (material != ModAuxiliaries.RsMaterials.MATERIAL_PLANT) {
            this.func_149711_c(0.3f);
        } else {
            this.func_149711_c(0.1f);
            this.func_149672_a(SoundType.field_185850_c);
        }
        this.func_149647_a((CreativeTabs)(this instanceof BlockSwitch && (((BlockSwitch)this).config & Long.MIN_VALUE) != 0L || this instanceof BlockGauge && (((BlockGauge)this).config & Long.MIN_VALUE) != 0L ? null : ModRsGauges.CREATIVE_TAB_RSGAUGES));
    }

    public RsBlock(String registryName) {
        this(registryName, new AxisAlignedBB(0.0, 0.0625, 0.0, 0.5, 0.75, 0.125), null);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isCube();
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return this.isCube() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return !this.isCube() ? field_185506_k : this.func_185496_a(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public boolean func_181623_g() {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.isCube() ? EnumPushReaction.NORMAL : EnumPushReaction.DESTROY;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return !this.isCube();
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighbourPos) {
        this.neighborChangedCheck(state, world, pos, neighborBlock, neighbourPos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.onBlockPlacedByCheck(world, pos, state, placer, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return !this.isCube();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.canPlaceBlockOnSide(world, pos, side, (Predicate<Block>)((Predicate)block -> !RsBlock.func_193382_c((Block)block)), null);
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side, @Nullable Predicate<Block> blockWhiteListFilter, @Nullable Predicate<Block> blockBlackListFilter) {
        if (this.isCube()) {
            return true;
        }
        if (this.isLateral() && !this.isWallMount()) {
            if (side != EnumFacing.UP) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            if (state == null || state.func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) != BlockFaceShape.SOLID) {
                return false;
            }
            if (this.field_149764_J != ModAuxiliaries.RsMaterials.MATERIAL_PLANT) {
                return true;
            }
            return true;
        }
        if (this.isWallMount()) {
            if (this.isLateral() && (side == EnumFacing.UP || side == EnumFacing.DOWN)) {
                return false;
            }
            BlockPos blockpos = pos.func_177972_a(side.func_176734_d());
            IBlockState state = world.func_180495_p(blockpos);
            if (blockBlackListFilter != null && blockBlackListFilter.apply((Object)state.func_177230_c())) {
                return false;
            }
            if (side == EnumFacing.UP) {
                return state.func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) == BlockFaceShape.SOLID;
            }
            if (blockWhiteListFilter != null && blockWhiteListFilter.apply((Object)state.func_177230_c())) {
                return true;
            }
            return !RsBlock.func_193384_b((Block)state.func_177230_c()) && state.func_193401_d((IBlockAccess)world, blockpos, side) == BlockFaceShape.SOLID;
        }
        return super.func_176198_a(world, pos, side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (this.isWallMount() && !this.isLateral()) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        } else if (this.isWallMount() && this.isLateral()) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        } else if (!this.isWallMount() && this.isLateral()) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
        } else {
            Vec3d lv = placer.func_70040_Z();
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176737_a((float)((float)lv.field_72450_a), (float)((float)lv.field_72448_b), (float)((float)lv.field_72449_c)));
        }
        if (this.isOppositePlacement()) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
        }
        return state;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.onRsBlockDestroyed(state, world, pos, false);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB bb = this.getUnrotatedBB(state);
        if (!this.isLateral()) {
            switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, 1.0 - bb.field_72337_e, 1.0 - bb.field_72340_a, 1.0 - bb.field_72339_c, 1.0 - bb.field_72338_b);
                }
                case 1: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72340_a, bb.field_72334_f, bb.field_72337_e);
                }
                case 2: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 3: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 4: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
                case 5: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
            }
        } else {
            switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 1: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 2: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 3: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 4: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
                case 5: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
            }
        }
        return bb;
    }

    public boolean isWallMount() {
        return false;
    }

    public boolean isLateral() {
        return false;
    }

    public boolean isCube() {
        return false;
    }

    public boolean isOppositePlacement() {
        return false;
    }

    public AxisAlignedBB getUnrotatedBB() {
        return this.unrotatedBB;
    }

    public AxisAlignedBB getUnrotatedBB(IBlockState state) {
        return this.getUnrotatedBB();
    }

    protected EnumFacing getAbsoluteFacing(IBlockState state, EnumFacing relativeSide) {
        return state == null || relativeSide == null ? EnumFacing.NORTH : fast_transform_lut[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()][relativeSide.func_176745_a()];
    }

    protected void onRsBlockDestroyed(IBlockState state, World world, BlockPos pos, boolean isUpdateEvent) {
    }

    protected boolean neighborChangedCheck(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        if (this.isCube()) {
            return true;
        }
        if (!this.isWallMount() ? !pos.func_177977_b().equals((Object)neighborPos) : (!this.isLateral() ? !pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()).equals((Object)neighborPos) : !pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)).equals((Object)neighborPos))) {
            return false;
        }
        IBlockState neighborState = world.func_180495_p(neighborPos);
        if (neighborState == null) {
            return false;
        }
        if (world.func_175623_d(neighborPos) || neighborState.func_185904_a().func_76224_d()) {
            if (!world.field_72995_K) {
                this.onRsBlockDestroyed(state, world, pos, true);
                world.func_175698_g(pos);
                this.func_176226_b(world, pos, state, 0);
            }
            return false;
        }
        return true;
    }

    protected boolean onBlockPlacedByCheck(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.isCube() || this.func_176198_a(world, pos, this.isWallMount() ? (EnumFacing)state.func_177229_b((IProperty)FACING) : EnumFacing.UP)) {
            return true;
        }
        if (world.field_72995_K) {
            return false;
        }
        this.onRsBlockDestroyed(state, world, pos, false);
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public static class RsTileEntity
    extends TileEntity {
        private static final int NBT_ENTITY_TYPE = 1;

        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
        }

        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(os.func_177230_c() instanceof RsBlock) || !(ns.func_177230_c() instanceof RsBlock);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writeNbt(nbt, false);
            return nbt;
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readNbt(nbt, false);
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            super.func_145839_a(pkt.func_148857_g());
            this.readNbt(pkt.func_148857_g(), true);
            super.onDataPacket(net, pkt);
        }

        public NBTTagCompound func_189517_E_() {
            NBTTagCompound nbt = new NBTTagCompound();
            super.func_189515_b(nbt);
            this.writeNbt(nbt, true);
            return nbt;
        }

        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void handleUpdateTag(NBTTagCompound tag) {
            this.func_145839_a(tag);
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return 2304.0;
        }

        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getRenderBoundingBox() {
            return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
        }
    }
}

