/*
 * Decompiled with CFR 0.152.
 */
package nc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import nc.config.NCConfig;
import nc.enumm.ICoolingComponentEnum;
import nc.enumm.MetaEnums;
import nc.multiblock.turbine.TurbineDynamoCoilType;
import nc.radiation.RadiationHelper;
import nc.recipe.BasicRecipe;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;

public class NCInfo {
    public static String[] fissionFuelInfo(BasicRecipe fuelInfo) {
        ArrayList list = Lists.newArrayList((Object[])new String[]{Lang.localise("info.nuclearcraft.fission_fuel.desc"), Lang.localise("info.nuclearcraft.fission_fuel.base_time.desc", UnitHelper.applyTimeUnit(fuelInfo.getFissionFuelTime(), 3)), Lang.localise("info.nuclearcraft.fission_fuel.base_heat.desc", UnitHelper.prefix(fuelInfo.getFissionFuelHeat(), 5, "H/t")), Lang.localise("info.nuclearcraft.fission_fuel.base_efficiency.desc", NCMath.pcDecimalPlaces(fuelInfo.getFissionFuelEfficiency(), 1)), Lang.localise("info.nuclearcraft.fission_fuel.criticality.desc", fuelInfo.getFissionFuelCriticality() + " N/t")});
        if (NCConfig.fission_decay_mechanics) {
            list.add(Lang.localise("info.nuclearcraft.fission_fuel.decay_factor.desc", NCMath.pcDecimalPlaces(fuelInfo.getFissionFuelDecayFactor(), 1)));
        }
        if (fuelInfo.getFissionFuelSelfPriming()) {
            list.add(Lang.localise("info.nuclearcraft.fission_fuel.self_priming.desc"));
        }
        return list.toArray(new String[list.size()]);
    }

    public static <T extends Enum<T> & ICoolingComponentEnum> String[][] coolingFixedInfo(T[] values, String name) {
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = NCInfo.coolingRateInfo(values[i], name);
        }
        return info;
    }

    public static <T extends Enum<T>> String[] coolingRateInfo(T type, String name) {
        return NCInfo.coolingRateInfo(((ICoolingComponentEnum)((Object)type)).getCooling(), name);
    }

    public static String[] coolingRateInfo(int cooling, String name) {
        return new String[]{Lang.localise("tile.nuclearcraft." + name + ".cooling_rate") + " " + cooling + " H/t"};
    }

    public static String[][] heatSinkFixedInfo() {
        return NCInfo.coolingFixedInfo((Enum[])MetaEnums.HeatSinkType.values(), (String)"solid_fission_sink");
    }

    public static String[][] heatSinkFixedInfo2() {
        return NCInfo.coolingFixedInfo((Enum[])MetaEnums.HeatSinkType2.values(), (String)"solid_fission_sink");
    }

    public static String[][] coolantHeaterFixedInfo() {
        return NCInfo.coolingFixedInfo((Enum[])MetaEnums.CoolantHeaterType.values(), (String)"salt_fission_heater");
    }

    public static String[][] coolantHeaterFixedInfo2() {
        return NCInfo.coolingFixedInfo((Enum[])MetaEnums.CoolantHeaterType2.values(), (String)"salt_fission_heater");
    }

    public static String[][] neutronSourceFixedInfo() {
        MetaEnums.NeutronSourceType[] values = MetaEnums.NeutronSourceType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = NCInfo.neutronSourceEfficiencyInfo(values[i].getEfficiency());
        }
        return info;
    }

    public static String[] neutronSourceEfficiencyInfo(double efficiency) {
        return new String[]{Lang.localise("info.nuclearcraft.fission_source.efficiency.fixd", NCMath.pcDecimalPlaces(efficiency, 1))};
    }

    public static String[][] neutronSourceInfo() {
        MetaEnums.NeutronSourceType[] values = MetaEnums.NeutronSourceType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = NCInfo.neutronSourceDescriptionInfo();
        }
        return info;
    }

    public static String[] neutronSourceDescriptionInfo() {
        return InfoHelper.formattedInfo(Lang.localise("tile.nuclearcraft.fission_source.desc"), new Object[0]);
    }

    public static String[][] neutronShieldFixedInfo() {
        MetaEnums.NeutronShieldType[] values = MetaEnums.NeutronShieldType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = NCInfo.neutronShieldStatInfo(values[i].getHeatPerFlux(), values[i].getEfficiency());
        }
        return info;
    }

    public static String[] neutronShieldStatInfo(double heatPerFlux, double efficiency) {
        return new String[]{Lang.localise("info.nuclearcraft.fission_shield.heat_per_flux.fixd", UnitHelper.prefix(heatPerFlux, 5, "H/N")), Lang.localise("info.nuclearcraft.fission_shield.efficiency.fixd", NCMath.pcDecimalPlaces(efficiency, 1))};
    }

    public static String[][] neutronShieldInfo() {
        MetaEnums.NeutronShieldType[] values = MetaEnums.NeutronShieldType.values();
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = NCInfo.neutronShieldDescriptionInfo();
        }
        return info;
    }

    public static String[] neutronShieldDescriptionInfo() {
        return InfoHelper.formattedInfo(Lang.localise("tile.nuclearcraft.fission_shield.desc"), new Object[0]);
    }

    public static String[] fissionModeratorFixedInfo(BasicRecipe moderatorInfo) {
        return new String[]{Lang.localise("info.nuclearcraft.moderator.fixd"), Lang.localise("info.nuclearcraft.moderator.flux_factor.fixd", moderatorInfo.getFissionModeratorFluxFactor() + " N/t"), Lang.localise("info.nuclearcraft.moderator.efficiency.fixd", NCMath.pcDecimalPlaces(moderatorInfo.getFissionModeratorEfficiency(), 1))};
    }

    public static String[] fissionModeratorInfo() {
        return InfoHelper.formattedInfo(Lang.localise("info.nuclearcraft.moderator.desc", NCConfig.fission_neutron_reach, NCConfig.fission_neutron_reach / 2), new Object[0]);
    }

    public static String[] fissionReflectorFixedInfo(BasicRecipe reflectorInfo) {
        return new String[]{Lang.localise("info.nuclearcraft.reflector.fixd"), Lang.localise("info.nuclearcraft.reflector.reflectivity.fixd", NCMath.pcDecimalPlaces(reflectorInfo.getFissionReflectorReflectivity(), 1)), Lang.localise("info.nuclearcraft.reflector.efficiency.fixd", NCMath.pcDecimalPlaces(reflectorInfo.getFissionReflectorEfficiency(), 1))};
    }

    public static String[] fissionReflectorInfo() {
        return InfoHelper.formattedInfo(Lang.localise("info.nuclearcraft.reflector.desc"), new Object[0]);
    }

    public static String[][] dynamoCoilFixedInfo() {
        String[][] info = new String[TurbineDynamoCoilType.values().length][];
        for (int i = 0; i < TurbineDynamoCoilType.values().length; ++i) {
            info[i] = NCInfo.coilConductivityInfo(i);
        }
        return info;
    }

    public static String[] coilConductivityInfo(int meta) {
        return NCInfo.coilConductivityInfo(TurbineDynamoCoilType.values()[meta].getConductivity());
    }

    public static String[] coilConductivityInfo(double conductivity) {
        return new String[]{Lang.localise("tile.nuclearcraft.turbine_dynamo_coil.conductivity") + " " + NCMath.pcDecimalPlaces(conductivity, 1)};
    }

    public static String[][] upgradeInfo() {
        String[][] info = new String[MetaEnums.UpgradeType.values().length][];
        for (int i = 0; i < MetaEnums.UpgradeType.values().length; ++i) {
            info[i] = InfoHelper.EMPTY_ARRAY;
        }
        info[0] = InfoHelper.formattedInfo(Lang.localise("item.nuclearcraft.upgrade.speed_desc", NCInfo.powerAdverb(NCConfig.speed_upgrade_power_laws_fp[0], "increase", "with"), NCInfo.powerAdverb(NCConfig.speed_upgrade_power_laws_fp[1], "increase", "")), new Object[0]);
        info[1] = InfoHelper.formattedInfo(Lang.localise("item.nuclearcraft.upgrade.energy_desc", NCInfo.powerAdverb(NCConfig.energy_upgrade_power_laws_fp[0], "decrease", "with")), new Object[0]);
        return info;
    }

    public static String powerAdverb(double power, String verb, String preposition) {
        if (power != (double)((int)power)) {
            verb = verb + "_approximately";
        }
        verb = Lang.localise("nc.sf." + verb);
        int p = (int)Math.round(power);
        preposition = "nc.sf." + preposition;
        return Lang.canLocalise(preposition) ? Lang.localise("nc.sf.power_adverb_preposition", Lang.localise("nc.sf.power_adverb" + p, verb), Lang.localise(preposition)) : Lang.localise("nc.sf.power_adverb" + p, verb);
    }

    public static String[][] radShieldingInfo() {
        String[][] info = new String[MetaEnums.RadShieldingType.values().length][];
        for (int i = 0; i < MetaEnums.RadShieldingType.values().length; ++i) {
            info[i] = InfoHelper.formattedInfo(Lang.localise("item.nuclearcraft.rad_shielding.desc" + (NCConfig.radiation_hardcore_containers > 0.0 ? "_hardcore" : ""), RadiationHelper.resistanceSigFigs(NCConfig.radiation_shielding_level[i])), new Object[0]);
        }
        return info;
    }
}

