/*
 * Decompiled with CFR 0.152.
 */
package nc.block;

import java.util.List;
import javax.annotation.Nullable;
import nc.block.IBlockMeta;
import nc.enumm.IBlockMetaEnum;
import nc.enumm.IMetaEnum;
import nc.enumm.MetaEnums;
import nc.tab.NCTabs;
import nc.tile.ITile;
import nc.util.CollectionHelper;
import nc.util.NCInventoryHelper;
import nc.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMeta<T extends Enum<T> & IBlockMetaEnum>
extends Block
implements IBlockMeta {
    public final T[] values;
    public final PropertyEnum<T> type;
    protected boolean canSustainPlant = true;
    protected boolean canCreatureSpawn = true;
    protected static boolean keepInventory;

    public BlockMeta(Class<T> enumm, PropertyEnum<T> property, Material material) {
        super(material);
        this.values = (Enum[])enumm.getEnumConstants();
        this.type = property;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, this.values[0]));
        this.setMetaHarvestLevels();
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
    }

    @Override
    public String getMetaName(ItemStack stack) {
        return ((IStringSerializable)this.values[StackHelper.getMetadata(stack)]).func_176610_l();
    }

    public void setMetaHarvestLevels() {
        for (Enum nextState : CollectionHelper.asList(this.values)) {
            this.setHarvestLevel(((IBlockMetaEnum)((Object)nextState)).getHarvestTool(), ((IBlockMetaEnum)((Object)nextState)).getHarvestLevel(), this.func_176203_a(((IMetaEnum)((Object)nextState)).getID()));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IBlockMetaEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getLightValue();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((IBlockMetaEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((IBlockMetaEnum)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))))).getResistance();
    }

    public int func_176201_c(IBlockState state) {
        return ((IMetaEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getID();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.type, this.values[meta]);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.values.length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.canSustainPlant && super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType placementType) {
        return this.canCreatureSpawn && super.canCreatureSpawn(state, world, pos, placementType);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (this instanceof ITileEntityProvider && (tile = world.func_175625_s(pos)) instanceof ITile) {
            ((ITile)tile).onBlockNeighborChanged(state, world, pos, fromPos);
        }
    }

    public void dropItems(World world, BlockPos pos, IInventory inventory) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inventory);
    }

    public void dropItems(World world, BlockPos pos, List<ItemStack> stacks) {
        NCInventoryHelper.dropInventoryItems(world, pos, stacks);
    }

    public static class BlockFissionReflector
    extends BlockMeta<MetaEnums.NeutronReflectorType> {
        public static final PropertyEnum<MetaEnums.NeutronReflectorType> TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.NeutronReflectorType.class);

        public BlockFissionReflector() {
            super(MetaEnums.NeutronReflectorType.class, TYPE, Material.field_151573_f);
            this.func_149647_a(NCTabs.MULTIBLOCK);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }
    }

    public static class BlockFertileIsotope
    extends BlockMeta<MetaEnums.FertileIsotopeType> {
        public static final PropertyEnum<MetaEnums.FertileIsotopeType> TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.FertileIsotopeType.class);

        public BlockFertileIsotope() {
            super(MetaEnums.FertileIsotopeType.class, TYPE, Material.field_151576_e);
            this.func_149647_a(NCTabs.MATERIAL);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }
    }

    public static class BlockIngot
    extends BlockMeta<MetaEnums.IngotType> {
        public static final PropertyEnum<MetaEnums.IngotType> TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.IngotType.class);

        public BlockIngot() {
            super(MetaEnums.IngotType.class, TYPE, Material.field_151573_f);
            this.func_149647_a(NCTabs.MATERIAL);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }

        public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return ((MetaEnums.IngotType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))).getFireSpreadSpeed();
        }

        public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return ((MetaEnums.IngotType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))).getFlammability();
        }

        public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
            return ((MetaEnums.IngotType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))).isFireSource();
        }
    }

    public static class BlockOre
    extends BlockMeta<MetaEnums.OreType> {
        public static final PropertyEnum<MetaEnums.OreType> TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.OreType.class);

        public BlockOre() {
            super(MetaEnums.OreType.class, TYPE, Material.field_151576_e);
            this.func_149647_a(NCTabs.MATERIAL);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }

        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }
    }
}

