/*
 * Decompiled with CFR 0.152.
 */
package nc.block.item;

import java.util.List;
import javax.annotation.Nullable;
import nc.block.IBlockMeta;
import nc.util.InfoHelper;
import nc.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockMeta
extends ItemBlock {
    private final TextFormatting[] fixedColors;
    private final TextFormatting infoColor;
    public final String[][] fixedInfo;
    public final String[][] info;

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, TextFormatting[] fixedColors, String[][] fixedTooltips, TextFormatting infoColor, String[] ... tooltips) {
        super(block);
        if (!(block instanceof IBlockMeta)) {
            throw new IllegalArgumentException(String.format("The block %s for this ItemBlockMeta is not an instance of IBlockMeta!", block.func_149739_a()));
        }
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.fixedColors = fixedColors;
        this.fixedInfo = InfoHelper.buildFixedInfo(block.func_149739_a(), enumm, fixedTooltips);
        this.infoColor = infoColor;
        this.info = InfoHelper.buildInfo(block.func_149739_a(), enumm, tooltips);
    }

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, TextFormatting fixedColor, String[][] fixedTooltips, TextFormatting infoColor, String[] ... tooltips) {
        this(block, enumm, new TextFormatting[]{fixedColor}, fixedTooltips, infoColor, tooltips);
    }

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, TextFormatting infoColor, String[] ... tooltips) {
        this(block, enumm, TextFormatting.RED, InfoHelper.EMPTY_ARRAYS, infoColor, tooltips);
    }

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, String[] ... tooltips) {
        this(block, enumm, TextFormatting.RED, InfoHelper.EMPTY_ARRAYS, TextFormatting.AQUA, tooltips);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + ((IBlockMeta)this.field_150939_a).getMetaName(stack);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        int meta = StackHelper.getMetadata(stack);
        if (this.fixedInfo.length > meta && this.info.length > meta) {
            if (this.fixedColors.length == 1) {
                InfoHelper.infoFull(tooltip, this.fixedColors[0], this.fixedInfo[meta], this.infoColor, this.info[meta]);
            } else {
                InfoHelper.infoFull(tooltip, this.fixedColors, this.fixedInfo[meta], this.infoColor, this.info[meta]);
            }
        }
    }
}

