/*
 * Decompiled with CFR 0.152.
 */
package nc.block.item;

import java.util.List;
import javax.annotation.Nullable;
import nc.util.InfoHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NCItemBlock
extends ItemBlock {
    private final TextFormatting[] fixedColors;
    private final TextFormatting infoColor;
    public final String[] fixedInfo;
    public final String[] info;

    public NCItemBlock(Block block, TextFormatting[] fixedColors, String[] fixedTooltip, TextFormatting infoColor, String ... tooltip) {
        super(block);
        this.fixedColors = fixedColors;
        this.fixedInfo = InfoHelper.buildFixedInfo(block.func_149739_a(), fixedTooltip);
        this.infoColor = infoColor;
        this.info = InfoHelper.buildInfo(block.func_149739_a(), tooltip);
    }

    public NCItemBlock(Block block, TextFormatting fixedColor, String[] fixedTooltip, TextFormatting infoColor, String ... tooltip) {
        this(block, new TextFormatting[]{fixedColor}, fixedTooltip, infoColor, tooltip);
    }

    public NCItemBlock(Block block, TextFormatting infoColor, String ... tooltip) {
        this(block, TextFormatting.RED, InfoHelper.EMPTY_ARRAY, infoColor, tooltip);
    }

    public NCItemBlock(Block block, String ... tooltip) {
        this(block, TextFormatting.RED, InfoHelper.EMPTY_ARRAY, TextFormatting.AQUA, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        if (this.fixedInfo.length > 0 || this.info.length > 0) {
            if (this.fixedColors.length == 1) {
                InfoHelper.infoFull(tooltip, this.fixedColors[0], this.fixedInfo, this.infoColor, this.info);
            } else {
                InfoHelper.infoFull(tooltip, this.fixedColors, this.fixedInfo, this.infoColor, this.info);
            }
        }
    }
}

