/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile;

import nc.block.property.BlockProperties;
import nc.block.tile.BlockTile;
import nc.block.tile.IActivatable;
import nc.block.tile.ITileType;
import nc.enumm.BlockEnums;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockActivatable
extends BlockTile
implements IActivatable,
ITileType {
    protected final BlockEnums.ActivatableTileType type;

    public BlockActivatable(BlockEnums.ActivatableTileType type) {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
        if (type.getCreativeTab() != null) {
            this.func_149647_a(type.getCreativeTab());
        }
        this.type = type;
    }

    @Override
    public String getTileName() {
        return this.type.func_176610_l();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type.getTile();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE});
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public static class Transparent
    extends BlockActivatable {
        protected final boolean smartRender;

        public Transparent(BlockEnums.ActivatableTileType type, boolean smartRender) {
            super(type);
            this.func_149711_c(1.5f);
            this.func_149752_b(10.0f);
            this.smartRender = smartRender;
        }

        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
            if (!this.smartRender) {
                return true;
            }
            IBlockState otherState = world.func_180495_p(pos.func_177972_a(side));
            Block block = otherState.func_177230_c();
            if (state != otherState) {
                return true;
            }
            return block == this ? false : super.func_176225_a(state, world, pos, side);
        }
    }
}

