/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.processor;

import java.util.Random;
import nc.NuclearCraft;
import nc.block.property.BlockProperties;
import nc.block.tile.IActivatable;
import nc.tab.NCTabs;
import nc.tile.processor.TileNuclearFurnace;
import nc.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNuclearFurnace
extends Block
implements ITileEntityProvider,
IActivatable {
    public BlockNuclearFurnace() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(NCTabs.MACHINE);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileNuclearFurnace();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta & 7));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)enumfacing).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.FACING_HORIZONTAL, BlockProperties.ACTIVE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BlockHelper.setDefaultFacing(world, pos, state, (PropertyEnum<EnumFacing>)BlockProperties.FACING_HORIZONTAL);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null || hand != EnumHand.MAIN_HAND || player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileNuclearFurnace) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)NuclearCraft.instance, (int)0, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.4;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.52;
        double d4 = rand.nextDouble() * 0.6 - 0.3;
        if (rand.nextDouble() < 0.2) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        switch (facing) {
            case WEST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileNuclearFurnace) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileNuclearFurnace)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }
}

