/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.processor;

import com.google.common.collect.Lists;
import java.util.List;
import nc.gui.NCGui;
import nc.gui.element.GuiItemRenderer;
import nc.init.NCItems;
import nc.tile.energy.ITileEnergy;
import nc.tile.processor.TileItemProcessor;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiItemProcessor
extends NCGui {
    protected final EntityPlayer player;
    protected final TileItemProcessor tile;
    protected final ResourceLocation gui_textures;
    protected GuiItemRenderer speedUpgradeRender = null;
    protected GuiItemRenderer energyUpgradeRender = null;

    public GuiItemProcessor(String name, EntityPlayer player, TileItemProcessor tile, Container inventory) {
        super(inventory);
        this.player = player;
        this.tile = tile;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/" + name + ".png");
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected int getCookProgressScaled(int pixels) {
        if (this.tile.baseProcessTime / this.tile.getSpeedMultiplier() < 4.0) {
            return this.tile.isProcessing ? pixels : 0;
        }
        double i = this.tile.time;
        double j = this.tile.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * (double)pixels / j) : 0;
    }

    @Override
    public void drawEnergyTooltip(ITileEnergy tileEnergy, int mouseX, int mouseY, int x, int y, int drawWidth, int drawHeight) {
        if (this.tile.defaultProcessPower != 0.0) {
            super.drawEnergyTooltip(tileEnergy, mouseX, mouseY, x, y, drawWidth, drawHeight);
        } else {
            this.drawNoEnergyTooltip(mouseX, mouseY, x, y, drawWidth, drawHeight);
        }
    }

    @Override
    public List<String> energyInfo(ITileEnergy tileEnergy) {
        String energy = UnitHelper.prefix(tileEnergy.getEnergyStorage().getEnergyStoredLong(), tileEnergy.getEnergyStorage().getMaxEnergyStoredLong(), 5, "RF");
        String power = UnitHelper.prefix(this.tile.getProcessPower(), 5, "RF/t");
        String speedMultiplier = "x" + NCMath.decimalPlaces(this.tile.getSpeedMultiplier(), 2);
        String powerMultiplier = "x" + NCMath.decimalPlaces(this.tile.getPowerMultiplier(), 2);
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.nc.container.energy_stored") + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.nc.container.process_power") + TextFormatting.WHITE + " " + power, TextFormatting.AQUA + Lang.localise("gui.nc.container.speed_multiplier") + TextFormatting.WHITE + " " + speedMultiplier, TextFormatting.AQUA + Lang.localise("gui.nc.container.power_multiplier") + TextFormatting.WHITE + " " + powerMultiplier});
    }

    protected void drawUpgradeRenderers() {
        if (this.speedUpgradeRender == null) {
            this.speedUpgradeRender = new GuiItemRenderer(NCItems.upgrade, 0, this.field_147003_i + 132, this.field_147009_r + this.field_147000_g - 102, 0.5f);
        }
        if (this.energyUpgradeRender == null) {
            this.energyUpgradeRender = new GuiItemRenderer(NCItems.upgrade, 1, this.field_147003_i + 152, this.field_147009_r + this.field_147000_g - 102, 0.5f);
        }
        this.speedUpgradeRender.draw();
        this.energyUpgradeRender.draw();
    }
}

