/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.radiation.RadiationHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.util.Lang;
import nc.util.UnitHelper;
import net.minecraft.util.text.TextFormatting;

public abstract class JEIMachineRecipeWrapper<WRAPPER extends JEIMachineRecipeWrapper<WRAPPER>>
extends JEIBasicRecipeWrapper<WRAPPER> {
    private final int infoX;
    private final int infoY;
    private final int infoWidth;
    private final int infoHeight;
    private static final String BASE_TIME = Lang.localise("jei.nuclearcraft.base_process_time");
    private static final String BASE_POWER = Lang.localise("jei.nuclearcraft.base_process_power");
    private static final String BASE_RADIATION = Lang.localise("jei.nuclearcraft.base_process_radiation");

    public JEIMachineRecipeWrapper(IGuiHelper guiHelper, NCJEI.IJEIHandler<WRAPPER> handler, BasicRecipeHandler recipeHandler, BasicRecipe recipe, int backX, int backY, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY, int infoX, int infoY, int infoWidth, int infoHeight) {
        super(guiHelper, handler, recipeHandler, recipe, backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY);
        this.infoX = infoX - backX;
        this.infoY = infoY - backY;
        this.infoWidth = infoWidth;
        this.infoHeight = infoHeight;
    }

    @Override
    protected int getProgressArrowTime() {
        return (int)(this.getBaseProcessTime() / 4.0);
    }

    protected abstract double getBaseProcessTime();

    protected abstract double getBaseProcessPower();

    protected double getBaseProcessRadiation() {
        if (this.recipe == null) {
            return 0.0;
        }
        return this.recipe.getBaseProcessRadiation();
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mouseX >= this.infoX && mouseY >= this.infoY && mouseX < this.infoX + this.infoWidth + 1 && mouseY < this.infoY + this.infoHeight + 1) {
            tooltip.add(TextFormatting.GREEN + BASE_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getBaseProcessTime(), 3));
            tooltip.add(TextFormatting.LIGHT_PURPLE + BASE_POWER + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getBaseProcessPower(), 5, "RF/t"));
            double radiation = this.getBaseProcessRadiation();
            if (radiation > 0.0) {
                tooltip.add(TextFormatting.GOLD + BASE_RADIATION + " " + RadiationHelper.radsColoredPrefix(radiation, true));
            }
        }
        return tooltip;
    }
}

