/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCItems;
import nc.item.NCItemMeta;
import nc.radiation.RadiationHelper;
import nc.util.Lang;
import nc.util.StackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemRadShielding
extends NCItemMeta<MetaEnums.RadShieldingType> {
    private static final String NOT_HARDCORE = Lang.localise("item.nuclearcraft.rad_shielding.not_hardcore");
    private static final String INSTALL_FAIL = Lang.localise("item.nuclearcraft.rad_shielding.install_fail");
    private static final String INSTALL_SUCCESS = Lang.localise("item.nuclearcraft.rad_shielding.install_success");

    public ItemRadShielding(String[] ... tooltips) {
        super(MetaEnums.RadShieldingType.class, tooltips);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!NCConfig.radiation_tile_shielding || !player.func_70093_af()) {
            return this.actionResult(false, stack);
        }
        IEntityRads playerRads = null;
        if (player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        }
        if (NCConfig.radiation_hardcore_containers <= 0.0) {
            if (!world.field_72995_K) {
                if (playerRads != null) {
                    playerRads.setMessageCooldownTime(20);
                }
                player.func_145747_a((ITextComponent)new TextComponentString(NOT_HARDCORE));
            }
            return this.actionResult(false, stack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(world, player, false);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return this.actionResult(false, stack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing side = raytraceresult.field_178784_b;
        if (!world.func_175660_a(player, pos) || tile == null || !tile.hasCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null) || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return this.actionResult(false, stack);
        }
        IRadiationResistance resistance = (IRadiationResistance)tile.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        if (resistance == null) {
            return this.actionResult(false, stack);
        }
        double newResistance = NCConfig.radiation_shielding_level[StackHelper.getMetadata(stack)];
        if (newResistance <= resistance.getShieldingRadResistance()) {
            if (!world.field_72995_K) {
                if (playerRads != null) {
                    playerRads.setMessageCooldownTime(20);
                }
                player.func_145747_a((ITextComponent)new TextComponentString(INSTALL_FAIL + " " + RadiationHelper.resistanceSigFigs(resistance.getShieldingRadResistance())));
            }
            return this.actionResult(false, stack);
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
            for (int i = MetaEnums.RadShieldingType.values().length; i > 0; --i) {
                if (!(resistance.getShieldingRadResistance() >= NCConfig.radiation_shielding_level[i - 1])) continue;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(NCItems.rad_shielding, 1, i - 1));
                break;
            }
        }
        resistance.setShieldingRadResistance(newResistance);
        tile.func_70296_d();
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(INSTALL_SUCCESS + " " + RadiationHelper.resistanceSigFigs(resistance.getShieldingRadResistance())));
        } else {
            player.func_184185_a(SoundEvents.field_187692_g, 0.5f, 1.0f);
        }
        return this.actionResult(true, stack);
    }
}

