/*
 * Decompiled with CFR 0.152.
 */
package nc.item.energy;

import ic2.api.item.IElectricItemManager;
import nc.config.NCConfig;
import nc.item.energy.IChargableItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class ElectricItemManager
implements IElectricItemManager {
    public IChargableItem item;

    public static ElectricItemManager getElectricItemManager(IChargableItem item) {
        ElectricItemManager manager = new ElectricItemManager();
        manager.item = item;
        return manager;
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.item.canReceive(stack)) {
            double energyToStore = Math.min(Math.min(amount * (double)NCConfig.rf_per_eu, Math.pow(10.0, 1 + this.item.getEnergyTier(stack)) * (double)NCConfig.rf_per_eu), (double)(this.item.getMaxEnergyStored(stack) - this.item.getEnergyStored(stack)));
            if (!simulate) {
                this.item.setEnergyStored(stack, this.item.getEnergyStored(stack) + (long)((int)(energyToStore / (double)stack.func_190916_E())));
            }
            return (int)Math.round(energyToStore / (double)NCConfig.rf_per_eu);
        }
        return 0.0;
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (this.item.canExtract(stack)) {
            double energyToGive = Math.min(Math.min(amount * (double)NCConfig.rf_per_eu, Math.pow(10.0, 1 + this.item.getEnergyTier(stack)) * (double)NCConfig.rf_per_eu), (double)this.item.getEnergyStored(stack));
            if (!simulate) {
                this.item.setEnergyStored(stack, this.item.getEnergyStored(stack) - (long)((int)(energyToGive / (double)stack.func_190916_E())));
            }
            return Math.round(energyToGive / (double)NCConfig.rf_per_eu);
        }
        return 0.0;
    }

    public double getCharge(ItemStack stack) {
        return (double)this.item.getEnergyStored(stack) / (double)NCConfig.rf_per_eu;
    }

    public double getMaxCharge(ItemStack stack) {
        return (double)this.item.getMaxEnergyStored(stack) / (double)NCConfig.rf_per_eu;
    }

    public boolean canUse(ItemStack stack, double amount) {
        return this.getCharge(stack) >= amount;
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return false;
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack stack) {
        return null;
    }

    public int getTier(ItemStack stack) {
        return this.item.getEnergyTier(stack);
    }
}

