/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import nc.multiblock.IMultiblockLogic;
import nc.multiblock.Multiblock;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.salt.MoltenSaltFissionLogic;
import nc.multiblock.fission.solid.SolidFuelFissionLogic;
import nc.multiblock.heatExchanger.CondenserLogic;
import nc.multiblock.heatExchanger.HeatExchanger;
import nc.multiblock.heatExchanger.HeatExchangerLogic;
import nc.multiblock.tile.ITileLogicMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.multiblock.tile.manager.ITileManager;
import nc.multiblock.tile.manager.ITileManagerListener;
import nc.multiblock.tile.port.ITilePort;
import nc.multiblock.tile.port.ITilePortTarget;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineLogic;
import nc.tile.ITileFiltered;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.util.PosHelper;
import nc.util.SuperMap;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MultiblockLogic<MULTIBLOCK extends Multiblock<MULTIBLOCK, T>, LOGIC extends MultiblockLogic<MULTIBLOCK, LOGIC, T>, T extends ITileLogicMultiblockPart<MULTIBLOCK, LOGIC, T>>
implements IMultiblockLogic<MULTIBLOCK, LOGIC, T> {
    protected final MULTIBLOCK multiblock;
    protected Random rand = new Random();

    public MultiblockLogic(MULTIBLOCK multiblock) {
        this.multiblock = multiblock;
    }

    public MultiblockLogic(MultiblockLogic<MULTIBLOCK, LOGIC, T> oldLogic) {
        this.multiblock = oldLogic.multiblock;
    }

    @Override
    public abstract String getID();

    @Override
    public World getWorld() {
        return ((Multiblock)this.multiblock).WORLD;
    }

    public SuperMap<Long, T, Long2ObjectMap<? extends T>> getPartSuperMap() {
        return ((Multiblock)this.multiblock).getPartSuperMap();
    }

    public <TYPE extends T> Long2ObjectMap<TYPE> getPartMap(Class<TYPE> type) {
        return (Long2ObjectMap)this.getPartSuperMap().get(type);
    }

    public <TYPE extends T> int getPartCount(Class<TYPE> type) {
        return this.getPartMap(type).size();
    }

    public <TYPE extends T> Collection<TYPE> getParts(Class<TYPE> type) {
        return this.getPartMap(type).values();
    }

    public <TYPE extends T> Iterator<TYPE> getPartIterator(Class<TYPE> type) {
        return this.getParts(type).iterator();
    }

    public abstract int getMinimumInteriorLength();

    public abstract int getMaximumInteriorLength();

    public void onAttachedPartWithMultiblockData(T part, NBTTagCompound data) {
    }

    public void onBlockAdded(T newPart) {
    }

    public void onBlockRemoved(T oldPart) {
    }

    public abstract void onMachineAssembled();

    public abstract void onMachineRestored();

    public abstract void onMachinePaused();

    public abstract void onMachineDisassembled();

    public abstract void onAssimilate(MULTIBLOCK var1);

    public abstract void onAssimilated(MULTIBLOCK var1);

    public abstract boolean isMachineWhole();

    public abstract boolean onUpdateServer();

    public abstract void onUpdateClient();

    public boolean containsBlacklistedPart() {
        for (Pair<Class<T>, String> pair : this.getPartBlacklist()) {
            LongIterator longIterator = this.getPartMap((Class)pair.getLeft()).keySet().iterator();
            if (!longIterator.hasNext()) continue;
            long posLong = (Long)longIterator.next();
            ((Multiblock)this.multiblock).setLastError((String)pair.getRight(), BlockPos.func_177969_a((long)posLong), new Object[0]);
            return true;
        }
        return false;
    }

    public abstract List<Pair<Class<? extends T>, String>> getPartBlacklist();

    public <PORT extends ITilePort<MULTIBLOCK, LOGIC, T, PORT, TARGET> & ITileFiltered, PRT extends T, TARGET extends ITilePortTarget<MULTIBLOCK, LOGIC, T, PORT, TARGET> & ITileFiltered, TRGT extends T> void refreshFilteredPorts(Class<PORT> portClass, Class<TARGET> targetClass) {
        this.refreshFilteredPorts(portClass, portClass, targetClass, targetClass);
    }

    private <PORT extends ITilePort<MULTIBLOCK, LOGIC, T, PORT, TARGET> & ITileFiltered, PRT extends T, TARGET extends ITilePortTarget<MULTIBLOCK, LOGIC, T, PORT, TARGET> & ITileFiltered, TRGT extends T> void refreshFilteredPorts(Class<PORT> portClass, Class<PRT> portClz, Class<TARGET> targetClass, Class<TRGT> targetClz) {
        ITilePort master;
        Object filter;
        Long2ObjectMap<PRT> portMap = this.getPartMap(portClz);
        Long2ObjectMap<TRGT> targetMap = this.getPartMap(targetClz);
        for (ITilePortTarget target : targetMap.values()) {
            target.clearMasterPort();
        }
        Object2ObjectOpenHashMap masterPortMap = new Object2ObjectOpenHashMap();
        Object2IntOpenHashMap targetCountMap = new Object2IntOpenHashMap();
        for (ITilePort port : portMap.values()) {
            filter = ((ITileFiltered)((Object)port)).getFilterKey();
            if (PosHelper.DEFAULT_NON.equals((Object)port.getMasterPortPos()) && !masterPortMap.containsKey(filter)) {
                masterPortMap.put(filter, (Object)port);
                targetCountMap.put(filter, 0);
            }
            port.clearMasterPort();
            port.getTargets().clear();
        }
        if (!((Multiblock)this.multiblock).isAssembled() || portMap.isEmpty()) {
            return;
        }
        for (ITilePort port : portMap.values()) {
            filter = ((ITileFiltered)((Object)port)).getFilterKey();
            if (masterPortMap.containsKey(filter)) continue;
            masterPortMap.put(filter, (Object)port);
            targetCountMap.put(filter, 0);
        }
        for (ITilePort port : portMap.values()) {
            if (port == (master = (ITilePort)masterPortMap.get(filter = ((ITileFiltered)((Object)port)).getFilterKey()))) continue;
            port.setMasterPortPos(master.getTilePos());
            port.refreshMasterPort();
            port.setInventoryStackLimit(64);
            port.setTankCapacity(port.getTankBaseCapacity());
        }
        for (ITilePortTarget target : targetMap.values()) {
            filter = ((ITileFiltered)((Object)target)).getFilterKey();
            if (!masterPortMap.containsKey(filter) || (master = (ITilePort)masterPortMap.get(filter)) == null) continue;
            master.getTargets().add((Object)target);
            target.setMasterPortPos(master.getTilePos());
            target.refreshMasterPort();
            targetCountMap.put(filter, (Integer)targetCountMap.get(filter) + 1);
        }
        for (Object2ObjectMap.Entry entry : masterPortMap.object2ObjectEntrySet()) {
            ((ITilePort)entry.getValue()).setInventoryStackLimit(Math.max(64, ((ITilePort)entry.getValue()).getInventoryStackLimitPerConnection() * (Integer)targetCountMap.get(entry.getKey())));
            ((ITilePort)entry.getValue()).setTankCapacity(Math.max(((ITilePort)entry.getValue()).getTankBaseCapacity(), ((ITilePort)entry.getValue()).getTankCapacityPerConnection() * (Integer)targetCountMap.get(entry.getKey())));
        }
    }

    public <MANAGER extends ITileManager<MULTIBLOCK, LOGIC, T, MANAGER, LISTENER>, MNGR extends T, LISTENER extends ITileManagerListener<MULTIBLOCK, LOGIC, T, MANAGER, LISTENER>> void refreshManagers(Class<MANAGER> managerClass) {
        this.refreshManagers(managerClass, managerClass);
    }

    private <MANAGER extends ITileManager<MULTIBLOCK, LOGIC, T, MANAGER, LISTENER>, MNGR extends T, LISTENER extends ITileManagerListener<MULTIBLOCK, LOGIC, T, MANAGER, LISTENER>> void refreshManagers(Class<MANAGER> managerClass, Class<MNGR> managerClz) {
        for (ITileManager manager : this.getPartMap(managerClz).values()) {
            manager.refreshManager();
        }
    }

    public abstract void writeToLogicTag(NBTTagCompound var1, TileBeefAbstract.SyncReason var2);

    public abstract void readFromLogicTag(NBTTagCompound var1, TileBeefAbstract.SyncReason var2);

    public NBTTagCompound writeStacks(NonNullList<ItemStack> stacks, NBTTagCompound data) {
        ItemStackHelper.func_191282_a((NBTTagCompound)data, stacks);
        return data;
    }

    public void readStacks(NonNullList<ItemStack> stacks, NBTTagCompound data) {
        ItemStackHelper.func_191283_b((NBTTagCompound)data, stacks);
    }

    public NBTTagCompound writeTanks(List<Tank> tanks, NBTTagCompound data, String name) {
        for (int i = 0; i < tanks.size(); ++i) {
            tanks.get(i).writeToNBT(data, name + i);
        }
        return data;
    }

    public void readTanks(List<Tank> tanks, NBTTagCompound data, String name) {
        for (int i = 0; i < tanks.size(); ++i) {
            tanks.get(i).readFromNBT(data, name + i);
        }
    }

    public NBTTagCompound writeEnergy(EnergyStorage storage, NBTTagCompound data, String name) {
        storage.writeToNBT(data, name);
        return data;
    }

    public void readEnergy(EnergyStorage storage, NBTTagCompound data, String name) {
        storage.readFromNBT(data, name);
    }

    public boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return true;
    }

    public abstract void clearAllMaterial();

    public static void init() {
        try {
            FissionReactor.LOGIC_MAP.put((Object)"", FissionReactorLogic.class.getConstructor(FissionReactorLogic.class));
            FissionReactor.LOGIC_MAP.put((Object)"solid_fuel", SolidFuelFissionLogic.class.getConstructor(FissionReactorLogic.class));
            FissionReactor.LOGIC_MAP.put((Object)"molten_salt", MoltenSaltFissionLogic.class.getConstructor(FissionReactorLogic.class));
            HeatExchanger.LOGIC_MAP.put((Object)"heat_exchanger", HeatExchangerLogic.class.getConstructor(HeatExchangerLogic.class));
            HeatExchanger.LOGIC_MAP.put((Object)"condenser", CondenserLogic.class.getConstructor(HeatExchangerLogic.class));
            Turbine.LOGIC_MAP.put((Object)"turbine", TurbineLogic.class.getConstructor(TurbineLogic.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

