/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockWorldRegistry;
import nc.multiblock.tile.ITileMultiblockPart;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public final class MultiblockRegistry {
    private final Object2ObjectMap<World, MultiblockWorldRegistry> _registries = new Object2ObjectOpenHashMap(2);
    public static final MultiblockRegistry INSTANCE = new MultiblockRegistry();

    private MultiblockWorldRegistry getMultiblockRegistry(World world) {
        if (this._registries.containsKey((Object)world)) {
            return (MultiblockWorldRegistry)this._registries.get((Object)world);
        }
        MultiblockWorldRegistry registry = new MultiblockWorldRegistry(world);
        this._registries.put((Object)world, (Object)registry);
        return registry;
    }

    public <MULTIBLOCK extends Multiblock<MULTIBLOCK, T>, T extends ITileMultiblockPart<MULTIBLOCK, T>> void onPartAdded(World world, T part) {
        if (world == null) {
            FMLLog.warning((String)"Attempted to add a new multiblock part to a null world! Ignoring...", (Object[])new Object[0]);
        } else {
            this.getMultiblockRegistry(world).onPartAdded(part);
        }
    }

    public <MULTIBLOCK extends Multiblock<MULTIBLOCK, T>, T extends ITileMultiblockPart<MULTIBLOCK, T>> void onPartRemovedFromWorld(World world, T part) {
        if (this._registries.containsKey((Object)world)) {
            ((MultiblockWorldRegistry)this._registries.get((Object)world)).onPartRemovedFromWorld(part);
        }
    }

    public <MULTIBLOCK extends Multiblock<MULTIBLOCK, T>, T extends ITileMultiblockPart<MULTIBLOCK, T>> void addDeadMultiblock(World world, MULTIBLOCK multiblock) {
        if (this._registries.containsKey((Object)world)) {
            ((MultiblockWorldRegistry)this._registries.get((Object)world)).addDeadMultiblock(multiblock);
        } else {
            FMLLog.warning((String)"Multiblock %d in world %s marked as dead, but that world is not tracked! Multiblock is being ignored...", (Object[])new Object[]{multiblock.hashCode(), world});
        }
    }

    public <MULTIBLOCK extends Multiblock<MULTIBLOCK, T>, T extends ITileMultiblockPart<MULTIBLOCK, T>> void addDirtyMultiblock(World world, MULTIBLOCK multiblock) {
        if (!this._registries.containsKey((Object)world)) {
            if (world == null) {
                FMLLog.warning((String)"Attempted to add a dirty multiblock to a null world! Ignoring...", (Object[])new Object[0]);
                return;
            }
            FMLLog.warning((String)"Adding a dirty multiblock to a world that has no registered multiblocks! Creating new registry...", (Object[])new Object[0]);
        }
        this.getMultiblockRegistry(world).addDirtyMultiblock(multiblock);
    }

    protected void tickStart(World world) {
        if (this._registries.containsKey((Object)world)) {
            MultiblockWorldRegistry registry = (MultiblockWorldRegistry)this._registries.get((Object)world);
            registry.processMultiblockChanges();
            registry.tickStart();
        }
    }

    protected void onChunkLoaded(World world, int chunkX, int chunkZ) {
        if (this._registries.containsKey((Object)world)) {
            ((MultiblockWorldRegistry)this._registries.get((Object)world)).onChunkLoaded(chunkX, chunkZ);
        }
    }

    protected void onWorldUnloaded(World world) {
        if (this._registries.containsKey((Object)world)) {
            ((MultiblockWorldRegistry)this._registries.get((Object)world)).onWorldUnloaded();
            this._registries.remove((Object)world);
        }
    }

    private MultiblockRegistry() {
    }
}

