/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.salt.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.init.NCCoolantFluids;
import nc.multiblock.PlacementRule;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionPlacement;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionCoolingComponent;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionHeaterPort;
import nc.network.multiblock.SaltFissionHeaterUpdatePacket;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.ITileGui;
import nc.tile.fluid.ITileFilteredFluid;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IFluidGenerator;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.util.CapabilityHelper;
import nc.util.PosHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileSaltFissionHeater
extends TileFissionPart
implements ITileFilteredFluid,
ITileGui<SaltFissionHeaterUpdatePacket>,
IFluidGenerator,
IFissionCoolingComponent,
IFissionPortTarget<TileFissionHeaterPort, TileSaltFissionHeater> {
    @Nonnull
    protected final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, null), new Tank(1296, new ArrayList<String>())});
    @Nonnull
    protected final List<Tank> filterTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1000, null), new Tank(1000, new ArrayList<String>())});
    @Nonnull
    protected final List<Tank> consumedTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, new ArrayList<String>())});
    @Nonnull
    protected FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON, TankSorption.NON}));
    @Nonnull
    protected FluidTileWrapper[] fluidSides;
    @Nonnull
    protected GasTileWrapper gasWrapper;
    protected final int fluidInputSize = 1;
    protected final int fluidOutputSize = 1;
    protected int baseProcessCooling;
    protected PlacementRule<FissionReactor, IFissionPart> placementRule = (PlacementRule)FissionPlacement.RULE_MAP.get((Object)"");
    public double heatingSpeedMultiplier;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected final Set<EntityPlayer> updatePacketListeners;
    public String heaterType;
    public String coolantName;
    protected FissionCluster cluster = null;
    protected long heat = 0L;
    protected boolean isInValidPosition = false;
    public long clusterHeatStored;
    public long clusterHeatCapacity;
    protected BlockPos masterPortPos = PosHelper.DEFAULT_NON;
    protected TileFissionHeaterPort masterPort = null;

    public TileSaltFissionHeater() {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
        this.updatePacketListeners = new ObjectOpenHashSet();
    }

    public TileSaltFissionHeater(String heaterType, String coolantName) {
        this();
        this.heaterType = heaterType;
        this.coolantName = coolantName;
        this.tanks.get(0).setAllowedFluids(Lists.newArrayList((Object[])new String[]{coolantName}));
        this.filterTanks.get(0).setAllowedFluids(Lists.newArrayList((Object[])new String[]{coolantName}));
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    @Nullable
    public FissionCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setClusterInternal(@Nullable FissionCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isValidHeatConductor(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (!this.isProcessing(false, false) || componentFailCache.containsKey(this.field_174879_c.func_177986_g())) {
            this.isInValidPosition = false;
            return false;
        }
        if (this.placementRule.requiresRecheck()) {
            this.isInValidPosition = this.placementRule.satisfied(this);
            if (this.isInValidPosition) {
                assumedValidCache.put(this.field_174879_c.func_177986_g(), (Object)this);
            }
            return this.isInValidPosition;
        }
        if (this.isInValidPosition) {
            return true;
        }
        this.isInValidPosition = this.placementRule.satisfied(this);
        return this.isInValidPosition;
    }

    @Override
    public boolean isFunctional() {
        return this.isProcessing;
    }

    @Override
    public void resetStats() {
        this.isInValidPosition = false;
        this.heatingSpeedMultiplier = 0.0;
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true, true);
    }

    @Override
    public boolean isClusterRoot() {
        return false;
    }

    @Override
    public void clusterSearch(Integer id, Object2IntMap<IFissionComponent> clusterSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        this.refreshRecipe();
        this.refreshActivity();
        IFissionCoolingComponent.super.clusterSearch(id, clusterSearchCache, componentFailCache, assumedValidCache);
        this.refreshIsProcessing(true, true);
    }

    public void refreshIsProcessing(boolean checkCluster, boolean checkValid) {
        this.isProcessing = this.isProcessing(checkCluster, checkValid);
        this.hasConsumed = this.hasConsumed();
    }

    @Override
    public long getHeatStored() {
        return this.heat;
    }

    @Override
    public void setHeatStored(long heat) {
        this.heat = heat;
    }

    @Override
    public void onClusterMeltdown(Iterator<IFissionComponent> componentIterator) {
    }

    @Override
    public boolean isNullifyingSources(EnumFacing side) {
        return false;
    }

    @Override
    public long getCooling() {
        return this.baseProcessCooling;
    }

    @Override
    public IFissionFuelComponent.ModeratorBlockInfo getModeratorBlockInfo(EnumFacing dir, boolean activeModeratorPos) {
        return new IFissionFuelComponent.ModeratorBlockInfo(this.field_174879_c, this, false, false, 0L, 0.0);
    }

    @Override
    public void onAddedToModeratorCache(IFissionFuelComponent.ModeratorBlockInfo thisInfo) {
    }

    @Override
    public BlockPos getMasterPortPos() {
        return this.masterPortPos;
    }

    @Override
    public void setMasterPortPos(BlockPos pos) {
        this.masterPortPos = pos;
    }

    @Override
    public void clearMasterPort() {
        this.masterPort = null;
        this.masterPortPos = PosHelper.DEFAULT_NON;
    }

    @Override
    public void refreshMasterPort() {
        TileFissionHeaterPort tileFissionHeaterPort = this.masterPort = this.getMultiblock() == null ? null : (TileFissionHeaterPort)((FissionReactor)this.getMultiblock()).getPartMap(TileFissionHeaterPort.class).get(this.masterPortPos.func_177986_g());
        if (this.masterPort == null) {
            this.masterPortPos = PosHelper.DEFAULT_NON;
        }
    }

    @Override
    public boolean onPortRefresh() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true, true);
        return this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false, true);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshMasterPort();
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshIsProcessing(true, true);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate;
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing(true, true);
            boolean shouldRefresh = this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false, true);
            boolean bl = shouldUpdate = wasProcessing != this.isProcessing;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (shouldRefresh) {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
            this.sendTileUpdatePacketToListeners();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = NCRecipes.coolant_heater.getRecipeInfoFromHeaterInputs(this.heaterType, this.getFluidInputs(this.hasConsumed));
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public double getSpeedMultiplier() {
        return this.heatingSpeedMultiplier;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessCooling = 0;
            this.placementRule = (PlacementRule)FissionPlacement.RULE_MAP.get((Object)"");
            return false;
        }
        BasicRecipe recipe = this.recipeInfo.getRecipe();
        this.baseProcessCooling = recipe.getCoolantHeaterCoolingRate();
        this.placementRule = (PlacementRule)FissionPlacement.RULE_MAP.get((Object)recipe.getCoolantHeaterPlacementRule());
        return true;
    }

    public boolean isProcessing(boolean checkCluster, boolean checkValid) {
        return this.readyToProcess(checkCluster, checkValid);
    }

    public boolean readyToProcess(boolean checkCluster, boolean checkValid) {
        return !(!this.canProcessInputs || !this.hasConsumed || !this.isMultiblockAssembled() || checkCluster && this.cluster == null || checkValid && !this.isInValidPosition);
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < 1; ++i) {
            if (this.consumedTanks.get(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (Tank tank : this.getFluidInputs(true)) {
                tank.setFluidStored(null);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = 0.0;
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + 1).isEmpty()) continue;
            if (!this.getTanks().get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getTanks().get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.getTanks().get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        IntList fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (this.consumedTanks.get(i).isEmpty()) continue;
            this.consumedTanks.get(i).setFluid(null);
        }
        for (i = 0; i < 1; ++i) {
            Tank tank = this.getTanks().get(i);
            int maxStackSize = this.getFluidIngredients().get((Integer)fluidInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.consumedTanks.get(i).setFluidStored(new FluidStack(tank.getFluid(), maxStackSize));
                tank.changeFluidAmount(-maxStackSize);
            }
            if (!tank.isEmpty()) continue;
            tank.setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        while (this.time >= 1.0) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        int oldProcessCooling = this.baseProcessCooling;
        this.produceProducts();
        this.refreshRecipe();
        this.time = Math.max(0.0, this.time - 1.0);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
        if (this.getMultiblock() != null) {
            if (this.canProcessInputs) {
                if (oldProcessCooling != this.baseProcessCooling) {
                    ((FissionReactor)this.getMultiblock()).addClusterToRefresh(this.cluster);
                }
            } else {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
        }
    }

    public void produceProducts() {
        for (int i = 0; i < 1; ++i) {
            this.consumedTanks.get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize(0) <= 0) continue;
            if (this.getTanks().get(j + 1).isEmpty()) {
                this.getTanks().get(j + 1).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.getTanks().get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.getTanks().get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
        this.hasConsumed = false;
    }

    @Override
    public int getFluidInputSize() {
        return 1;
    }

    @Override
    public int getFluidOutputputSize() {
        return 1;
    }

    @Override
    public int getOtherSlotsSize() {
        return 0;
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.consumedTanks : this.getTanks().subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().getFluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().getFluidProducts();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getTanks() : this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getFluidSides() : this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getGasWrapper() : this.gasWrapper;
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return false;
    }

    @Override
    public void clearAllTanks() {
        IFluidGenerator.super.clearAllTanks();
        for (Tank tank : this.consumedTanks) {
            tank.setFluidStored(null);
        }
        this.hasConsumed = false;
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true, true);
    }

    @Override
    @Nonnull
    public List<Tank> getTanksInternal() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public List<Tank> getFilterTanks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getFilterTanks() : this.filterTanks;
    }

    @Override
    public boolean canModifyFilter(int tank) {
        return this.getMultiblock() != null ? !((FissionReactor)this.getMultiblock()).isAssembled() : true;
    }

    @Override
    public void onFilterChanged(int slot) {
        this.func_70296_d();
    }

    @Override
    public Object getFilterKey() {
        return this.heaterType;
    }

    @Override
    public int getGuiID() {
        return 203;
    }

    @Override
    public Set<EntityPlayer> getTileUpdatePacketListeners() {
        return this.updatePacketListeners;
    }

    @Override
    public SaltFissionHeaterUpdatePacket getTileUpdatePacket() {
        return new SaltFissionHeaterUpdatePacket(this.field_174879_c, this.masterPortPos, this.getTanks(), this.getFilterTanks(), this.cluster, this.isProcessing, this.time);
    }

    @Override
    public void onTileUpdatePacket(SaltFissionHeaterUpdatePacket message) {
        int i;
        this.masterPortPos = message.masterPortPos;
        if (PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ^ this.masterPort == null) {
            this.refreshMasterPort();
        }
        for (i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
        for (i = 0; i < this.getFilterTanks().size(); ++i) {
            this.getFilterTanks().get(i).readInfo(message.filterTanksInfo.get(i));
        }
        this.clusterHeatStored = message.clusterHeatStored;
        this.clusterHeatCapacity = message.clusterHeatCapacity;
        this.isProcessing = message.isProcessing;
        this.time = message.time;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74778_a("heaterName", this.heaterType);
        nbt.func_74778_a("coolantName", this.coolantName);
        this.writeTanks(nbt);
        nbt.func_74768_a("baseProcessCooling", this.baseProcessCooling);
        nbt.func_74780_a("heatingSpeedMultiplier", this.heatingSpeedMultiplier);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74772_a("clusterHeat", this.heat);
        nbt.func_74757_a("isInValidPosition", this.isInValidPosition);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (nbt.func_74764_b("heaterName")) {
            this.heaterType = nbt.func_74779_i("heaterName");
        }
        if (nbt.func_74764_b("coolantName")) {
            this.coolantName = nbt.func_74779_i("coolantName");
            this.tanks.get(0).setAllowedFluids(Lists.newArrayList((Object[])new String[]{this.coolantName}));
            this.filterTanks.get(0).setAllowedFluids(Lists.newArrayList((Object[])new String[]{this.coolantName}));
        }
        this.readTanks(nbt);
        this.baseProcessCooling = nbt.func_74762_e("baseProcessCooling");
        this.heatingSpeedMultiplier = nbt.func_74769_h("heatingSpeedMultiplier");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.heat = nbt.func_74763_f("clusterHeat");
        this.isInValidPosition = nbt.func_74767_n("isInValidPosition");
    }

    @Override
    public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        int i;
        for (i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).writeToNBT(nbt, "tanks" + i);
        }
        for (i = 0; i < this.filterTanks.size(); ++i) {
            this.filterTanks.get(i).writeToNBT(nbt, "filterTanks" + i);
        }
        for (i = 0; i < this.consumedTanks.size(); ++i) {
            this.consumedTanks.get(i).writeToNBT(nbt, "consumedTanks" + i);
        }
        return nbt;
    }

    @Override
    public void readTanks(NBTTagCompound nbt) {
        int i;
        for (i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).readFromNBT(nbt, "tanks" + i);
        }
        for (i = 0; i < this.filterTanks.size(); ++i) {
            this.filterTanks.get(i).readFromNBT(nbt, "filterTanks" + i);
        }
        for (i = 0; i < this.consumedTanks.size(); ++i) {
            this.consumedTanks.get(i).readFromNBT(nbt, "consumedTanks" + i);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidSide(this.nonNullSide(side)));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)CapabilityHelper.GAS_HANDLER_CAPABILITY.cast((Object)this.getGasWrapper());
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    public static class Cryotheum
    extends Meta {
        public Cryotheum() {
            super(31);
        }
    }

    public static class Enderium
    extends Meta {
        public Enderium() {
            super(30);
        }
    }

    public static class LiquidHelium
    extends Meta {
        public LiquidHelium() {
            super(29);
        }
    }

    public static class LiquidNitrogen
    extends Meta {
        public LiquidNitrogen() {
            super(28);
        }
    }

    public static class Arsenic
    extends Meta {
        public Arsenic() {
            super(27);
        }
    }

    public static class Carobbiite
    extends Meta {
        public Carobbiite() {
            super(26);
        }
    }

    public static class Villiaumite
    extends Meta {
        public Villiaumite() {
            super(25);
        }
    }

    public static class Fluorite
    extends Meta {
        public Fluorite() {
            super(24);
        }
    }

    public static class Silver
    extends Meta {
        public Silver() {
            super(23);
        }
    }

    public static class Aluminum
    extends Meta {
        public Aluminum() {
            super(22);
        }
    }

    public static class Manganese
    extends Meta {
        public Manganese() {
            super(21);
        }
    }

    public static class Magnesium
    extends Meta {
        public Magnesium() {
            super(20);
        }
    }

    public static class Lithium
    extends Meta {
        public Lithium() {
            super(19);
        }
    }

    public static class Boron
    extends Meta {
        public Boron() {
            super(18);
        }
    }

    public static class Lead
    extends Meta {
        public Lead() {
            super(17);
        }
    }

    public static class Tin
    extends Meta {
        public Tin() {
            super(16);
        }
    }

    public static class Copper
    extends Meta {
        public Copper() {
            super(15);
        }
    }

    public static class Emerald
    extends Meta {
        public Emerald() {
            super(14);
        }
    }

    public static class Diamond
    extends Meta {
        public Diamond() {
            super(13);
        }
    }

    public static class Purpur
    extends Meta {
        public Purpur() {
            super(12);
        }
    }

    public static class EndStone
    extends Meta {
        public EndStone() {
            super(11);
        }
    }

    public static class Slime
    extends Meta {
        public Slime() {
            super(10);
        }
    }

    public static class Prismarine
    extends Meta {
        public Prismarine() {
            super(9);
        }
    }

    public static class Gold
    extends Meta {
        public Gold() {
            super(8);
        }
    }

    public static class Lapis
    extends Meta {
        public Lapis() {
            super(7);
        }
    }

    public static class Glowstone
    extends Meta {
        public Glowstone() {
            super(6);
        }
    }

    public static class NetherBrick
    extends Meta {
        public NetherBrick() {
            super(5);
        }
    }

    public static class Obsidian
    extends Meta {
        public Obsidian() {
            super(4);
        }
    }

    public static class Quartz
    extends Meta {
        public Quartz() {
            super(3);
        }
    }

    public static class Redstone
    extends Meta {
        public Redstone() {
            super(2);
        }
    }

    public static class Iron
    extends Meta {
        public Iron() {
            super(1);
        }
    }

    public static class Standard
    extends Meta {
        public Standard() {
            super("standard", "nak");
        }
    }

    protected static class Meta
    extends TileSaltFissionHeater {
        public Meta(String heaterType, String coolantName) {
            super(heaterType, coolantName);
        }

        protected Meta(int coolantID) {
            super(NCCoolantFluids.COOLANTS.get(coolantID), NCCoolantFluids.COOLANTS.get(coolantID) + "_nak");
        }

        @Override
        public boolean shouldRefresh(World worldIn, BlockPos posIn, IBlockState oldState, IBlockState newState) {
            return oldState != newState;
        }
    }
}

