/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile.manager;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.TileFissionShield;
import nc.multiblock.fission.tile.manager.TileFissionManager;
import nc.util.Lang;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileFissionShieldManager
extends TileFissionManager<TileFissionShieldManager, TileFissionShield> {
    public TileFissionShieldManager() {
        super(TileFissionShieldManager.class);
    }

    @Override
    public int[] weakSidesToCheck(World worldIn, BlockPos posIn) {
        return new int[]{2, 3, 4, 5};
    }

    public boolean isShieldingActive() {
        return this.getIsRedstonePowered();
    }

    @Override
    public void refreshManager() {
        this.refreshListeners(true);
    }

    @Override
    public void refreshListeners(boolean refreshPosSet) {
        this.refreshListenersFlag = false;
        if (this.getMultiblock() == null) {
            return;
        }
        boolean refresh = false;
        LongOpenHashSet invalidPosSet = new LongOpenHashSet();
        for (Long listenerPos : this.listenerPosSet) {
            TileFissionShield shield = (TileFissionShield)((FissionReactor)this.getMultiblock()).getPartMap(TileFissionShield.class).get((Object)listenerPos);
            if (shield != null) {
                if (!shield.onManagerRefresh(this)) continue;
                refresh = true;
                continue;
            }
            if (!refreshPosSet) continue;
            invalidPosSet.add((Object)listenerPos);
        }
        this.listenerPosSet.removeAll((LongCollection)invalidPosSet);
        if (refresh) {
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
        }
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World worldIn, BlockPos posIn, BlockPos fromPos) {
        boolean wasShieldingActive = this.isShieldingActive();
        super.onBlockNeighborChanged(state, worldIn, posIn, fromPos);
        this.setActivity(this.isShieldingActive());
        if (!worldIn.field_72995_K && wasShieldingActive != this.isShieldingActive()) {
            this.refreshListeners(false);
        }
    }

    @Override
    public boolean onUseMultitool(ItemStack multitool, EntityPlayer player, World worldIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getMultiblock() != null) {
            this.listenerPosSet.clear();
            for (TileFissionShield shield : ((FissionReactor)this.getMultiblock()).getParts(TileFissionShield.class)) {
                this.listenerPosSet.add(shield.func_174877_v().func_177986_g());
                shield.setManagerPos(this.field_174879_c);
                shield.refreshManager();
            }
            this.func_70296_d();
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.fission.connect_shield_manager", this.listenerPosSet.size())));
            return true;
        }
        return super.onUseMultitool(multitool, player, worldIn, facing, hitX, hitY, hitZ);
    }
}

