/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile.port;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionPort;
import nc.multiblock.fission.tile.port.internal.PortItemHandler;
import nc.recipe.BasicRecipeHandler;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileFilteredInventory;
import nc.tile.inventory.ITileInventory;
import nc.util.Lang;
import nc.util.NBTHelper;
import nc.util.PosHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileFissionItemPort<PORT extends TileFissionItemPort<PORT, TARGET>, TARGET extends IFissionPortTarget<PORT, TARGET> & ITileFilteredInventory>
extends TileFissionPort<PORT, TARGET>
implements ITileFilteredInventory {
    @Nonnull
    private final String inventoryName;
    @Nonnull
    protected final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected final NonNullList<ItemStack> filterStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.IN, ItemSorption.OUT}));
    public int inventoryStackLimit = 64;
    protected final BasicRecipeHandler recipeHandler;

    public TileFissionItemPort(Class<PORT> portClass, String type, BasicRecipeHandler recipeHandler) {
        super(portClass);
        this.inventoryName = "nuclearcraft.container.fission_" + type + "_port";
        this.recipeHandler = recipeHandler;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        EnumFacing facing = this.getPartPosition().getFacing();
        if (!this.field_145850_b.field_72995_K && facing != null && !this.func_70301_a(1).func_190926_b() && this.getItemSorption(facing, 1).canExtract()) {
            this.pushStacksToSide(facing);
        }
    }

    @Override
    public void setInventoryStackLimit(int stackLimit) {
        this.inventoryStackLimit = stackLimit;
    }

    @Override
    public int getTankCapacityPerConnection() {
        return 0;
    }

    @Override
    public int getTankBaseCapacity() {
        return 1;
    }

    @Override
    public void setTankCapacity(int capacity) {
    }

    @Override
    public boolean canModifyFilter(int slot) {
        return this.getMultiblock() != null ? !((FissionReactor)this.getMultiblock()).isAssembled() : true;
    }

    @Override
    public void onFilterChanged(int slot) {
        this.func_70296_d();
    }

    @Override
    public String func_70005_c_() {
        return this.inventoryName;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? ((TileFissionItemPort)this.masterPort).getInventoryStacks() : this.inventoryStacks;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacksInternal() {
        return this.inventoryStacks;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getFilterStacks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? ((TileFissionItemPort)this.masterPort).getFilterStacks() : this.filterStacks;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = ITileFilteredInventory.super.func_70298_a(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.recipeHandler.getItemInputSize()) {
                this.refreshTargetsFlag = true;
            } else if (slot < this.recipeHandler.getItemInputSize() + this.recipeHandler.getItemOutputSize()) {
                this.refreshTargetsFlag = true;
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        ITileFilteredInventory.super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.recipeHandler.getItemInputSize()) {
                this.refreshTargetsFlag = true;
            } else if (slot < this.recipeHandler.getItemInputSize() + this.recipeHandler.getItemOutputSize()) {
                this.refreshTargetsFlag = true;
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b() || slot >= this.recipeHandler.getItemInputSize()) {
            return false;
        }
        ItemStack filter = (ItemStack)this.getFilterStacks().get(slot);
        if (!filter.func_190926_b() && !stack.func_77969_a(filter)) {
            return false;
        }
        return this.isItemValidForSlotInternal(slot, stack);
    }

    @Override
    public boolean isItemValidForSlotInternal(int slot, ItemStack stack) {
        if (stack.func_190926_b() || slot >= this.recipeHandler.getItemInputSize()) {
            return false;
        }
        return NCConfig.smart_processor_input ? this.recipeHandler.isValidItemInput(slot, stack, null, this.getInventoryStacks().subList(0, this.recipeHandler.getItemInputSize()), this.inputItemStacksExcludingSlot(slot)) : this.recipeHandler.isValidItemInput(slot, stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getInventoryStacks().subList(0, this.recipeHandler.getItemInputSize()));
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return ITileFilteredInventory.super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    @Override
    public void clearAllSlots() {
        ITileFilteredInventory.super.clearAllSlots();
        this.refreshTargetsFlag = true;
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    @Override
    public int func_70297_j_() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? ((TileFissionItemPort)this.masterPort).func_70297_j_() : this.inventoryStackLimit;
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    @Override
    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableInventoryConnections() {
        return true;
    }

    @Override
    public boolean onUseMultitool(ItemStack multitool, EntityPlayer player, World worldIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getMultiblock() != null) {
            if (this.getItemSorption(facing, 0) != ItemSorption.IN) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setItemSorption(side, 0, ItemSorption.IN);
                    this.setItemSorption(side, 1, ItemSorption.NON);
                }
                this.setActivity(false);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.port_toggle") + " " + TextFormatting.BLUE + Lang.localise("nc.block.fission_port_mode.input") + " " + TextFormatting.WHITE + Lang.localise("nc.block.port_toggle.mode")));
            } else {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setItemSorption(side, 0, ItemSorption.NON);
                    this.setItemSorption(side, 1, ItemSorption.OUT);
                }
                this.setActivity(true);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.port_toggle") + " " + TextFormatting.GOLD + Lang.localise("nc.block.fission_port_mode.output") + " " + TextFormatting.WHITE + Lang.localise("nc.block.port_toggle.mode")));
            }
            this.markDirtyAndNotify(true);
            return true;
        }
        return super.onUseMultitool(multitool, player, worldIn, facing, hitX, hitY, hitZ);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        nbt.func_74768_a("inventoryStackLimit", this.inventoryStackLimit);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.inventoryStackLimit = nbt.func_74762_e("inventoryStackLimit");
    }

    @Override
    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        int i;
        int[] counts = new int[this.inventoryStacks.size()];
        for (i = 0; i < this.inventoryStacks.size(); ++i) {
            counts[i] = ((ItemStack)this.inventoryStacks.get(i)).func_190916_E();
            nbt.func_74768_a("inventoryStackSize" + i, counts[i]);
            if (((ItemStack)this.inventoryStacks.get(i)).func_190926_b()) continue;
            ((ItemStack)this.inventoryStacks.get(i)).func_190920_e(1);
        }
        NBTHelper.writeAllItems(nbt, new List[]{this.inventoryStacks, this.filterStacks});
        for (i = 0; i < this.inventoryStacks.size(); ++i) {
            if (((ItemStack)this.inventoryStacks.get(i)).func_190926_b()) continue;
            ((ItemStack)this.inventoryStacks.get(i)).func_190920_e(counts[i]);
        }
        return nbt;
    }

    @Override
    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems(nbt, new List[]{this.inventoryStacks, this.filterStacks});
        for (int i = 0; i < this.inventoryStacks.size(); ++i) {
            if (((ItemStack)this.inventoryStacks.get(i)).func_190926_b()) continue;
            ((ItemStack)this.inventoryStacks.get(i)).func_190920_e(nbt.func_74762_e("inventoryStackSize" + i));
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler(side));
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable EnumFacing side) {
        return (IItemHandler)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast(new PortItemHandler<TileFissionItemPort>(this, side));
    }
}

