/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.IPacketMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.heatExchanger.HeatExchangerLogic;
import nc.multiblock.heatExchanger.tile.IHeatExchangerController;
import nc.multiblock.heatExchanger.tile.IHeatExchangerPart;
import nc.multiblock.heatExchanger.tile.TileCondenserTube;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerTube;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerVent;
import nc.multiblock.tile.TileBeefAbstract;
import nc.network.multiblock.HeatExchangerUpdatePacket;
import nc.util.NCMath;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatExchanger
extends CuboidalMultiblock<HeatExchanger, IHeatExchangerPart>
implements ILogicMultiblock<HeatExchanger, HeatExchangerLogic, IHeatExchangerPart>,
IPacketMultiblock<HeatExchanger, IHeatExchangerPart, HeatExchangerUpdatePacket> {
    public static final ObjectSet<Class<? extends IHeatExchangerPart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends HeatExchangerLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    protected final ObjectSet<IHeatExchangerController<?>> controllers = new ObjectOpenHashSet();
    protected final ObjectSet<TileHeatExchangerVent> vents = new ObjectOpenHashSet();
    protected final ObjectSet<TileHeatExchangerTube> tubes = new ObjectOpenHashSet();
    protected final ObjectSet<TileCondenserTube> condenserTubes = new ObjectOpenHashSet();
    @Nonnull
    protected HeatExchangerLogic logic = new HeatExchangerLogic(this);
    protected final Multiblock.PartSuperMap<HeatExchanger, IHeatExchangerPart> partSuperMap = new Multiblock.PartSuperMap();
    protected IHeatExchangerController<?> controller;
    public boolean isHeatExchangerOn;
    public boolean computerActivated;
    public double fractionOfTubesActive;
    public double efficiency;
    public double maxEfficiency;
    protected final Set<EntityPlayer> updatePacketListeners = new ObjectOpenHashSet();

    public HeatExchanger(World world) {
        super(world, HeatExchanger.class, IHeatExchangerPart.class);
    }

    @Override
    @Nonnull
    public HeatExchangerLogic getLogic() {
        return this.logic;
    }

    @Override
    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (HeatExchangerLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
    }

    @Override
    public Multiblock.PartSuperMap<HeatExchanger, IHeatExchangerPart> getPartSuperMap() {
        return this.partSuperMap;
    }

    public ObjectSet<IHeatExchangerController<?>> getControllers() {
        return this.controllers;
    }

    public ObjectSet<TileHeatExchangerVent> getVents() {
        return this.vents;
    }

    public ObjectSet<TileHeatExchangerTube> getTubes() {
        return this.tubes;
    }

    public ObjectSet<TileCondenserTube> getCondenserTubes() {
        return this.condenserTubes;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.heat_exchanger_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.heat_exchanger_max_size;
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return NCMath.hollowCuboid(Math.max(4, this.getMinimumInteriorLength() + 2), this.getMinimumInteriorLength() + 2, this.getMinimumInteriorLength() + 2);
    }

    @Override
    public void onAttachedPartWithMultiblockData(IHeatExchangerPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IHeatExchangerPart newPart) {
        if (newPart instanceof IHeatExchangerController) {
            this.controllers.add((Object)((IHeatExchangerController)newPart));
        }
        if (newPart instanceof TileHeatExchangerVent) {
            this.vents.add((Object)((TileHeatExchangerVent)newPart));
        }
        if (newPart instanceof TileHeatExchangerTube) {
            this.tubes.add((Object)((TileHeatExchangerTube)newPart));
        }
        if (newPart instanceof TileCondenserTube) {
            this.condenserTubes.add((Object)((TileCondenserTube)newPart));
        }
    }

    @Override
    protected void onBlockRemoved(IHeatExchangerPart oldPart) {
        if (oldPart instanceof IHeatExchangerController) {
            this.controllers.remove((Object)((IHeatExchangerController)oldPart));
        }
        if (oldPart instanceof TileHeatExchangerVent) {
            this.vents.remove((Object)((TileHeatExchangerVent)oldPart));
        }
        if (oldPart instanceof TileHeatExchangerTube) {
            this.tubes.remove((Object)((TileHeatExchangerTube)oldPart));
        }
        if (oldPart instanceof TileCondenserTube) {
            this.condenserTubes.remove((Object)((TileCondenserTube)oldPart));
        }
    }

    @Override
    protected void onMachineAssembled() {
        this.onHeatExchangerFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onHeatExchangerFormed();
    }

    protected void onHeatExchangerFormed() {
        ObjectIterator objectIterator = this.controllers.iterator();
        while (objectIterator.hasNext()) {
            IHeatExchangerController contr;
            this.controller = contr = (IHeatExchangerController)objectIterator.next();
        }
        this.setIsHeatExchangerOn();
        if (!this.WORLD.field_72995_K) {
            for (TileHeatExchangerTube tube : this.tubes) {
                tube.updateFlowDir();
            }
            for (TileCondenserTube condenserTube : this.condenserTubes) {
                condenserTube.updateAdjacentTemperatures();
            }
            this.updateHeatExchangerStats();
        }
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.isHeatExchangerOn = false;
        if (this.controller != null) {
            this.controller.setActivity(false);
        }
        this.maxEfficiency = 0.0;
        this.efficiency = 0.0;
        this.fractionOfTubesActive = 0.0;
    }

    @Override
    protected boolean isMachineWhole() {
        if (this.controllers.size() == 0) {
            this.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            this.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole();
    }

    @Override
    protected void onAssimilate(HeatExchanger assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    @Override
    protected void onAssimilated(HeatExchanger assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    @Override
    protected boolean updateServer() {
        boolean flag = false;
        this.updateHeatExchangerStats();
        if (this.logic.onUpdateServer()) {
            flag = true;
        }
        if (this.controller != null) {
            this.sendMultiblockUpdatePacketToListeners();
        }
        return flag;
    }

    public void setIsHeatExchangerOn() {
        boolean oldIsHeatExchangerOn = this.isHeatExchangerOn;
        boolean bl = this.isHeatExchangerOn = (this.isRedstonePowered() || this.computerActivated) && this.isAssembled();
        if (this.isHeatExchangerOn != oldIsHeatExchangerOn && this.controller != null) {
            this.controller.setActivity(this.isHeatExchangerOn);
            this.sendMultiblockUpdatePacketToAll();
        }
    }

    protected boolean isRedstonePowered() {
        return this.controller != null && this.controller.checkIsRedstonePowered(this.WORLD, this.controller.getTilePos());
    }

    protected void updateHeatExchangerStats() {
        int numberOfTubes = this.tubes.size() + this.condenserTubes.size();
        if (numberOfTubes < 1) {
            this.maxEfficiency = 0.0;
            this.efficiency = 0.0;
            this.fractionOfTubesActive = 0.0;
            return;
        }
        int activeCount = 0;
        int efficiencyCount = 0;
        int maxEfficiencyCount = 0;
        for (TileHeatExchangerTube tube : this.tubes) {
            int[] eff = tube.checkPosition();
            if (eff[0] > 0) {
                ++activeCount;
            }
            efficiencyCount += eff[0];
            maxEfficiencyCount += eff[1];
        }
        for (TileCondenserTube condenserTube : this.condenserTubes) {
            int eff = condenserTube.checkPosition();
            if (eff > 0) {
                ++activeCount;
            }
            efficiencyCount += eff;
            maxEfficiencyCount += eff;
        }
        this.fractionOfTubesActive = (double)activeCount / (double)numberOfTubes;
        this.efficiency = activeCount == 0 ? 0.0 : (double)efficiencyCount / (double)activeCount;
        this.maxEfficiency = (double)maxEfficiencyCount / (double)numberOfTubes;
    }

    @Override
    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    @Override
    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        data.func_74757_a("isHeatExchangerOn", this.isHeatExchangerOn);
        data.func_74757_a("computerActivated", this.computerActivated);
        data.func_74780_a("fractionOfTubesActive", this.fractionOfTubesActive);
        data.func_74780_a("efficiency", this.efficiency);
        data.func_74780_a("maxEfficiency", this.maxEfficiency);
        this.writeLogicNBT(data, syncReason);
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.isHeatExchangerOn = data.func_74767_n("isHeatExchangerOn");
        this.computerActivated = data.func_74767_n("computerActivated");
        this.fractionOfTubesActive = data.func_74769_h("fractionOfTubesActive");
        this.efficiency = data.func_74769_h("efficiency");
        this.maxEfficiency = data.func_74769_h("maxEfficiency");
        this.readLogicNBT(data, syncReason);
    }

    @Override
    public Set<EntityPlayer> getMultiblockUpdatePacketListeners() {
        return this.updatePacketListeners;
    }

    @Override
    public HeatExchangerUpdatePacket getMultiblockUpdatePacket() {
        return new HeatExchangerUpdatePacket(this.controller.getTilePos(), this.isHeatExchangerOn, this.fractionOfTubesActive, this.efficiency, this.maxEfficiency);
    }

    @Override
    public void onMultiblockUpdatePacket(HeatExchangerUpdatePacket message) {
        this.isHeatExchangerOn = message.isHeatExchangerOn;
        this.fractionOfTubesActive = message.fractionOfTubesActive;
        this.efficiency = message.efficiency;
        this.maxEfficiency = message.maxEfficiency;
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return true;
    }

    @Override
    public void clearAllMaterial() {
        this.logic.clearAllMaterial();
        super.clearAllMaterial();
    }
}

