/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.qComputer.tile;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import nc.multiblock.qComputer.QuantumComputer;
import nc.multiblock.qComputer.QuantumGate;
import nc.multiblock.qComputer.tile.TileQuantumComputerPart;
import nc.network.multiblock.QuantumComputerQubitRenderPacket;
import nc.tile.ITilePacket;
import nc.util.Lang;
import nc.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileQuantumComputerQubit
extends TileQuantumComputerPart
implements ITickable,
ITilePacket<QuantumComputerQubitRenderPacket> {
    public int id = -1;
    public boolean redstone = false;
    public boolean pulsed = false;
    public float measureColor = 0.0f;

    @Override
    public void onMachineAssembled(QuantumComputer multiblock) {
        this.doStandardNullControllerResponse(multiblock);
    }

    @Override
    public void onMachineBroken() {
    }

    @Override
    public int[] weakSidesToCheck(World worldIn, BlockPos posIn) {
        return new int[]{2, 3, 4, 5};
    }

    public void func_73660_a() {
        if (!this.pulsed && this.getIsRedstonePowered()) {
            this.queueMeasurement();
            this.pulsed = true;
        } else if (this.pulsed && !this.getIsRedstonePowered()) {
            this.pulsed = false;
        }
    }

    public final void queueMeasurement() {
        if (this.isMultiblockAssembled()) {
            ((QuantumComputer)this.getMultiblock()).getGateQueue().add(new QuantumGate.Measurement((QuantumComputer)this.getMultiblock(), (IntSet)new IntOpenHashSet(new int[]{this.id})));
        }
    }

    @Override
    public boolean onUseMultitool(ItemStack multitool, EntityPlayer player, World worldIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbt = NBTHelper.getStackNBT(multitool);
        if (nbt != null) {
            String mode = nbt.func_74779_i("qubitMode");
            boolean s = mode.equals("set");
            boolean l = mode.equals("list");
            if (s || l) {
                IntOpenHashSet idColl;
                Object object = idColl = s ? new IntOpenHashSet() : new IntArrayList();
                if (s) {
                    NBTHelper.readIntCollection(nbt, (IntCollection)idColl, "qubitIDSet");
                    NBTHelper.writeIntCollection(nbt, (IntCollection)new IntArrayList(), "qubitIDList");
                } else {
                    NBTHelper.readIntCollection(nbt, (IntCollection)idColl, "qubitIDList");
                    NBTHelper.writeIntCollection(nbt, (IntCollection)new IntOpenHashSet(), "qubitIDSet");
                }
                if (!player.func_70093_af()) {
                    boolean wasEmpty = idColl.isEmpty();
                    if (idColl.add(this.id)) {
                        if (wasEmpty) {
                            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_qubit_" + mode, this.id)));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.add_qubit", this.id)));
                        }
                    }
                }
                if (s) {
                    NBTHelper.writeIntCollection(nbt, (IntCollection)idColl, "qubitIDSet");
                } else {
                    NBTHelper.writeIntCollection(nbt, (IntCollection)idColl, "qubitIDList");
                }
                return true;
            }
        }
        return super.onUseMultitool(multitool, player, worldIn, facing, hitX, hitY, hitZ);
    }

    @Override
    public QuantumComputerQubitRenderPacket getTileUpdatePacket() {
        return new QuantumComputerQubitRenderPacket(this.field_174879_c, this.measureColor);
    }

    @Override
    public void onTileUpdatePacket(QuantumComputerQubitRenderPacket message) {
        this.measureColor = message.measureColor;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("qubitID", this.id);
        nbt.func_74757_a("qubitRedstone", this.redstone);
        nbt.func_74757_a("qubitPulsed", this.pulsed);
        nbt.func_74776_a("qubitMeasureColor", this.measureColor);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.id = nbt.func_74762_e("qubitID");
        this.redstone = nbt.func_74767_n("qubitRedstone");
        this.pulsed = nbt.func_74767_n("qubitPulsed");
        this.measureColor = nbt.func_74760_g("qubitMeasureColor");
    }
}

