/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.rtg;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import javax.annotation.Nonnull;
import nc.multiblock.Multiblock;
import nc.multiblock.rtg.tile.TileRTG;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.energy.EnergyStorage;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RTGMultiblock
extends Multiblock<RTGMultiblock, TileRTG> {
    public static final ObjectSet<Class<? extends TileRTG>> PART_CLASSES = new ObjectOpenHashSet();
    protected final Multiblock.PartSuperMap<RTGMultiblock, TileRTG> partSuperMap = new Multiblock.PartSuperMap();
    @Nonnull
    protected final EnergyStorage storage = new EnergyStorage(1L);
    protected long power = 0L;
    protected boolean refreshEnergy = false;

    public RTGMultiblock(World world) {
        super(world, RTGMultiblock.class, TileRTG.class);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
    }

    @Override
    public Multiblock.PartSuperMap<RTGMultiblock, TileRTG> getPartSuperMap() {
        return this.partSuperMap;
    }

    @Nonnull
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public void onAttachedPartWithMultiblockData(TileRTG part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(TileRTG newPart) {
        this.onPartAdded(newPart);
    }

    @Override
    protected void onBlockRemoved(TileRTG oldPart) {
        this.onPartRemoved(oldPart);
    }

    @Override
    protected void onMachineAssembled() {
        this.onMultiblockFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onMultiblockFormed();
    }

    protected void onMultiblockFormed() {
        if (!this.WORLD.field_72995_K) {
            long powerSum = 0L;
            for (TileRTG rtg : this.getParts(TileRTG.class)) {
                powerSum += rtg.power;
                rtg.onMultiblockRefresh();
            }
            this.power = powerSum;
            this.storage.setStorageCapacity(4L * powerSum);
            this.storage.setMaxTransfer(NCMath.toInt(4L * powerSum));
            this.refreshEnergy = true;
        }
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    @Override
    protected int getMaximumXSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumZSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumYSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected boolean isMachineWhole() {
        return true;
    }

    @Override
    protected void onAssimilate(RTGMultiblock assimilated) {
        this.storage.mergeEnergyStorage(assimilated.storage);
    }

    @Override
    protected void onAssimilated(RTGMultiblock assimilator) {
    }

    @Override
    protected boolean updateServer() {
        if (this.refreshEnergy) {
            this.storage.cullEnergyStored();
            this.refreshEnergy = false;
        }
        this.getEnergyStorage().changeEnergyStored(this.power);
        return false;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return true;
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.readEnergy(this.storage, data, "energyStorage");
    }

    @Override
    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.writeEnergy(this.storage, data, "energyStorage");
    }
}

