/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.vecmath.Vector3f;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.IPacketMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.tile.TileBeefAbstract;
import nc.multiblock.turbine.TurbineLogic;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.tile.ITurbineController;
import nc.multiblock.turbine.tile.ITurbinePart;
import nc.multiblock.turbine.tile.TileTurbineRotorBlade;
import nc.multiblock.turbine.tile.TileTurbineRotorStator;
import nc.network.PacketHandler;
import nc.network.multiblock.TurbineRenderPacket;
import nc.network.multiblock.TurbineUpdatePacket;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.util.NBTHelper;
import nc.util.NCMath;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Turbine
extends CuboidalMultiblock<Turbine, ITurbinePart>
implements ILogicMultiblock<Turbine, TurbineLogic, ITurbinePart>,
IPacketMultiblock<Turbine, ITurbinePart, TurbineUpdatePacket> {
    public static final ObjectSet<Class<? extends ITurbinePart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends TurbineLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    @Nonnull
    protected TurbineLogic logic = new TurbineLogic(this);
    protected final Multiblock.PartSuperMap<Turbine, ITurbinePart> partSuperMap = new Multiblock.PartSuperMap();
    public ITurbineController<?> controller;
    public final EnergyStorage energyStorage = new EnergyStorage(64000L);
    public final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(4000, NCRecipes.turbine_valid_fluids.get(0)), new Tank(16000, null)});
    public static final int BASE_MAX_ENERGY = 64000;
    public static final int BASE_MAX_INPUT = 4000;
    public static final int BASE_MAX_OUTPUT = 16000;
    public RecipeInfo<BasicRecipe> recipeInfo;
    public boolean isTurbineOn;
    public boolean computerActivated;
    public boolean isProcessing;
    public double power = 0.0;
    public double conductivity = 0.0;
    public double rotorEfficiency = 0.0;
    public double powerBonus = 0.0;
    public double rawPower = 0.0;
    public double rawLimitPower = 0.0;
    public double rawMaxPower = 0.0;
    public EnumFacing flowDir = null;
    public int shaftWidth = 0;
    public int inertia = 0;
    public int bladeLength = 0;
    public int noBladeSets = 0;
    public int recipeInputRate = 0;
    public int dynamoCoilCount = 0;
    public int dynamoCoilCountOpposite = 0;
    public double totalExpansionLevel = 1.0;
    public double idealTotalExpansionLevel = 1.0;
    public double spinUpMultiplier = 1.0;
    public double basePowerPerMB = 0.0;
    public double recipeInputRateFP = 0.0;
    public double minBladeExpansionCoefficient = Double.MAX_VALUE;
    public double maxBladeExpansionCoefficient = 1.0;
    public double minStatorExpansionCoefficient = 1.0;
    public double maxStatorExpansionCoefficient = Double.MIN_VALUE;
    public int effectiveMaxLength = NCConfig.turbine_max_size;
    public double bearingTension = 0.0;
    public final DoubleList expansionLevels = new DoubleArrayList();
    public final DoubleList rawBladeEfficiencies = new DoubleArrayList();
    @SideOnly(value=Side.CLIENT)
    public static final int SOUND_LENGTH = 186;
    @SideOnly(value=Side.CLIENT)
    public List<SoundHandler.SoundInfo> activeSounds;
    public int soundCount = this.rand.nextInt(20);
    public boolean refreshSoundInfo = true;
    public float prevAngVel = 0.0f;
    public String particleEffect = "cloud";
    public double particleSpeedMult = 0.04310344827586207;
    public float angVel = 0.0f;
    public float rotorAngle = 0.0f;
    public Iterable<BlockPos.MutableBlockPos>[] inputPlane = new Iterable[4];
    public boolean nbtUpdateRenderDataFlag = false;
    public boolean shouldSpecialRenderRotor = false;
    public BlockPos[] bladePosArray = null;
    public Vector3f[] renderPosArray = null;
    public float[] bladeAngleArray = null;
    public IBlockState[] rotorStateArray = null;
    public final IntList bladeDepths = new IntArrayList();
    public final IntList statorDepths = new IntArrayList();
    protected final Set<EntityPlayer> updatePacketListeners;

    public Turbine(World world) {
        super(world, Turbine.class, ITurbinePart.class);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
        this.updatePacketListeners = new ObjectOpenHashSet();
    }

    @Override
    @Nonnull
    public TurbineLogic getLogic() {
        return this.logic;
    }

    @Override
    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (TurbineLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
    }

    @Override
    public Multiblock.PartSuperMap<Turbine, ITurbinePart> getPartSuperMap() {
        return this.partSuperMap;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return this.logic.getMinimumInteriorLength();
    }

    @Override
    protected int getMaximumInteriorLength() {
        return this.logic.getMaximumInteriorLength();
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return NCMath.hollowCuboid(Math.max(5, this.getMinimumInteriorLength() + 2), Math.max(5, this.getMinimumInteriorLength() + 2), this.getMinimumInteriorLength() + 2);
    }

    @Override
    public void onAttachedPartWithMultiblockData(ITurbinePart part, NBTTagCompound data) {
        this.logic.onAttachedPartWithMultiblockData(part, data);
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(ITurbinePart newPart) {
        this.onPartAdded(newPart);
        this.logic.onBlockAdded(newPart);
    }

    @Override
    protected void onBlockRemoved(ITurbinePart oldPart) {
        this.onPartRemoved(oldPart);
        this.logic.onBlockRemoved(oldPart);
    }

    @Override
    protected void onMachineAssembled() {
        this.logic.onMachineAssembled();
    }

    @Override
    protected void onMachineRestored() {
        this.logic.onMachineRestored();
    }

    @Override
    protected void onMachinePaused() {
        this.logic.onMachinePaused();
    }

    @Override
    protected void onMachineDisassembled() {
        this.logic.onMachineDisassembled();
    }

    @Override
    protected boolean isMachineWhole() {
        this.shouldSpecialRenderRotor = false;
        return this.setLogic(this) && super.isMachineWhole() && this.logic.isMachineWhole();
    }

    public boolean setLogic(Turbine multiblock) {
        if (this.getPartMap(ITurbineController.class).isEmpty()) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.getPartCount(ITurbineController.class) > 1) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        Iterator<ITurbineController> iterator = this.getParts(ITurbineController.class).iterator();
        while (iterator.hasNext()) {
            ITurbineController contr;
            this.controller = contr = iterator.next();
        }
        this.setLogic(this.controller.getLogicID());
        return true;
    }

    @Override
    protected void onAssimilate(Turbine assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    @Override
    protected void onAssimilated(Turbine assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    public int getFlowLength() {
        return this.getInteriorLength(this.flowDir);
    }

    protected int getBladeArea() {
        return 4 * this.shaftWidth * this.bladeLength;
    }

    protected int getBladeVolume() {
        return this.getBladeArea() * this.noBladeSets;
    }

    public double getRotorRadius() {
        return (double)this.bladeLength + (double)this.shaftWidth / 2.0;
    }

    public int getMinimumBladeArea() {
        return 4 * Math.max(1, this.getMinimumInteriorLength() - 2);
    }

    public int getMinimumBladeVolume() {
        return this.getBladeArea() * this.getMinimumInteriorLength();
    }

    protected TurbineRotorBladeUtil.ITurbineRotorBlade<?> getBlade(BlockPos pos) {
        long posLong = pos.func_177986_g();
        TileTurbineRotorBlade blade = (TileTurbineRotorBlade)this.getPartMap(TileTurbineRotorBlade.class).get(posLong);
        return blade == null ? (TurbineRotorBladeUtil.ITurbineRotorBlade)this.getPartMap(TileTurbineRotorStator.class).get(posLong) : blade;
    }

    public TurbineRotorBladeUtil.TurbinePartDir getShaftDir() {
        if (this.flowDir == null) {
            return TurbineRotorBladeUtil.TurbinePartDir.Y;
        }
        switch (this.flowDir.func_176740_k()) {
            case Y: {
                return TurbineRotorBladeUtil.TurbinePartDir.Y;
            }
            case Z: {
                return TurbineRotorBladeUtil.TurbinePartDir.Z;
            }
            case X: {
                return TurbineRotorBladeUtil.TurbinePartDir.X;
            }
        }
        return TurbineRotorBladeUtil.TurbinePartDir.Y;
    }

    public TurbineRotorBladeUtil.TurbinePartDir getBladeDir(PlaneDir planeDir) {
        if (this.flowDir == null) {
            return TurbineRotorBladeUtil.TurbinePartDir.Y;
        }
        switch (this.flowDir.func_176740_k()) {
            case Y: {
                switch (planeDir) {
                    case U: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Z;
                    }
                    case V: {
                        return TurbineRotorBladeUtil.TurbinePartDir.X;
                    }
                }
                break;
            }
            case Z: {
                switch (planeDir) {
                    case U: {
                        return TurbineRotorBladeUtil.TurbinePartDir.X;
                    }
                    case V: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Y;
                    }
                }
                break;
            }
            case X: {
                switch (planeDir) {
                    case U: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Y;
                    }
                    case V: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Z;
                    }
                }
                break;
            }
            default: {
                return TurbineRotorBladeUtil.TurbinePartDir.Y;
            }
        }
        return TurbineRotorBladeUtil.TurbinePartDir.Y;
    }

    @Override
    protected boolean updateServer() {
        boolean flag = false;
        if (this.logic.onUpdateServer()) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    @Override
    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.writeEnergy(this.energyStorage, data, "energyStorage");
        this.writeTanks(this.tanks, data, "tanks");
        data.func_74757_a("isTurbineOn", this.isTurbineOn);
        data.func_74757_a("computerActivated", this.computerActivated);
        data.func_74757_a("isProcessing", this.isProcessing);
        data.func_74780_a("power", this.power);
        data.func_74780_a("rawPower", this.rawPower);
        data.func_74780_a("rawLimitPower", this.rawLimitPower);
        data.func_74780_a("rawMaxPower", this.rawMaxPower);
        data.func_74768_a("flowDir", this.flowDir == null ? -1 : this.flowDir.func_176745_a());
        data.func_74780_a("conductivity", this.conductivity);
        data.func_74780_a("rotorEfficiency", this.rotorEfficiency);
        data.func_74780_a("powerBonus", this.powerBonus);
        data.func_74778_a("particleEffect", this.particleEffect);
        data.func_74780_a("particleSpeedMult", this.particleSpeedMult);
        data.func_74776_a("angVel", this.angVel);
        data.func_74776_a("rotorAngle", this.rotorAngle);
        NBTHelper.writeBlockPosArray(data, this.bladePosArray, "bladePosArray");
        NBTHelper.writeVector3fArray(data, this.renderPosArray, "renderPosArray");
        NBTHelper.writeFloatArray(data, this.bladeAngleArray, "bladeAngleArray");
        data.func_74768_a("shaftWidth", this.shaftWidth);
        data.func_74768_a("shaftVolume", this.inertia);
        data.func_74768_a("bladeLength", this.bladeLength);
        data.func_74768_a("noBladeSets", this.noBladeSets);
        data.func_74768_a("recipeInputRate", this.recipeInputRate);
        data.func_74768_a("dynamoCoilCount", this.dynamoCoilCount);
        data.func_74768_a("dynamoCoilCountOpposite", this.dynamoCoilCountOpposite);
        data.func_74780_a("totalExpansionLevel", this.totalExpansionLevel);
        data.func_74780_a("idealTotalExpansionLevel", this.idealTotalExpansionLevel);
        data.func_74780_a("spinUpMultiplier", this.spinUpMultiplier);
        data.func_74780_a("basePowerPerMB", this.basePowerPerMB);
        data.func_74780_a("recipeInputRateFP", this.recipeInputRateFP);
        data.func_74780_a("minBladeExpansionCoefficient", this.minBladeExpansionCoefficient);
        data.func_74780_a("maxBladeExpansionCoefficient", this.maxBladeExpansionCoefficient);
        data.func_74780_a("minStatorExpansionCoefficient", this.minStatorExpansionCoefficient);
        data.func_74780_a("maxStatorExpansionCoefficient", this.maxStatorExpansionCoefficient);
        data.func_74768_a("effectiveMaxLength", this.effectiveMaxLength);
        data.func_74780_a("bearingTension", this.bearingTension);
        NBTHelper.writeDoubleCollection(data, (DoubleCollection)this.expansionLevels, "expansionLevels");
        NBTHelper.writeDoubleCollection(data, (DoubleCollection)this.rawBladeEfficiencies, "rawBladeEfficiencies");
        this.writeLogicNBT(data, syncReason);
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.readEnergy(this.energyStorage, data, "energyStorage");
        this.readTanks(this.tanks, data, "turbineTanks");
        this.isTurbineOn = data.func_74767_n("isTurbineOn");
        this.computerActivated = data.func_74767_n("computerActivated");
        this.isProcessing = data.func_74767_n("isProcessing");
        this.power = data.func_74769_h("power");
        this.rawPower = data.func_74769_h("rawPower");
        this.rawLimitPower = data.func_74769_h("rawLimitPower");
        this.rawMaxPower = data.func_74769_h("rawMaxPower");
        this.flowDir = data.func_74762_e("flowDir") < 0 ? null : EnumFacing.field_82609_l[data.func_74762_e("flowDir")];
        this.conductivity = data.func_74769_h("conductivity");
        this.rotorEfficiency = data.func_74769_h("rotorEfficiency");
        this.powerBonus = data.func_74769_h("powerBonus");
        this.particleEffect = data.func_74779_i("particleEffect");
        this.particleSpeedMult = data.func_74769_h("particleSpeedMult");
        this.angVel = data.func_74760_g("angVel");
        this.rotorAngle = data.func_74760_g("rotorAngle");
        this.bladePosArray = NBTHelper.readBlockPosArray(data, "bladePosArray");
        this.renderPosArray = NBTHelper.readVector3fArray(data, "renderPosArray");
        this.bladeAngleArray = NBTHelper.readFloatArray(data, "bladeAngleArray");
        this.shaftWidth = data.func_74762_e("shaftWidth");
        this.inertia = data.func_74762_e("shaftVolume");
        this.bladeLength = data.func_74762_e("bladeLength");
        this.noBladeSets = data.func_74762_e("noBladeSets");
        this.recipeInputRate = data.func_74762_e("recipeInputRate");
        this.dynamoCoilCount = data.func_74762_e("dynamoCoilCount");
        this.dynamoCoilCountOpposite = data.func_74762_e("dynamoCoilCountOpposite");
        this.totalExpansionLevel = data.func_74769_h("totalExpansionLevel");
        this.idealTotalExpansionLevel = data.func_74769_h("idealTotalExpansionLevel");
        this.spinUpMultiplier = data.func_74769_h("spinUpMultiplier");
        this.basePowerPerMB = data.func_74769_h("basePowerPerMB");
        this.recipeInputRateFP = data.func_74769_h("recipeInputRateFP");
        this.minBladeExpansionCoefficient = data.func_74769_h("minBladeExpansionCoefficient");
        this.maxBladeExpansionCoefficient = data.func_74769_h("maxBladeExpansionCoefficient");
        this.minStatorExpansionCoefficient = data.func_74769_h("minStatorExpansionCoefficient");
        this.maxStatorExpansionCoefficient = data.func_74769_h("maxStatorExpansionCoefficient");
        this.effectiveMaxLength = data.func_74762_e("effectiveMaxLength");
        this.bearingTension = data.func_74769_h("bearingTension");
        NBTHelper.readDoubleCollection(data, (DoubleCollection)this.expansionLevels, "expansionLevels");
        NBTHelper.readDoubleCollection(data, (DoubleCollection)this.rawBladeEfficiencies, "rawBladeEfficiencies");
        this.nbtUpdateRenderDataFlag = true;
        this.readLogicNBT(data, syncReason);
    }

    @Override
    public Set<EntityPlayer> getMultiblockUpdatePacketListeners() {
        return this.updatePacketListeners;
    }

    @Override
    public TurbineUpdatePacket getMultiblockUpdatePacket() {
        return this.logic.getMultiblockUpdatePacket();
    }

    @Override
    public void onMultiblockUpdatePacket(TurbineUpdatePacket message) {
        this.logic.onMultiblockUpdatePacket(message);
    }

    protected TurbineRenderPacket getRenderPacket() {
        return this.logic.getRenderPacket();
    }

    public void onRenderPacket(TurbineRenderPacket message) {
        this.logic.onRenderPacket(message);
    }

    public void sendRenderPacketToPlayer(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        TurbineRenderPacket packet = this.getRenderPacket();
        if (packet == null) {
            return;
        }
        PacketHandler.instance.sendTo((IMessage)packet, (EntityPlayerMP)player);
    }

    public void sendRenderPacketToAll() {
        if (this.WORLD.field_72995_K) {
            return;
        }
        TurbineRenderPacket packet = this.getRenderPacket();
        if (packet == null) {
            return;
        }
        PacketHandler.instance.sendToAll((IMessage)packet);
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return this.logic.isBlockGoodForInterior(world, pos);
    }

    @Override
    public void clearAllMaterial() {
        this.logic.clearAllMaterial();
        super.clearAllMaterial();
    }

    public static enum PlaneDir {
        U,
        V;

    }
}

