/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Vector3f;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.init.NCBlocks;
import nc.init.NCSounds;
import nc.multiblock.IPacketMultiblockLogic;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.MultiblockRegistry;
import nc.multiblock.tile.TileBeefAbstract;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.block.BlockTurbineRotorShaft;
import nc.multiblock.turbine.tile.ITurbineController;
import nc.multiblock.turbine.tile.ITurbinePart;
import nc.multiblock.turbine.tile.TileTurbineDynamoPart;
import nc.multiblock.turbine.tile.TileTurbineInlet;
import nc.multiblock.turbine.tile.TileTurbineOutlet;
import nc.multiblock.turbine.tile.TileTurbineRotorBearing;
import nc.multiblock.turbine.tile.TileTurbineRotorBlade;
import nc.multiblock.turbine.tile.TileTurbineRotorShaft;
import nc.multiblock.turbine.tile.TileTurbineRotorStator;
import nc.network.multiblock.TurbineRenderPacket;
import nc.network.multiblock.TurbineUpdatePacket;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.util.MaterialHelper;
import nc.util.NCMath;
import nc.util.NCUtil;
import nc.util.SoundHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TurbineLogic
extends MultiblockLogic<Turbine, TurbineLogic, ITurbinePart>
implements IPacketMultiblockLogic<Turbine, TurbineLogic, ITurbinePart, TurbineUpdatePacket> {
    public boolean searchFlag = false;
    public final ObjectSet<TileTurbineDynamoPart> dynamoPartCache = new ObjectOpenHashSet();
    public final ObjectSet<TileTurbineDynamoPart> dynamoPartCacheOpposite = new ObjectOpenHashSet();
    public final Long2ObjectMap<TileTurbineDynamoPart> componentFailCache = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<TileTurbineDynamoPart> assumedValidCache = new Long2ObjectOpenHashMap();

    public TurbineLogic(Turbine turbine) {
        super(turbine);
    }

    public TurbineLogic(TurbineLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "turbine";
    }

    protected Turbine getTurbine() {
        return (Turbine)this.multiblock;
    }

    @Override
    public int getMinimumInteriorLength() {
        return NCConfig.turbine_min_size;
    }

    @Override
    public int getMaximumInteriorLength() {
        return NCConfig.turbine_max_size;
    }

    @Override
    public void onMachineAssembled() {
        this.onTurbineFormed();
    }

    @Override
    public void onMachineRestored() {
        this.onTurbineFormed();
    }

    protected void onTurbineFormed() {
        Iterator<ITurbinePart> iterator = this.getParts(ITurbineController.class).iterator();
        while (iterator.hasNext()) {
            ITurbineController contr;
            this.getTurbine().controller = contr = iterator.next();
        }
        this.setIsTurbineOn();
        if (!this.getWorld().field_72995_K) {
            this.getTurbine().energyStorage.setStorageCapacity(64000 * this.getTurbine().getExteriorSurfaceArea());
            this.getTurbine().energyStorage.setMaxTransfer(64000 * this.getTurbine().getExteriorSurfaceArea());
            this.getTurbine().tanks.get(0).setCapacity(4000 * this.getTurbine().getExteriorSurfaceArea());
            this.getTurbine().tanks.get(1).setCapacity(16000 * this.getTurbine().getExteriorSurfaceArea());
        }
        if (this.getTurbine().flowDir == null) {
            return;
        }
        if (!this.getWorld().field_72995_K) {
            IBlockState state;
            EnumFacing[] pos;
            this.componentFailCache.clear();
            do {
                this.assumedValidCache.clear();
                this.refreshDynamos();
            } while (this.searchFlag);
            this.refreshDynamoStats();
            for (TileTurbineRotorShaft shaft : this.getParts(TileTurbineRotorShaft.class)) {
                pos = shaft.func_174877_v();
                state = this.getWorld().func_180495_p((BlockPos)pos);
                if (!(state.func_177230_c() instanceof BlockTurbineRotorShaft)) continue;
                this.getWorld().func_175656_a((BlockPos)pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)TurbineRotorBladeUtil.TurbinePartDir.INVISIBLE)));
            }
            for (TileTurbineRotorBlade blade : this.getParts(TileTurbineRotorBlade.class)) {
                pos = blade.bladePos();
                state = this.getWorld().func_180495_p((BlockPos)pos);
                if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
                this.getWorld().func_175656_a((BlockPos)pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)TurbineRotorBladeUtil.TurbinePartDir.INVISIBLE)));
            }
            for (TileTurbineRotorStator stator : this.getParts(TileTurbineRotorStator.class)) {
                pos = stator.bladePos();
                state = this.getWorld().func_180495_p((BlockPos)pos);
                if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
                this.getWorld().func_175656_a((BlockPos)pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)TurbineRotorBladeUtil.TurbinePartDir.INVISIBLE)));
            }
            for (TileTurbineDynamoPart dynamoPart : this.getParts(TileTurbineDynamoPart.class)) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    dynamoPart.setEnergyConnection(side == this.getTurbine().flowDir || side == this.getTurbine().flowDir.func_176734_d() ? EnergyConnection.OUT : EnergyConnection.NON, side);
                }
            }
            for (TileTurbineOutlet outlet : this.getParts(TileTurbineOutlet.class)) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    outlet.setTankSorption(side, 0, side == this.getTurbine().flowDir ? TankSorption.OUT : TankSorption.NON);
                }
            }
        }
        EnumFacing oppositeDir = this.getTurbine().flowDir.func_176734_d();
        int flowLength = this.getTurbine().getFlowLength();
        int bladeLength = this.getTurbine().bladeLength;
        int shaftWidth = this.getTurbine().shaftWidth;
        this.getTurbine().inputPlane[0] = this.getTurbine().getInteriorPlane(oppositeDir, 0, 0, 0, bladeLength, shaftWidth + bladeLength);
        this.getTurbine().inputPlane[1] = this.getTurbine().getInteriorPlane(oppositeDir, 0, shaftWidth + bladeLength, 0, 0, bladeLength);
        this.getTurbine().inputPlane[2] = this.getTurbine().getInteriorPlane(oppositeDir, 0, bladeLength, shaftWidth + bladeLength, 0, 0);
        this.getTurbine().inputPlane[3] = this.getTurbine().getInteriorPlane(oppositeDir, 0, 0, bladeLength, shaftWidth + bladeLength, 0);
        if (!this.getWorld().field_72995_K) {
            this.getTurbine().renderPosArray = new Vector3f[(1 + 4 * shaftWidth) * flowLength];
            for (int depth = 0; depth < flowLength; ++depth) {
                for (int w = 0; w < shaftWidth; ++w) {
                    this.getTurbine().renderPosArray[w + depth * shaftWidth] = this.getTurbine().getMiddleInteriorPlaneCoord(oppositeDir, depth, 1 + w + bladeLength, 0, shaftWidth - w + bladeLength, shaftWidth + bladeLength);
                    this.getTurbine().renderPosArray[w + (depth + flowLength) * shaftWidth] = this.getTurbine().getMiddleInteriorPlaneCoord(oppositeDir, depth, 0, shaftWidth - w + bladeLength, shaftWidth + bladeLength, 1 + w + bladeLength);
                    this.getTurbine().renderPosArray[w + (depth + 2 * flowLength) * shaftWidth] = this.getTurbine().getMiddleInteriorPlaneCoord(oppositeDir, depth, shaftWidth + bladeLength, 1 + w + bladeLength, 0, shaftWidth - w + bladeLength);
                    this.getTurbine().renderPosArray[w + (depth + 3 * flowLength) * shaftWidth] = this.getTurbine().getMiddleInteriorPlaneCoord(oppositeDir, depth, shaftWidth - w + bladeLength, shaftWidth + bladeLength, 1 + w + bladeLength, 0);
                }
                this.getTurbine().renderPosArray[depth + 4 * flowLength * shaftWidth] = this.getTurbine().getMiddleInteriorPlaneCoord(oppositeDir, depth, 0, 0, 0, 0);
            }
            if (this.getTurbine().controller != null) {
                this.getTurbine().sendMultiblockUpdatePacketToAll();
                this.getTurbine().markReferenceCoordForUpdate();
            }
        }
    }

    protected void refreshDynamos() {
        this.searchFlag = false;
        if (this.getPartMap(TileTurbineDynamoPart.class).isEmpty()) {
            this.getTurbine().conductivity = 0.0;
            return;
        }
        for (TileTurbineDynamoPart dynamoPart : this.getParts(TileTurbineDynamoPart.class)) {
            dynamoPart.isInValidPosition = false;
            dynamoPart.isSearched = false;
        }
        this.dynamoPartCache.clear();
        this.dynamoPartCacheOpposite.clear();
        for (TileTurbineDynamoPart dynamoPart : this.getParts(TileTurbineDynamoPart.class)) {
            if (!dynamoPart.isSearchRoot()) continue;
            this.iterateDynamoSearch(dynamoPart, dynamoPart.getPartPosition().getFacing() == this.getTurbine().flowDir ? this.dynamoPartCache : this.dynamoPartCacheOpposite);
        }
        for (TileTurbineDynamoPart dynamoPart : this.assumedValidCache.values()) {
            if (dynamoPart.isInValidPosition) continue;
            this.componentFailCache.put(dynamoPart.func_174877_v().func_177986_g(), (Object)dynamoPart);
            this.searchFlag = true;
        }
    }

    protected void iterateDynamoSearch(TileTurbineDynamoPart rootDynamoPart, ObjectSet<TileTurbineDynamoPart> currentDynamoPartCache) {
        ObjectOpenHashSet searchCache = new ObjectOpenHashSet();
        rootDynamoPart.dynamoSearch(currentDynamoPartCache, (ObjectSet<TileTurbineDynamoPart>)searchCache, this.componentFailCache, this.assumedValidCache);
        do {
            ObjectIterator searchIterator = searchCache.iterator();
            ObjectOpenHashSet searchSubCache = new ObjectOpenHashSet();
            while (searchIterator.hasNext()) {
                TileTurbineDynamoPart component = (TileTurbineDynamoPart)searchIterator.next();
                searchIterator.remove();
                component.dynamoSearch(currentDynamoPartCache, (ObjectSet<TileTurbineDynamoPart>)searchSubCache, this.componentFailCache, this.assumedValidCache);
            }
            searchCache.addAll((Collection)searchSubCache);
        } while (!searchCache.isEmpty());
    }

    protected void refreshDynamoStats() {
        this.getTurbine().dynamoCoilCountOpposite = 0;
        this.getTurbine().dynamoCoilCount = 0;
        double newConductivity = 0.0;
        double newConductivityOpposite = 0.0;
        for (TileTurbineDynamoPart dynamoPart : this.dynamoPartCache) {
            if (dynamoPart.conductivity == null) continue;
            ++this.getTurbine().dynamoCoilCount;
            newConductivity += dynamoPart.conductivity.doubleValue();
        }
        for (TileTurbineDynamoPart dynamoPart : this.dynamoPartCacheOpposite) {
            if (dynamoPart.conductivity == null) continue;
            ++this.getTurbine().dynamoCoilCountOpposite;
            newConductivityOpposite += dynamoPart.conductivity.doubleValue();
        }
        int bearingCount = this.getPartCount(TileTurbineRotorBearing.class);
        newConductivity = this.getTurbine().dynamoCoilCount == 0 ? 0.0 : newConductivity / Math.max((double)bearingCount / 2.0, (double)this.getTurbine().dynamoCoilCount);
        newConductivityOpposite = this.getTurbine().dynamoCoilCountOpposite == 0 ? 0.0 : newConductivityOpposite / Math.max((double)bearingCount / 2.0, (double)this.getTurbine().dynamoCoilCountOpposite);
        this.getTurbine().conductivity = (newConductivity + newConductivityOpposite) / 2.0;
    }

    @Override
    public void onMachinePaused() {
    }

    @Override
    public void onMachineDisassembled() {
        this.onTurbineBroken();
    }

    public void onTurbineBroken() {
        this.makeRotorVisible();
        this.getTurbine().isProcessing = false;
        this.getTurbine().isTurbineOn = false;
        if (this.getTurbine().controller != null) {
            this.getTurbine().controller.setActivity(false);
        }
        this.getTurbine().rotorEfficiency = 0.0;
        this.getTurbine().conductivity = 0.0;
        this.getTurbine().rawMaxPower = 0.0;
        this.getTurbine().rawLimitPower = 0.0;
        this.getTurbine().rawPower = 0.0;
        this.getTurbine().power = 0.0;
        this.getTurbine().rotorAngle = 0.0f;
        this.getTurbine().angVel = 0.0f;
        this.getTurbine().flowDir = null;
        this.getTurbine().recipeInputRate = 0;
        this.getTurbine().noBladeSets = 0;
        this.getTurbine().bladeLength = 0;
        this.getTurbine().inertia = 0;
        this.getTurbine().shaftWidth = 0;
        this.getTurbine().idealTotalExpansionLevel = 1.0;
        this.getTurbine().totalExpansionLevel = 1.0;
        this.getTurbine().minBladeExpansionCoefficient = Double.MAX_VALUE;
        this.getTurbine().maxBladeExpansionCoefficient = 1.0;
        this.getTurbine().minStatorExpansionCoefficient = 1.0;
        this.getTurbine().maxStatorExpansionCoefficient = Double.MIN_VALUE;
        this.getTurbine().particleEffect = "cloud";
        this.getTurbine().particleSpeedMult = 0.04310344827586207;
        this.getTurbine().recipeInputRateFP = 0.0;
        this.getTurbine().basePowerPerMB = 0.0;
        this.getTurbine().expansionLevels.clear();
        this.getTurbine().rawBladeEfficiencies.clear();
        this.getTurbine().inputPlane[3] = null;
        this.getTurbine().inputPlane[2] = null;
        this.getTurbine().inputPlane[1] = null;
        this.getTurbine().inputPlane[0] = null;
        for (TileTurbineDynamoPart dynamoPart : this.getParts(TileTurbineDynamoPart.class)) {
            dynamoPart.isInValidPosition = false;
            dynamoPart.isSearched = false;
        }
        if (this.getWorld().field_72995_K) {
            this.stopSounds();
        }
    }

    protected void makeRotorVisible() {
        this.getTurbine().shouldSpecialRenderRotor = false;
        if (this.getTurbine().flowDir != null) {
            IBlockState state;
            BlockPos pos;
            TurbineRotorBladeUtil.TurbinePartDir shaftDir = this.getTurbine().getShaftDir();
            for (TileTurbineRotorShaft shaft : this.getParts(TileTurbineRotorShaft.class)) {
                pos = shaft.func_174877_v();
                state = this.getWorld().func_180495_p(pos);
                if (!(state.func_177230_c() instanceof BlockTurbineRotorShaft)) continue;
                this.getWorld().func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)shaftDir)));
            }
            for (TileTurbineRotorBlade blade : this.getParts(TileTurbineRotorBlade.class)) {
                pos = blade.bladePos();
                state = this.getWorld().func_180495_p(pos);
                if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
                this.getWorld().func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)blade.getDir())));
            }
            for (TileTurbineRotorStator stator : this.getParts(TileTurbineRotorStator.class)) {
                pos = stator.bladePos();
                state = this.getWorld().func_180495_p(pos);
                if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
                this.getWorld().func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)stator.getDir())));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMachineWhole() {
        block35: {
            void var20_32;
            Object pos;
            int minX = this.getTurbine().getMinX();
            int minY = this.getTurbine().getMinY();
            int minZ = this.getTurbine().getMinZ();
            int maxX = this.getTurbine().getMaxX();
            int maxY = this.getTurbine().getMaxY();
            int maxZ = this.getTurbine().getMaxZ();
            boolean dirMinX = false;
            boolean dirMaxX = false;
            boolean dirMinY = false;
            boolean dirMaxY = false;
            boolean dirMinZ = false;
            boolean dirMaxZ = false;
            EnumFacing.Axis axis = null;
            boolean tooManyAxes = false;
            boolean notInAWall = false;
            for (TileTurbineRotorBearing bearing : this.getParts(TileTurbineRotorBearing.class)) {
                BlockPos pos2 = bearing.func_174877_v();
                if (pos2.func_177958_n() == minX) {
                    dirMinX = true;
                    continue;
                }
                if (pos2.func_177958_n() == maxX) {
                    dirMaxX = true;
                    continue;
                }
                if (pos2.func_177956_o() == minY) {
                    dirMinY = true;
                    continue;
                }
                if (pos2.func_177956_o() == maxY) {
                    dirMaxY = true;
                    continue;
                }
                if (pos2.func_177952_p() == minZ) {
                    dirMinZ = true;
                    continue;
                }
                if (pos2.func_177952_p() == maxZ) {
                    dirMaxZ = true;
                    continue;
                }
                notInAWall = true;
            }
            if (dirMinX && dirMaxX) {
                axis = EnumFacing.Axis.X;
            }
            if (dirMinY && dirMaxY) {
                if (axis != null) {
                    tooManyAxes = true;
                } else {
                    axis = EnumFacing.Axis.Y;
                }
            }
            if (dirMinZ && dirMaxZ) {
                if (axis != null) {
                    tooManyAxes = true;
                } else {
                    axis = EnumFacing.Axis.Z;
                }
            }
            if (axis == null) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.need_bearings", null, new Object[0]);
                return false;
            }
            if (axis == EnumFacing.Axis.X && this.getTurbine().getInteriorLengthY() != this.getTurbine().getInteriorLengthZ() || axis == EnumFacing.Axis.Y && this.getTurbine().getInteriorLengthZ() != this.getTurbine().getInteriorLengthX() || axis == EnumFacing.Axis.Z && this.getTurbine().getInteriorLengthX() != this.getTurbine().getInteriorLengthY() || tooManyAxes || notInAWall) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.bearings_side_square", null, new Object[0]);
                return false;
            }
            int internalDiameter = axis == EnumFacing.Axis.X ? this.getTurbine().getInteriorLengthY() : (axis == EnumFacing.Axis.Y ? this.getTurbine().getInteriorLengthZ() : this.getTurbine().getInteriorLengthX());
            boolean isEvenDiameter = (internalDiameter & 1) == 0;
            boolean validAmountOfBearings = false;
            int n = this.getTurbine().shaftWidth = isEvenDiameter ? 2 : 1;
            while (this.getTurbine().shaftWidth <= internalDiameter - 2) {
                if (this.getPartCount(TileTurbineRotorBearing.class) == 2 * this.getTurbine().shaftWidth * this.getTurbine().shaftWidth) {
                    validAmountOfBearings = true;
                    break;
                }
                this.getTurbine().shaftWidth += 2;
            }
            if (!validAmountOfBearings) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.bearings_centre_and_square", null, new Object[0]);
                return false;
            }
            this.getTurbine().bladeLength = (internalDiameter - this.getTurbine().shaftWidth) / 2;
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis), -1, this.getTurbine().bladeLength, this.getTurbine().bladeLength, this.getTurbine().bladeLength, this.getTurbine().bladeLength)) {
                if (this.getPartMap(TileTurbineRotorBearing.class).containsKey(blockPos.func_177986_g())) continue;
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.bearings_centre_and_square", blockPos, new Object[0]);
                return false;
            }
            for (BlockPos iterator : this.getTurbine().getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis), -1, this.getTurbine().bladeLength, this.getTurbine().bladeLength, this.getTurbine().bladeLength, this.getTurbine().bladeLength)) {
                if (this.getPartMap(TileTurbineRotorBearing.class).containsKey(iterator.func_177986_g())) continue;
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.bearings_centre_and_square", iterator, new Object[0]);
                return false;
            }
            this.getTurbine().flowDir = null;
            if (this.getPartMap(TileTurbineInlet.class).isEmpty() || this.getPartMap(TileTurbineOutlet.class).isEmpty()) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", null, new Object[0]);
                return false;
            }
            for (TileTurbineInlet tileTurbineInlet : this.getParts(TileTurbineInlet.class)) {
                pos = tileTurbineInlet.func_174877_v();
                if (this.getTurbine().isInMinWall(axis, (BlockPos)pos)) {
                    EnumFacing enumFacing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
                    if (this.getTurbine().flowDir != null && this.getTurbine().flowDir != enumFacing) {
                        ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
                        return false;
                    }
                    this.getTurbine().flowDir = enumFacing;
                    continue;
                }
                if (this.getTurbine().isInMaxWall(axis, (BlockPos)pos)) {
                    EnumFacing enumFacing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
                    if (this.getTurbine().flowDir != null && this.getTurbine().flowDir != enumFacing) {
                        ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
                        return false;
                    }
                    this.getTurbine().flowDir = enumFacing;
                    continue;
                }
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
                return false;
            }
            if (this.getTurbine().flowDir == null) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", null, new Object[0]);
                return false;
            }
            for (TileTurbineOutlet tileTurbineOutlet : this.getParts(TileTurbineOutlet.class)) {
                pos = tileTurbineOutlet.func_174877_v();
                if (this.getTurbine().isInWall(this.getTurbine().flowDir, (BlockPos)pos)) continue;
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
                return false;
            }
            int flowLength = this.getTurbine().getFlowLength();
            boolean bl = false;
            while (var20_32 < flowLength) {
                for (BlockPos blockPos : this.getTurbine().getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis), (int)var20_32, this.getTurbine().bladeLength, this.getTurbine().bladeLength, this.getTurbine().bladeLength, this.getTurbine().bladeLength)) {
                    TileTurbineRotorShaft shaft = (TileTurbineRotorShaft)this.getPartMap(TileTurbineRotorShaft.class).get(blockPos.func_177986_g());
                    if (shaft != null) continue;
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.shaft_centre", blockPos, new Object[0]);
                    return false;
                }
                ++var20_32;
            }
            if (!this.areBladesValid()) {
                return false;
            }
            if (!NCUtil.areEqual(this.getTurbine().getFlowLength(), this.getTurbine().expansionLevels.size(), this.getTurbine().rawBladeEfficiencies.size())) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", null, new Object[0]);
                return false;
            }
            for (ITurbineController controller2 : this.getParts(ITurbineController.class)) {
                controller2.setIsRenderer(false);
            }
            Iterator<ITurbineController> iterator = this.getParts(ITurbineController.class).iterator();
            if (!iterator.hasNext()) break block35;
            ITurbineController controller = iterator.next();
            if (this.getTurbine().shouldSpecialRenderRotor) {
                controller.setIsRenderer(true);
            }
        }
        return true;
    }

    public boolean areBladesValid() {
        int flowLength = this.getTurbine().getFlowLength();
        this.getTurbine().inertia = this.getTurbine().shaftWidth * (this.getTurbine().shaftWidth + 4 * this.getTurbine().bladeLength) * flowLength;
        this.getTurbine().noBladeSets = 0;
        this.getTurbine().totalExpansionLevel = 1.0;
        this.getTurbine().expansionLevels.clear();
        this.getTurbine().rawBladeEfficiencies.clear();
        this.getTurbine().bladePosArray = new BlockPos[4 * flowLength];
        this.getTurbine().bladeAngleArray = new float[4 * flowLength];
        for (int depth = 0; depth < flowLength; ++depth) {
            TurbineRotorBladeUtil.IRotorBladeType thisBladeType;
            TurbineRotorBladeUtil.ITurbineRotorBlade<?> thisBlade;
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir, depth, 0, 0, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, this.getTurbine().shaftWidth + this.getTurbine().bladeLength)) {
                if (!MaterialHelper.isReplaceable(this.getWorld().func_180495_p(blockPos).func_185904_a())) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.getWorld().func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir, depth, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, 0, 0, this.getTurbine().shaftWidth + this.getTurbine().bladeLength)) {
                if (!MaterialHelper.isReplaceable(this.getWorld().func_180495_p(blockPos).func_185904_a())) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.getWorld().func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir, depth, 0, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, 0)) {
                if (!MaterialHelper.isReplaceable(this.getWorld().func_180495_p(blockPos).func_185904_a())) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.getWorld().func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir, depth, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, 0, 0)) {
                if (!MaterialHelper.isReplaceable(this.getWorld().func_180495_p(blockPos).func_185904_a())) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.getWorld().func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            TurbineRotorBladeUtil.IRotorBladeType currentBladeType = null;
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir.func_176734_d(), depth, this.getTurbine().bladeLength, 0, this.getTurbine().bladeLength, this.getTurbine().shaftWidth + this.getTurbine().bladeLength)) {
                thisBlade = this.getTurbine().getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (currentBladeType == null) {
                    currentBladeType = thisBladeType;
                } else if (!currentBladeType.eq(thisBladeType)) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getTurbine().getBladeDir(Turbine.PlaneDir.V));
                this.getTurbine().bladePosArray[depth] = thisBlade.bladePos();
                this.getTurbine().bladeAngleArray[depth] = 45.0f;
            }
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir.func_176734_d(), depth, 0, this.getTurbine().bladeLength, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, this.getTurbine().bladeLength)) {
                thisBlade = this.getTurbine().getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (!currentBladeType.eq(thisBladeType)) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getTurbine().getBladeDir(Turbine.PlaneDir.U));
                this.getTurbine().bladePosArray[depth + flowLength] = thisBlade.bladePos();
                this.getTurbine().bladeAngleArray[depth + flowLength] = this.getTurbine().flowDir.func_176740_k() == EnumFacing.Axis.Z ? -45.0f : 45.0f;
            }
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir.func_176734_d(), depth, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, this.getTurbine().bladeLength, 0, this.getTurbine().bladeLength)) {
                thisBlade = this.getTurbine().getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (!currentBladeType.eq(thisBladeType)) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getTurbine().getBladeDir(Turbine.PlaneDir.U));
                this.getTurbine().bladePosArray[depth + 2 * flowLength] = thisBlade.bladePos();
                this.getTurbine().bladeAngleArray[depth + 2 * flowLength] = this.getTurbine().flowDir.func_176740_k() == EnumFacing.Axis.Z ? 45.0f : -45.0f;
            }
            for (BlockPos blockPos : this.getTurbine().getInteriorPlane(this.getTurbine().flowDir.func_176734_d(), depth, this.getTurbine().bladeLength, this.getTurbine().shaftWidth + this.getTurbine().bladeLength, this.getTurbine().bladeLength, 0)) {
                thisBlade = this.getTurbine().getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (!currentBladeType.eq(thisBladeType)) {
                    ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getTurbine().getBladeDir(Turbine.PlaneDir.V));
                this.getTurbine().bladePosArray[depth + 3 * flowLength] = thisBlade.bladePos();
                this.getTurbine().bladeAngleArray[depth + 3 * flowLength] = -45.0f;
            }
            if (currentBladeType == null) {
                ((Turbine)this.multiblock).setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", null, new Object[0]);
                return false;
            }
            this.getTurbine().expansionLevels.add(this.getTurbine().totalExpansionLevel * Math.sqrt(currentBladeType.getExpansionCoefficient()));
            this.getTurbine().totalExpansionLevel *= currentBladeType.getExpansionCoefficient();
            this.getTurbine().rawBladeEfficiencies.add(currentBladeType.getEfficiency());
            if (currentBladeType instanceof TurbineRotorBladeUtil.IRotorStatorType) {
                this.getTurbine().minStatorExpansionCoefficient = Math.min(currentBladeType.getExpansionCoefficient(), this.getTurbine().minStatorExpansionCoefficient);
                this.getTurbine().maxStatorExpansionCoefficient = Math.max(currentBladeType.getExpansionCoefficient(), this.getTurbine().maxStatorExpansionCoefficient);
                continue;
            }
            ++this.getTurbine().noBladeSets;
            this.getTurbine().minBladeExpansionCoefficient = Math.min(currentBladeType.getExpansionCoefficient(), this.getTurbine().minBladeExpansionCoefficient);
            this.getTurbine().maxBladeExpansionCoefficient = Math.max(currentBladeType.getExpansionCoefficient(), this.getTurbine().maxBladeExpansionCoefficient);
        }
        return true;
    }

    @Override
    public List<Pair<Class<? extends ITurbinePart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends ITurbinePart>, String>>();
    }

    @Override
    public void onAssimilate(Turbine assimilated) {
        this.getTurbine().energyStorage.mergeEnergyStorage(assimilated.energyStorage);
        this.getTurbine().rawPower += assimilated.rawPower;
        this.getTurbine().rawLimitPower += assimilated.rawLimitPower;
        this.getTurbine().rawMaxPower += assimilated.rawMaxPower;
        assimilated.rawMaxPower = 0.0;
        assimilated.rawLimitPower = 0.0;
        assimilated.rawPower = 0.0;
    }

    @Override
    public void onAssimilated(Turbine assimilator) {
        if (this.getWorld().field_72995_K) {
            this.clearSounds();
        }
    }

    @Override
    public boolean onUpdateServer() {
        int maxRecipeRateMultiplier;
        double tensionFactor;
        boolean flag = true;
        boolean wasProcessing = this.getTurbine().isProcessing;
        this.refreshRecipe();
        this.setRotorEfficiency();
        this.setEffectiveMaxLength();
        this.setInputRatePowerBonus();
        double previousRawPower = this.getTurbine().rawPower;
        double previousRawLimitPower = this.getTurbine().rawLimitPower;
        double previousRawMaxPower = this.getTurbine().rawMaxPower;
        this.getTurbine().rawLimitPower = this.getRawLimitProcessPower(this.getTurbine().recipeInputRate);
        this.getTurbine().rawMaxPower = this.getRawLimitProcessPower(this.getMaxRecipeRateMultiplier());
        boolean canProcess = this.canProcessInputs();
        if (canProcess) {
            this.getTurbine().isProcessing = true;
            this.produceProducts();
            this.getTurbine().rawPower = this.getNewRawProcessPower(previousRawPower, this.getTurbine().rawLimitPower, true);
        } else {
            this.getTurbine().isProcessing = false;
            this.getTurbine().rawMaxPower = previousRawMaxPower;
            this.getTurbine().rawPower = this.getNewRawProcessPower(previousRawPower, previousRawLimitPower, false);
        }
        this.getTurbine().power = this.getTurbine().rawPower * this.getTurbine().conductivity * this.getTurbine().rotorEfficiency * TurbineLogic.getExpansionIdealityMultiplier(this.getTurbine().idealTotalExpansionLevel, this.getTurbine().totalExpansionLevel) * this.getThroughputEfficiency() * this.getTurbine().powerBonus;
        float f = this.getTurbine().angVel = this.getTurbine().rawMaxPower == 0.0 ? 0.0f : (float)(NCConfig.turbine_render_rotor_speed * this.getTurbine().rawPower / this.getTurbine().rawMaxPower);
        if (wasProcessing != this.getTurbine().isProcessing && this.getTurbine().controller != null) {
            this.getTurbine().sendMultiblockUpdatePacketToAll();
        }
        double d = tensionFactor = (maxRecipeRateMultiplier = this.getMaxRecipeRateMultiplier()) <= 0 ? 0.0 : ((double)this.getTurbine().recipeInputRate - (double)maxRecipeRateMultiplier * (1.0 + NCConfig.turbine_tension_leniency)) / (double)maxRecipeRateMultiplier;
        tensionFactor = tensionFactor > 0.0 ? (tensionFactor /= NCConfig.turbine_tension_throughput_factor < 2.0 ? 1.0 : NCConfig.turbine_tension_throughput_factor - 1.0) : -Math.sqrt(-tensionFactor);
        this.getTurbine().bearingTension = Math.max(0.0, this.getTurbine().bearingTension + Math.min(1.0, tensionFactor) / (1200.0 * (double)this.getPartCount(TileTurbineRotorBearing.class)));
        if (this.getTurbine().bearingTension > 1.0) {
            this.bearingFailure();
            return true;
        }
        this.getTurbine().energyStorage.changeEnergyStored((long)this.getTurbine().power);
        if (this.getTurbine().controller != null) {
            this.getTurbine().sendMultiblockUpdatePacketToListeners();
            this.getTurbine().sendRenderPacketToAll();
        }
        return flag;
    }

    protected void bearingFailure() {
        this.makeRotorVisible();
        this.getTurbine().bearingTension = 0.0;
        Iterator<TileTurbineRotorBearing> bearingIterator = this.getPartIterator(TileTurbineRotorBearing.class);
        while (bearingIterator.hasNext()) {
            TileTurbineRotorBearing bearing = bearingIterator.next();
            bearing.onBearingFailure(bearingIterator);
        }
        Iterator<TileTurbineRotorBlade> bladeIterator = this.getPartIterator(TileTurbineRotorBlade.class);
        while (bladeIterator.hasNext()) {
            TileTurbineRotorBlade blade = bladeIterator.next();
            blade.onBearingFailure(bladeIterator);
        }
        Iterator<TileTurbineRotorStator> statorIterator = this.getPartIterator(TileTurbineRotorStator.class);
        while (statorIterator.hasNext()) {
            TileTurbineRotorStator stator = statorIterator.next();
            stator.onBearingFailure(statorIterator);
        }
        MultiblockRegistry.INSTANCE.addDirtyMultiblock(this.getWorld(), this.getTurbine());
        if (this.getTurbine().controller != null) {
            this.getTurbine().sendMultiblockUpdatePacketToAll();
        }
    }

    public void setIsTurbineOn() {
        boolean oldIsTurbineOn = this.getTurbine().isTurbineOn;
        boolean bl = this.getTurbine().isTurbineOn = (this.isRedstonePowered() || this.getTurbine().computerActivated) && this.getTurbine().isAssembled();
        if (this.getTurbine().isTurbineOn != oldIsTurbineOn && this.getTurbine().controller != null) {
            this.getTurbine().controller.setActivity(this.getTurbine().isTurbineOn);
            this.getTurbine().sendMultiblockUpdatePacketToAll();
        }
    }

    protected boolean isRedstonePowered() {
        return this.getTurbine().controller != null && this.getTurbine().controller.checkIsRedstonePowered(this.getWorld(), this.getTurbine().controller.getTilePos());
    }

    protected void refreshRecipe() {
        this.getTurbine().recipeInfo = NCRecipes.turbine.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getTurbine().tanks.subList(0, 1));
    }

    protected boolean canProcessInputs() {
        if (!this.setRecipeStats() || !this.getTurbine().isTurbineOn) {
            this.getTurbine().recipeInputRate = 0;
            this.getTurbine().recipeInputRateFP = 0.0;
            return false;
        }
        return this.canProduceProducts();
    }

    protected boolean setRecipeStats() {
        if (this.getTurbine().recipeInfo == null) {
            this.getTurbine().recipeInputRate = 0;
            return false;
        }
        BasicRecipe recipe = this.getTurbine().recipeInfo.getRecipe();
        this.getTurbine().basePowerPerMB = recipe.getTurbinePowerPerMB();
        this.getTurbine().idealTotalExpansionLevel = recipe.getTurbineExpansionLevel();
        this.getTurbine().spinUpMultiplier = recipe.getTurbineSpinUpMultiplier();
        this.getTurbine().particleEffect = recipe.getTurbineParticleEffect();
        this.getTurbine().particleSpeedMult = recipe.getTurbineParticleSpeedMultiplier();
        return true;
    }

    protected boolean canProduceProducts() {
        IFluidIngredient fluidProduct = this.getTurbine().recipeInfo.getRecipe().getFluidProducts().get(0);
        if (fluidProduct.getMaxStackSize(0) <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        int recipeInputRateDiff = this.getTurbine().recipeInputRate;
        this.getTurbine().recipeInputRate = Math.min(this.getTurbine().tanks.get(0).getFluidAmount(), (int)(NCConfig.turbine_tension_throughput_factor * (double)this.getMaxRecipeRateMultiplier()));
        recipeInputRateDiff = Math.abs(recipeInputRateDiff - this.getTurbine().recipeInputRate);
        double roundingFactor = Math.max(0.0, 1.5 * Math.log1p((double)this.getTurbine().recipeInputRate / (1.0 + (double)recipeInputRateDiff)));
        this.getTurbine().recipeInputRateFP = (roundingFactor * this.getTurbine().recipeInputRateFP + (double)this.getTurbine().recipeInputRate) / (1.0 + roundingFactor);
        if (!this.getTurbine().tanks.get(1).isEmpty()) {
            if (!this.getTurbine().tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getTurbine().tanks.get(1).getFluidAmount() + fluidProduct.getMaxStackSize(0) * this.getTurbine().recipeInputRate > this.getTurbine().tanks.get(1).getCapacity()) {
                return false;
            }
        }
        return true;
    }

    protected void produceProducts() {
        IFluidIngredient fluidProduct;
        int fluidIngredientStackSize = this.getTurbine().recipeInfo.getRecipe().getFluidIngredients().get(0).getMaxStackSize((Integer)this.getTurbine().recipeInfo.getFluidIngredientNumbers().get(0)) * this.getTurbine().recipeInputRate;
        if (fluidIngredientStackSize > 0) {
            this.getTurbine().tanks.get(0).changeFluidAmount(-fluidIngredientStackSize);
        }
        if (this.getTurbine().tanks.get(0).getFluidAmount() <= 0) {
            this.getTurbine().tanks.get(0).setFluidStored(null);
        }
        if ((fluidProduct = this.getTurbine().recipeInfo.getRecipe().getFluidProducts().get(0)).getMaxStackSize(0) <= 0) {
            return;
        }
        if (this.getTurbine().tanks.get(1).isEmpty()) {
            this.getTurbine().tanks.get(1).setFluidStored(fluidProduct.getNextStack(0));
            this.getTurbine().tanks.get(1).setFluidAmount(this.getTurbine().tanks.get(1).getFluidAmount() * this.getTurbine().recipeInputRate);
        } else if (this.getTurbine().tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
            this.getTurbine().tanks.get(1).changeFluidAmount(fluidProduct.getNextStackSize(0) * this.getTurbine().recipeInputRate);
        }
    }

    public int getMaxRecipeRateMultiplier() {
        return this.getTurbine().getBladeVolume() * NCConfig.turbine_mb_per_blade;
    }

    public double getRawLimitProcessPower(int recipeInputRate) {
        return this.getTurbine().noBladeSets == 0 ? 0.0 : (double)recipeInputRate * this.getTurbine().basePowerPerMB;
    }

    public double getNewRawProcessPower(double previousRawPower, double maxLimitPower, boolean increasing) {
        double effectiveInertia = this.getEffectiveInertia(increasing);
        if (increasing) {
            return (effectiveInertia * previousRawPower + maxLimitPower * this.getTurbine().spinUpMultiplier) / (effectiveInertia + this.getTurbine().spinUpMultiplier);
        }
        return effectiveInertia * previousRawPower / (effectiveInertia + Math.log1p(effectiveInertia) + 1.0);
    }

    public double getEffectiveInertia(boolean increasing) {
        int bearingCount = this.getPartCount(TileTurbineRotorBearing.class);
        double mult = (Math.min(1.0, (1.0 + 2.0 * (double)this.getTurbine().dynamoCoilCount) / (double)bearingCount) + Math.min(1.0, (1.0 + 2.0 * (double)this.getTurbine().dynamoCoilCountOpposite) / (double)bearingCount)) / 2.0;
        return (double)this.getTurbine().inertia * Math.sqrt(increasing ? mult : 1.0 / mult);
    }

    public void setRotorEfficiency() {
        this.getTurbine().rotorEfficiency = 0.0;
        for (int depth = 0; depth < this.getTurbine().getFlowLength(); ++depth) {
            if ((Double)this.getTurbine().rawBladeEfficiencies.get(depth) < 0.0) continue;
            this.getTurbine().rotorEfficiency += (Double)this.getTurbine().rawBladeEfficiencies.get(depth) * TurbineLogic.getExpansionIdealityMultiplier(this.getIdealExpansionLevel(depth), (Double)this.getTurbine().expansionLevels.get(depth));
        }
        this.getTurbine().rotorEfficiency /= (double)this.getTurbine().noBladeSets;
    }

    public static double getExpansionIdealityMultiplier(double ideal, double actual) {
        if (ideal <= 0.0 || actual <= 0.0) {
            return 0.0;
        }
        return ideal < actual ? ideal / actual : actual / ideal;
    }

    public double getIdealExpansionLevel(int depth) {
        return Math.pow(this.getTurbine().idealTotalExpansionLevel, ((double)depth + 0.5) / (double)this.getTurbine().getFlowLength());
    }

    public DoubleList getIdealExpansionLevels() {
        DoubleArrayList levels = new DoubleArrayList();
        if (this.getTurbine().flowDir == null) {
            return levels;
        }
        for (int depth = 0; depth < this.getTurbine().getFlowLength(); ++depth) {
            levels.add(this.getIdealExpansionLevel(depth));
        }
        return levels;
    }

    public double getThroughputEfficiency() {
        double effectiveMinLength = this.getTurbine().idealTotalExpansionLevel <= 1.0 || this.getTurbine().maxBladeExpansionCoefficient <= 1.0 ? (double)this.getMaximumInteriorLength() : Math.ceil(Math.log(this.getTurbine().idealTotalExpansionLevel) / Math.log(this.getTurbine().maxBladeExpansionCoefficient));
        double absoluteLeniency = effectiveMinLength * (double)this.getTurbine().getMinimumBladeArea() * (double)NCConfig.turbine_mb_per_blade;
        double throughputRatio = this.getMaxRecipeRateMultiplier() == 0 ? 1.0 : Math.min(1.0, (this.getTurbine().recipeInputRateFP + absoluteLeniency) / (double)this.getMaxRecipeRateMultiplier());
        return throughputRatio >= NCConfig.turbine_throughput_leniency_params[1] ? 1.0 : (1.0 - NCConfig.turbine_throughput_leniency_params[0]) * Math.sin(throughputRatio * Math.PI / (2.0 * NCConfig.turbine_throughput_leniency_params[1])) + NCConfig.turbine_throughput_leniency_params[0];
    }

    public void setEffectiveMaxLength() {
        this.getTurbine().effectiveMaxLength = this.getTurbine().minBladeExpansionCoefficient <= 1.0 || this.getTurbine().minStatorExpansionCoefficient >= 1.0 ? this.getMaximumInteriorLength() : NCMath.toInt(Math.ceil(MathHelper.func_151237_a((double)((Math.log(this.getTurbine().idealTotalExpansionLevel) - (double)this.getMaximumInteriorLength() * Math.log(this.getTurbine().minStatorExpansionCoefficient)) / (Math.log(this.getTurbine().minBladeExpansionCoefficient) - Math.log(this.getTurbine().minStatorExpansionCoefficient))), (double)1.0, (double)this.getMaximumInteriorLength())));
    }

    public void setInputRatePowerBonus() {
        double rate = Math.min(this.getTurbine().recipeInputRate, this.getMaxRecipeRateMultiplier());
        double lengthBonus = rate / (double)(NCConfig.turbine_mb_per_blade * this.getTurbine().getBladeArea() * this.getTurbine().effectiveMaxLength);
        double areaBonus = Math.sqrt(2.0 * rate / (double)(NCConfig.turbine_mb_per_blade * this.getTurbine().getFlowLength() * this.getMaximumInteriorLength() * this.getTurbine().effectiveMaxLength));
        this.getTurbine().powerBonus = 1.0 + NCConfig.turbine_power_bonus_multiplier * Math.pow(lengthBonus * areaBonus, 0.6666666666666666);
    }

    @Override
    public void onUpdateClient() {
        if (this.getTurbine().shouldSpecialRenderRotor && this.getTurbine().flowDir != null) {
            if (this.getTurbine().nbtUpdateRenderDataFlag) {
                this.getTurbine().nbtUpdateRenderDataFlag = false;
                this.updateRenderData();
            }
            this.updateParticles();
        }
        this.updateSounds();
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateParticles() {
        if (this.getTurbine().isProcessing && this.getTurbine().isAssembled() && !Minecraft.func_71410_x().func_147113_T()) {
            double speedY;
            double speedX;
            double flowSpeed = (double)this.getTurbine().getFlowLength() * this.getTurbine().particleSpeedMult;
            double offsetX = this.particleSpeedOffest();
            double offsetY = this.particleSpeedOffest();
            double offsetZ = this.particleSpeedOffest();
            double d = this.getTurbine().flowDir == EnumFacing.WEST ? -flowSpeed : (speedX = this.getTurbine().flowDir == EnumFacing.EAST ? flowSpeed : offsetX);
            double d2 = this.getTurbine().flowDir == EnumFacing.DOWN ? -flowSpeed : (speedY = this.getTurbine().flowDir == EnumFacing.UP ? flowSpeed : offsetY);
            double speedZ = this.getTurbine().flowDir == EnumFacing.NORTH ? -flowSpeed : (this.getTurbine().flowDir == EnumFacing.SOUTH ? flowSpeed : offsetZ);
            for (Iterable<BlockPos.MutableBlockPos> iter : this.getTurbine().inputPlane) {
                if (iter == null) continue;
                for (BlockPos blockPos : iter) {
                    double[] spawnPos;
                    if (!(this.rand.nextDouble() < NCConfig.turbine_particles * this.getTurbine().recipeInputRateFP / (double)this.getMaxRecipeRateMultiplier()) || (spawnPos = this.particleSpawnPos(blockPos)) == null) continue;
                    this.getWorld().func_175682_a(EnumParticleTypes.func_186831_a((String)this.getTurbine().particleEffect), false, spawnPos[0], spawnPos[1], spawnPos[2], speedX, speedY, speedZ, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected double particleSpeedOffest() {
        return (this.rand.nextDouble() - 0.5) / (4.0 * Math.sqrt(this.getTurbine().getFlowLength()));
    }

    @SideOnly(value=Side.CLIENT)
    protected double[] particleSpawnPos(BlockPos pos) {
        double offsetU = 0.5 + (this.rand.nextDouble() - 0.5) / 2.0;
        double offsetV = 0.5 + (this.rand.nextDouble() - 0.5) / 2.0;
        switch (this.getTurbine().flowDir) {
            case DOWN: {
                return new double[]{(double)pos.func_177958_n() + offsetV, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + offsetU};
            }
            case UP: {
                return new double[]{(double)pos.func_177958_n() + offsetV, pos.func_177956_o(), (double)pos.func_177952_p() + offsetU};
            }
            case NORTH: {
                return new double[]{(double)pos.func_177958_n() + offsetU, (double)pos.func_177956_o() + offsetV, (double)pos.func_177952_p() + 1.0};
            }
            case SOUTH: {
                return new double[]{(double)pos.func_177958_n() + offsetU, (double)pos.func_177956_o() + offsetV, pos.func_177952_p()};
            }
            case WEST: {
                return new double[]{(double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + offsetU, (double)pos.func_177952_p() + offsetV};
            }
            case EAST: {
                return new double[]{pos.func_177958_n(), (double)pos.func_177956_o() + offsetU, (double)pos.func_177952_p() + offsetV};
            }
        }
        return new double[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateSounds() {
        if (NCConfig.turbine_sound_volume == 0.0) {
            if (this.getTurbine().activeSounds != null) {
                this.clearSounds();
                this.getTurbine().activeSounds = null;
            }
            return;
        }
        if (this.getTurbine().activeSounds == null) {
            this.getTurbine().activeSounds = new ArrayList<SoundHandler.SoundInfo>();
        }
        if (this.getTurbine().isProcessing && this.getTurbine().isAssembled() && !Minecraft.func_71410_x().func_147113_T()) {
            this.getTurbine().refreshSoundInfo = this.getTurbine().refreshSoundInfo || Math.abs(this.getTurbine().angVel - this.getTurbine().prevAngVel) > 0.025f;
            if (--this.getTurbine().soundCount > (this.getTurbine().refreshSoundInfo ? 93 : 0)) {
                return;
            }
            if (this.getTurbine().refreshSoundInfo) {
                int[] _z;
                int[] _y;
                int[] _x;
                this.clearSounds();
                BlockPos minPos = this.getTurbine().getMinimumCoord();
                BlockPos midPos = this.getTurbine().getMiddleCoord();
                BlockPos maxPos = this.getTurbine().getMaximumCoord();
                int lengthX = this.getTurbine().getExteriorLengthX();
                int lengthY = this.getTurbine().getExteriorLengthY();
                int lengthZ = this.getTurbine().getExteriorLengthZ();
                if (lengthX > 8) {
                    int powX = (int)Math.pow(lengthX, 0.4);
                    _x = new int[]{minPos.func_177958_n() + powX, maxPos.func_177958_n() - powX};
                } else {
                    _x = new int[]{midPos.func_177958_n()};
                }
                if (lengthY > 8) {
                    int powY = (int)Math.pow(lengthY, 0.4);
                    _y = new int[]{minPos.func_177956_o() + powY, maxPos.func_177956_o() - powY};
                } else {
                    _y = new int[]{midPos.func_177956_o()};
                }
                if (lengthZ > 8) {
                    int powZ = (int)Math.pow(lengthZ, 0.4);
                    _z = new int[]{minPos.func_177952_p() + powZ, maxPos.func_177952_p() - powZ};
                } else {
                    _z = new int[]{midPos.func_177952_p()};
                }
                for (int i : _x) {
                    for (int j : _y) {
                        for (int k : _z) {
                            this.getTurbine().activeSounds.add(new SoundHandler.SoundInfo(null, new BlockPos(i, j, k)));
                        }
                    }
                }
                this.getTurbine().refreshSoundInfo = false;
            }
            for (SoundHandler.SoundInfo activeSound : this.getTurbine().activeSounds) {
                if (activeSound == null || activeSound.sound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c(activeSound.sound)) continue;
                activeSound.sound = SoundHandler.startTileSound(NCSounds.turbine_run, activeSound.pos, (float)((1.0 + (double)this.getTurbine().angVel * 2.0 / NCConfig.turbine_render_rotor_speed) * NCConfig.turbine_sound_volume / 24.0), SoundHelper.getPitch((double)(4.0f * this.getTurbine().angVel) / NCConfig.turbine_render_rotor_speed - 2.0));
            }
            this.getTurbine().soundCount = 186;
            this.getTurbine().prevAngVel = this.getTurbine().angVel;
        } else {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopSounds() {
        if (this.getTurbine().activeSounds != null) {
            for (SoundHandler.SoundInfo activeSound : this.getTurbine().activeSounds) {
                if (activeSound == null) continue;
                SoundHandler.stopTileSound(activeSound.pos);
                activeSound.sound = null;
            }
            this.getTurbine().soundCount = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void clearSounds() {
        this.stopSounds();
        if (this.getTurbine().activeSounds != null) {
            this.getTurbine().activeSounds.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateRenderData() {
        int flowLength = this.getTurbine().getFlowLength();
        if (flowLength < 1 || this.getTurbine().bladePosArray == null || this.getTurbine().renderPosArray == null || this.getTurbine().bladeAngleArray == null || this.getTurbine().bladePosArray.length < 4 * flowLength) {
            this.getTurbine().bladePosArray = null;
            this.getTurbine().renderPosArray = null;
            this.getTurbine().bladeAngleArray = null;
        } else {
            int i;
            this.getTurbine().rotorStateArray = new IBlockState[1 + 4 * flowLength];
            this.getTurbine().rotorStateArray[4 * flowLength] = NCBlocks.turbine_rotor_shaft.func_176223_P().func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)this.getTurbine().getShaftDir()));
            for (i = 0; i < this.getTurbine().bladePosArray.length; ++i) {
                BlockPos pos = this.getTurbine().bladePosArray[i];
                TurbineRotorBladeUtil.ITurbineRotorBlade<?> thisBlade = this.getTurbine().getBlade(pos);
                this.getTurbine().rotorStateArray[i] = thisBlade == null ? this.getWorld().func_180495_p(pos).func_177230_c().func_176223_P() : thisBlade.getRenderState();
            }
            this.getTurbine().bladeDepths.clear();
            this.getTurbine().statorDepths.clear();
            for (i = 0; i < flowLength; ++i) {
                if (this.getTurbine().getBlade(this.getTurbine().bladePosArray[i]).getBladeType() instanceof TurbineRotorBladeUtil.IRotorStatorType) {
                    this.getTurbine().statorDepths.add(i);
                    continue;
                }
                this.getTurbine().bladeDepths.add(i);
            }
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
    }

    @Override
    public TurbineUpdatePacket getMultiblockUpdatePacket() {
        return new TurbineUpdatePacket(this.getTurbine().controller.getTilePos(), this.getTurbine().isTurbineOn, this.getTurbine().energyStorage, this.getTurbine().power, this.getTurbine().rawPower, this.getTurbine().conductivity, this.getTurbine().rotorEfficiency, this.getTurbine().powerBonus, this.getTurbine().totalExpansionLevel, this.getTurbine().idealTotalExpansionLevel, this.getTurbine().shaftWidth, this.getTurbine().bladeLength, this.getTurbine().noBladeSets, this.getTurbine().dynamoCoilCount, this.getTurbine().dynamoCoilCountOpposite, this.getTurbine().bearingTension);
    }

    @Override
    public void onMultiblockUpdatePacket(TurbineUpdatePacket message) {
        this.getTurbine().isTurbineOn = message.isTurbineOn;
        this.getTurbine().energyStorage.setEnergyStored(message.energy);
        this.getTurbine().energyStorage.setStorageCapacity(message.capacity);
        this.getTurbine().energyStorage.setMaxTransfer(message.capacity);
        this.getTurbine().power = message.power;
        this.getTurbine().rawPower = message.rawPower;
        this.getTurbine().conductivity = message.conductivity;
        this.getTurbine().rotorEfficiency = message.rotorEfficiency;
        this.getTurbine().powerBonus = message.powerBonus;
        this.getTurbine().totalExpansionLevel = message.totalExpansionLevel;
        this.getTurbine().idealTotalExpansionLevel = message.idealTotalExpansionLevel;
        this.getTurbine().shaftWidth = message.shaftWidth;
        this.getTurbine().bladeLength = message.bladeLength;
        this.getTurbine().noBladeSets = message.noBladeSets;
        this.getTurbine().dynamoCoilCount = message.dynamoCoilCount;
        this.getTurbine().dynamoCoilCountOpposite = message.dynamoCoilCountOpposite;
        this.getTurbine().bearingTension = message.bearingTension;
    }

    public TurbineRenderPacket getRenderPacket() {
        return new TurbineRenderPacket(this.getTurbine().controller.getTilePos(), this.getTurbine().particleEffect, this.getTurbine().particleSpeedMult, this.getTurbine().angVel, this.getTurbine().isProcessing, this.getTurbine().recipeInputRate, this.getTurbine().recipeInputRateFP);
    }

    public void onRenderPacket(TurbineRenderPacket message) {
        this.getTurbine().particleEffect = message.particleEffect;
        this.getTurbine().particleSpeedMult = message.particleSpeedMult;
        this.getTurbine().angVel = message.angVel;
        boolean wasProcessing = this.getTurbine().isProcessing;
        this.getTurbine().isProcessing = message.isProcessing;
        if (wasProcessing != this.getTurbine().isProcessing) {
            this.getTurbine().refreshSoundInfo = true;
        }
        this.getTurbine().recipeInputRate = message.recipeInputRate;
        this.getTurbine().recipeInputRateFP = message.recipeInputRateFP;
    }

    @Override
    public boolean isBlockGoodForInterior(World world, BlockPos pos) {
        long posLong = pos.func_177986_g();
        if (this.getPartMap(TileTurbineRotorShaft.class).containsKey(posLong) || this.getPartMap(TileTurbineRotorBlade.class).containsKey(posLong) || this.getPartMap(TileTurbineRotorStator.class).containsKey(posLong) || MaterialHelper.isReplaceable(world.func_180495_p(pos).func_185904_a())) {
            return true;
        }
        return this.getTurbine().standardLastError(pos);
    }

    @Override
    public void clearAllMaterial() {
        for (Tank tank : this.getTurbine().tanks) {
            tank.setFluidStored(null);
        }
    }
}

