/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine;

import java.util.Iterator;
import nc.config.NCConfig;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;

public class TurbineRotorBladeUtil {
    public static final PropertyEnum<TurbinePartDir> DIR = PropertyEnum.func_177709_a((String)"dir", TurbinePartDir.class);

    public static enum TurbinePartDir implements IStringSerializable
    {
        INVISIBLE("invisible"),
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private TurbinePartDir(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static TurbinePartDir fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return INVISIBLE;
        }
    }

    public static interface IBlockRotorBlade {
    }

    public static interface ITurbineRotorBlade<BLADE extends ITurbineRotorBlade<?>> {
        public BlockPos bladePos();

        public TurbinePartDir getDir();

        public void setDir(TurbinePartDir var1);

        public IRotorBladeType getBladeType();

        public IBlockState getRenderState();

        public void onBearingFailure(Iterator<BLADE> var1);
    }

    public static interface IRotorStatorType
    extends IRotorBladeType {
        @Override
        default public double getEfficiency() {
            return -1.0;
        }
    }

    public static enum TurbineRotorStatorType implements IRotorStatorType
    {
        STATOR("stator", NCConfig.turbine_stator_expansion);

        private final String name;
        private final double expansion;

        private TurbineRotorStatorType(String name, double expansion) {
            this.name = name;
            this.expansion = expansion;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        @Override
        public double getExpansionCoefficient() {
            return this.expansion;
        }
    }

    public static interface IRotorBladeType
    extends IStringSerializable {
        public double getEfficiency();

        public double getExpansionCoefficient();

        default public boolean eq(IRotorBladeType other) {
            return other != null && this.func_176610_l().equals(other.func_176610_l()) && this.getEfficiency() == other.getEfficiency() && this.getExpansionCoefficient() == other.getExpansionCoefficient();
        }
    }

    public static enum TurbineRotorBladeType implements IRotorBladeType
    {
        STEEL("steel", NCConfig.turbine_blade_efficiency[0], NCConfig.turbine_blade_expansion[0]),
        EXTREME("extreme", NCConfig.turbine_blade_efficiency[1], NCConfig.turbine_blade_expansion[1]),
        SIC_SIC_CMC("sic_sic_cmc", NCConfig.turbine_blade_efficiency[2], NCConfig.turbine_blade_expansion[2]);

        private final String name;
        private final double efficiency;
        private final double expansion;

        private TurbineRotorBladeType(String name, double efficiency, double expansion) {
            this.name = name;
            this.efficiency = efficiency;
            this.expansion = expansion;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        @Override
        public double getEfficiency() {
            return this.efficiency;
        }

        @Override
        public double getExpansionCoefficient() {
            return this.expansion;
        }
    }
}

