/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import java.util.Iterator;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.block.BlockTurbineRotorStator;
import nc.multiblock.turbine.tile.TileTurbinePart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TileTurbineRotorStator
extends TileTurbinePart
implements TurbineRotorBladeUtil.ITurbineRotorBlade<TileTurbineRotorStator> {
    public TurbineRotorBladeUtil.IRotorStatorType statorType = null;
    protected TurbineRotorBladeUtil.TurbinePartDir dir = TurbineRotorBladeUtil.TurbinePartDir.Y;

    public TileTurbineRotorStator() {
        super(CuboidalPartPositionType.INTERIOR);
    }

    public TileTurbineRotorStator(TurbineRotorBladeUtil.IRotorStatorType statorType) {
        this();
        this.statorType = statorType;
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    public BlockPos bladePos() {
        return this.field_174879_c;
    }

    @Override
    public TurbineRotorBladeUtil.TurbinePartDir getDir() {
        return this.dir;
    }

    @Override
    public void setDir(TurbineRotorBladeUtil.TurbinePartDir newDir) {
        this.dir = newDir;
    }

    @Override
    public TurbineRotorBladeUtil.IRotorBladeType getBladeType() {
        return this.statorType;
    }

    @Override
    public IBlockState getRenderState() {
        if (this.func_145838_q() instanceof BlockTurbineRotorStator) {
            return this.func_145838_q().func_176223_P().func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)this.dir));
        }
        return this.func_145838_q().func_176223_P();
    }

    @Override
    public void onBearingFailure(Iterator<TileTurbineRotorStator> statorIterator) {
        Turbine turbine = (Turbine)this.getMultiblock();
        if (turbine != null && turbine.rand.nextDouble() < 0.04) {
            statorIterator.remove();
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        if (this.statorType != null) {
            nbt.func_74778_a("statorName", this.statorType.func_176610_l());
            nbt.func_74780_a("statorExpansionCoefficient", this.statorType.getExpansionCoefficient());
        }
        nbt.func_74768_a("bladeDir", this.dir.ordinal());
        return nbt;
    }

    @Override
    public void readAll(final NBTTagCompound nbt) {
        super.readAll(nbt);
        if (this.statorType == null && nbt.func_74764_b("statorName") && nbt.func_74764_b("statorExpansionCoefficient")) {
            this.statorType = new TurbineRotorBladeUtil.IRotorStatorType(){
                final String name;
                final double expansionCoefficient;
                {
                    this.name = nbt.func_74779_i("statorName");
                    this.expansionCoefficient = nbt.func_74769_h("statorExpansionCoefficient");
                }

                public String func_176610_l() {
                    return this.name;
                }

                @Override
                public double getExpansionCoefficient() {
                    return this.expansionCoefficient;
                }
            };
        }
        this.dir = TurbineRotorBladeUtil.TurbinePartDir.values()[nbt.func_74762_e("bladeDir")];
    }

    public static class Standard
    extends TileTurbineRotorStator {
        public Standard() {
            super(TurbineRotorBladeUtil.TurbineRotorStatorType.STATOR);
        }
    }
}

