/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.TankOutputSetting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ToggleTankOutputSettingPacket
implements IMessage {
    protected BlockPos pos;
    protected int tank;
    protected int setting;

    public ToggleTankOutputSettingPacket() {
    }

    public ToggleTankOutputSettingPacket(ITileFluid machine, int tank, TankOutputSetting setting) {
        this.pos = machine.getTilePos();
        this.tank = tank;
        this.setting = setting.ordinal();
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.tank = buf.readInt();
        this.setting = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tank);
        buf.writeInt(this.setting);
    }

    public static class Handler
    implements IMessageHandler<ToggleTankOutputSettingPacket, IMessage> {
        public IMessage onMessage(ToggleTankOutputSettingPacket message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            }
            return null;
        }

        void processMessage(ToggleTankOutputSettingPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            if (!world.func_175667_e(message.pos) || !world.func_175660_a((EntityPlayer)player, message.pos)) {
                return;
            }
            TileEntity tile = world.func_175625_s(message.pos);
            if (tile instanceof ITileFluid) {
                ITileFluid machine = (ITileFluid)tile;
                TankOutputSetting setting = TankOutputSetting.values()[message.setting];
                machine.setTankOutputSetting(message.tank, setting);
                if (setting == TankOutputSetting.VOID) {
                    machine.clearTank(message.tank);
                }
                machine.markDirtyAndNotify(true);
            }
        }
    }
}

