/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.List;
import nc.multiblock.fission.FissionCluster;
import nc.network.tile.TileUpdatePacket;
import nc.tile.ITileGui;
import nc.tile.internal.fluid.Tank;
import net.minecraft.util.math.BlockPos;

public class SaltFissionVesselUpdatePacket
extends TileUpdatePacket {
    public BlockPos masterPortPos;
    public List<Tank.TankInfo> tanksInfo;
    public List<Tank.TankInfo> filterTanksInfo;
    public long clusterHeatStored;
    public long clusterHeatCapacity;
    public boolean isProcessing;
    public double time;
    public double baseProcessTime;

    public SaltFissionVesselUpdatePacket() {
    }

    public SaltFissionVesselUpdatePacket(BlockPos pos, BlockPos masterPortPos, List<Tank> tanks, List<Tank> filterTanks, FissionCluster cluster, boolean isProcessing, double time, double baseProcessTime) {
        this.pos = pos;
        this.masterPortPos = masterPortPos;
        this.tanksInfo = Tank.TankInfo.infoList(tanks);
        this.filterTanksInfo = Tank.TankInfo.infoList(filterTanks);
        this.clusterHeatStored = cluster == null ? -1L : cluster.heatBuffer.getHeatStored();
        this.clusterHeatCapacity = cluster == null ? -1L : cluster.heatBuffer.getHeatCapacity();
        this.isProcessing = isProcessing;
        this.time = time;
        this.baseProcessTime = baseProcessTime;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.masterPortPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        byte numberOfTanks = buf.readByte();
        this.tanksInfo = Tank.TankInfo.readBuf(buf, numberOfTanks);
        byte numberOfFilterTanks = buf.readByte();
        this.filterTanksInfo = Tank.TankInfo.readBuf(buf, numberOfFilterTanks);
        this.clusterHeatStored = buf.readLong();
        this.clusterHeatCapacity = buf.readLong();
        this.isProcessing = buf.readBoolean();
        this.time = buf.readDouble();
        this.baseProcessTime = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.masterPortPos.func_177958_n());
        buf.writeInt(this.masterPortPos.func_177956_o());
        buf.writeInt(this.masterPortPos.func_177952_p());
        buf.writeByte(this.tanksInfo.size());
        for (Tank.TankInfo info : this.tanksInfo) {
            info.writeBuf(buf);
        }
        buf.writeByte(this.filterTanksInfo.size());
        for (Tank.TankInfo info : this.filterTanksInfo) {
            info.writeBuf(buf);
        }
        buf.writeLong(this.clusterHeatStored);
        buf.writeLong(this.clusterHeatCapacity);
        buf.writeBoolean(this.isProcessing);
        buf.writeDouble(this.time);
        buf.writeDouble(this.baseProcessTime);
    }

    public static class Handler
    extends TileUpdatePacket.Handler<SaltFissionVesselUpdatePacket, ITileGui<SaltFissionVesselUpdatePacket>> {
        @Override
        protected void onTileUpdatePacket(SaltFissionVesselUpdatePacket message, ITileGui<SaltFissionVesselUpdatePacket> processor) {
            processor.onTileUpdatePacket(message);
        }
    }
}

