/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nc.config.NCConfig;
import nc.recipe.BasicRecipeHandler;
import nc.util.OreDictHelper;

public class DecayGeneratorRecipes
extends BasicRecipeHandler {
    private static final Set<String> NON_FISSION = Sets.newHashSet((Object[])new String[]{"Lead", "Bismuth", "Thorium"});

    public DecayGeneratorRecipes() {
        super("decay_generator", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addDecayRecipes("Thorium", "Lead", NCConfig.decay_lifetime[0], NCConfig.decay_power[0], 7.15E-11);
        this.addDecayRecipes("Uranium", "Uranium238", NCConfig.decay_lifetime[1], NCConfig.decay_power[1], 3.85E-10);
        this.addDecayRecipes("Uranium238", OreDictHelper.oreExists("Radium") ? "Radium" : "Lead", NCConfig.decay_lifetime[2], NCConfig.decay_power[2], 2.25E-10);
        this.addDecayRecipes("Neptunium237", OreDictHelper.oreExists("Bismuth") ? "Bismuth" : "Lead", NCConfig.decay_lifetime[3], NCConfig.decay_power[3], 4.7E-7);
        this.addDecayRecipes("Plutonium242", "Uranium238", NCConfig.decay_lifetime[4], NCConfig.decay_power[4], 2.7E-6);
        this.addDecayRecipes("Americium243", "Lead", NCConfig.decay_lifetime[5], NCConfig.decay_power[5], 1.4E-4);
        this.addDecayRecipes("Curium246", "Plutonium242", NCConfig.decay_lifetime[6], NCConfig.decay_power[6], 2.15E-4);
        this.addDecayRecipes("Berkelium247", "Americium243", NCConfig.decay_lifetime[7], NCConfig.decay_power[7], 7.25E-4);
        this.addDecayRecipes("Californium252", "Lead", NCConfig.decay_lifetime[8], NCConfig.decay_power[8], 0.38);
    }

    public void addDecayRecipes(String input, String output, double lifetime, double power, double radiation) {
        String inputName = "block" + input;
        if (NON_FISSION.contains(output)) {
            this.addRecipe(Lists.newArrayList((Object[])new String[]{inputName, inputName + "Oxide", inputName + "Nitride"}), "block" + output, lifetime, power, radiation);
        } else {
            for (String type : new String[]{"", "Carbide", "Oxide", "Nitride", "ZA"}) {
                this.addRecipe(inputName + type, "block" + output + type, lifetime, power, radiation);
            }
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1200.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 0.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

