/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import crafttweaker.api.item.IIngredient;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.ingredient.CTChanceFluidIngredient;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IChanceFluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.util.NCMath;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class ChanceFluidIngredient
implements IChanceFluidIngredient {
    public IFluidIngredient ingredient;
    public int chancePercent;
    public int stackDiff;
    public int minStackSize;
    public int sizeIncrSteps;
    public double meanStackSize;

    public ChanceFluidIngredient(IFluidIngredient ingredient, int chancePercent, int stackDiff) {
        this(ingredient, chancePercent, stackDiff, 0);
    }

    public ChanceFluidIngredient(IFluidIngredient ingredient, int chancePercent, int stackDiff, int minStackSize) {
        this.ingredient = ingredient;
        this.chancePercent = MathHelper.func_76125_a((int)chancePercent, (int)0, (int)100);
        this.stackDiff = Math.max(1, stackDiff);
        this.minStackSize = MathHelper.func_76125_a((int)minStackSize, (int)0, (int)ingredient.getMaxStackSize(0));
        int sizeIncrSteps = (ingredient.getMaxStackSize(0) - this.minStackSize) / this.stackDiff;
        int sizeShift = ingredient.getMaxStackSize(0) - this.minStackSize - sizeIncrSteps * this.stackDiff;
        this.minStackSize += sizeShift;
        this.sizeIncrSteps = sizeIncrSteps;
        this.meanStackSize = (double)this.minStackSize + (double)(this.ingredient.getMaxStackSize(0) - this.minStackSize) * (double)this.chancePercent / 100.0;
    }

    @Override
    public FluidStack getStack() {
        return (FluidStack)this.ingredient.getStack();
    }

    @Override
    public List<FluidStack> getInputStackList() {
        ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
        for (FluidStack stack : this.ingredient.getInputStackList()) {
            for (int runningStackSize = this.minStackSize; runningStackSize <= this.getMaxStackSize(0); runningStackSize += this.stackDiff) {
                FluidStack newStack = stack.copy();
                newStack.amount = runningStackSize;
                stackList.add(newStack);
            }
        }
        return stackList;
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
        for (int runningStackSize = this.minStackSize; runningStackSize <= this.getMaxStackSize(0); runningStackSize += this.stackDiff) {
            FluidStack newStack = this.getStack().copy();
            newStack.amount = runningStackSize;
            stackList.add(newStack);
        }
        return stackList;
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredient.getMaxStackSize(0);
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.ingredient.setMaxStackSize(stackSize);
    }

    @Override
    public int getNextStackSize(int ingredientNumber) {
        return this.minStackSize + this.stackDiff * NCMath.getBinomial(this.sizeIncrSteps, this.chancePercent);
    }

    @Override
    public String getIngredientName() {
        return this.ingredient.getIngredientName() + " [ " + this.chancePercent + "%, diff: " + this.stackDiff + ", min: " + this.minStackSize + " ]";
    }

    @Override
    public String getIngredientNamesConcat() {
        return this.ingredient.getIngredientNamesConcat() + " [ " + this.chancePercent + "%, diff: " + this.stackDiff + ", min: " + this.minStackSize + " ]";
    }

    @Override
    public IntList getFactors() {
        IntList list = this.ingredient.getFactors();
        list.add(this.stackDiff);
        list.add(this.minStackSize);
        return new IntArrayList(list);
    }

    @Override
    public IFluidIngredient getFactoredIngredient(int factor) {
        return new ChanceFluidIngredient(this.ingredient.getFactoredIngredient(factor), this.chancePercent, this.stackDiff / factor, this.minStackSize / factor);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        return this.ingredient.match(object, sorption);
    }

    @Override
    public boolean isValid() {
        return this.ingredient.isValid();
    }

    @Override
    public IFluidIngredient getRawIngredient() {
        return this.ingredient;
    }

    @Override
    public int getChancePercent() {
        return this.chancePercent;
    }

    @Override
    public int getStackDiff() {
        return this.stackDiff;
    }

    @Override
    public int getMinStackSize() {
        return this.minStackSize;
    }

    @Override
    public int getSizeIncrSteps() {
        return this.sizeIncrSteps;
    }

    @Override
    public double getMeanStackSize() {
        return this.meanStackSize;
    }

    @Override
    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        return CTChanceFluidIngredient.create(this.ingredient.ct(), this.chancePercent, this.stackDiff, this.minStackSize);
    }
}

