/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import nc.util.StringHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.FluidRegistry;

public class MelterRecipes
extends BasicRecipeHandler {
    private static final Set<String> ORE_PREFIX_LIST = Sets.newHashSet((Object[])new String[]{"ore", "oreGravel", "oreNetherrack", "oreEndstone", "oreSand", "oreBlackgranite", "oreRedgranite", "oreMarble", "oreBasalt"});
    private static final Set<String> MELTING_BLACKLIST = Sets.newHashSet((Object[])new String[]{"coal", "redstone", "glowstone", "prismarine", "obsidian", "silicon", "marshmallow"});

    public MelterRecipes() {
        super("melter", 1, 0, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe("dustSulfur", MelterRecipes.fluidStack("sulfur", 666), 1.0, 1.0);
        this.addRecipe("dustSodiumHydroxide", MelterRecipes.fluidStack("naoh", 666), 1.0, 1.0);
        this.addRecipe("dustPotassiumHydroxide", MelterRecipes.fluidStack("koh", 666), 1.0, 1.0);
        this.addRecipe("dustArsenic", MelterRecipes.fluidStack("arsenic", 666), 1.0, 1.0);
        this.addRecipe("gemBoronArsenide", MelterRecipes.fluidStack("bas", 666), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gemPrismarine", "dustPrismarine"}), MelterRecipes.fluidStack("prismarine", 144), 1.0, 1.0);
        this.addRecipe(Items.field_151123_aH, MelterRecipes.fluidStack("slime", 144), 1.0, 0.5);
        this.addRecipe(Lists.newArrayList((Object[])new Object[]{Blocks.field_180399_cE, RegistryHelper.blockStackFromRegistry("tconstruct:slime:0")}), MelterRecipes.fluidStack("slime", 1296), 9.0, 0.5);
        this.addRecipe(RegistryHelper.blockStackFromRegistry("tconstruct:slime_congealed:0"), MelterRecipes.fluidStack("slime", 576), 4.0, 0.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotSilicon", "itemSilicon"}), MelterRecipes.fluidStack("silicon", 144), 1.0, 1.0);
        this.addIngotMeltingRecipes("Boron10", "boron_10");
        this.addIngotMeltingRecipes("Boron11", "boron_11");
        this.addIngotMeltingRecipes("Lithium6", "lithium_6");
        this.addIngotMeltingRecipes("Lithium7", "lithium_7");
        this.addIngotMeltingRecipes("HardCarbon", "hard_carbon");
        this.addIngotMeltingRecipes("ManganeseDioxide", "manganese_dioxide");
        this.addIngotMeltingRecipes("alugentum");
        this.addIngotMeltingRecipes("LeadPlatinum", "lead_platinum");
        this.addRecipe("blockQuartz", MelterRecipes.fluidStack("quartz", 2664), 4.0, 1.0);
        this.addRecipe("blockLapis", MelterRecipes.fluidStack("lapis", 5994), 9.0, 1.0);
        this.addRecipe("blockDiamond", MelterRecipes.fluidStack("diamond", 5994), 9.0, 1.0);
        this.addRecipe("blockEmerald", MelterRecipes.fluidStack("emerald", 5994), 9.0, 1.0);
        this.addRecipe("obsidian", MelterRecipes.fluidStack("obsidian", 288), 2.0, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotObsidian", "dustObsidian"}), MelterRecipes.fluidStack("obsidian", 72), 0.5, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nuggetObsidian", "tinyDustObsidian"}), MelterRecipes.fluidStack("obsidian", 8), 0.05555555555555555, 2.0);
        this.addRecipe("netherrack", MelterRecipes.fluidStack("nether_brick", 72), 0.5, 1.5);
        this.addRecipe(Blocks.field_150385_bj, MelterRecipes.fluidStack("nether_brick", 288), 2.0, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotBrickNether", "dustBrickNether"}), MelterRecipes.fluidStack("nether_brick", 72), 0.5, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new Object[]{"endstone", Blocks.field_185772_cY}), MelterRecipes.fluidStack("end_stone", 288), 2.0, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotEndstone", "dustEndstone"}), MelterRecipes.fluidStack("end_stone", 72), 0.5, 2.0);
        this.addRecipe(Blocks.field_185767_cT, MelterRecipes.fluidStack("purpur", 288), 2.0, 1.5);
        this.addRecipe(Items.field_185162_cT, MelterRecipes.fluidStack("purpur", 72), 0.5, 1.5);
        this.addRecipe("sand", MelterRecipes.fluidStack("glass", 1000), 1.5, 1.5);
        this.addRecipe("blockGlass", MelterRecipes.fluidStack("glass", 1000), 1.5, 1.5);
        this.addRecipe(Blocks.field_150435_aG, MelterRecipes.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe(Items.field_151119_aD, MelterRecipes.fluidStack("clay", 144), 0.5, 1.5);
        this.addRecipe(Blocks.field_150336_V, MelterRecipes.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe("ingotBrick", MelterRecipes.fluidStack("clay", 144), 0.5, 1.5);
        this.addRecipe(Blocks.field_150405_ch, MelterRecipes.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe("stone", MelterRecipes.fluidStack("stone", 72), 1.5, 1.5);
        this.addRecipe("cobblestone", MelterRecipes.fluidStack("stone", 72), 1.5, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dirt", "grass"}), MelterRecipes.fluidStack("dirt", 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dustRedstone", "ingotRedstone"}), MelterRecipes.fluidStack("redstone", 100), 0.25, 1.0);
        this.addRecipe("blockRedstone", MelterRecipes.fluidStack("redstone", 900), 2.0, 1.0);
        this.addRecipe("dustGlowstone", MelterRecipes.fluidStack("glowstone", 250), 0.25, 1.0);
        this.addRecipe("glowstone", MelterRecipes.fluidStack("glowstone", 1000), 2.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new Object[]{Items.field_151079_bi, "dustEnder"}), MelterRecipes.fluidStack("ender", 250), 0.5, 1.5);
        this.addRecipe("dustPyrotheum", MelterRecipes.fluidStack("pyrotheum", 250), 1.0, 1.0);
        this.addRecipe("dustCryotheum", MelterRecipes.fluidStack("cryotheum", 250), 1.0, 1.0);
        this.addRecipe("dustAerotheum", MelterRecipes.fluidStack("aerotheum", 250), 1.0, 1.0);
        this.addRecipe("dustPetrotheum", MelterRecipes.fluidStack("petrotheum", 250), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"coal", "dustCoal"}), MelterRecipes.fluidStack("coal", 100), 0.5, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotGraphite", "dustGraphite"}), MelterRecipes.fluidStack("coal", 100), 0.5, 1.0);
        this.addRecipe("blockCoal", MelterRecipes.fluidStack("coal", 900), 4.5, 1.0);
        this.addRecipe("blockGraphite", MelterRecipes.fluidStack("coal", 900), 4.5, 1.0);
        this.addIngotMeltingRecipes("ElectricalSteel", "electrical_steel");
        this.addIngotMeltingRecipes("EnergeticAlloy", "energetic_alloy");
        this.addIngotMeltingRecipes("VibrantAlloy", "vibrant_alloy");
        this.addIngotMeltingRecipes("RedstoneAlloy", "redstone_alloy");
        this.addIngotMeltingRecipes("ConductiveIron", "conductive_iron");
        this.addIngotMeltingRecipes("PulsatingIron", "pulsating_iron");
        this.addIngotMeltingRecipes("DarkSteel", "dark_steel");
        this.addIngotMeltingRecipes("Soularium", "soularium");
        this.addIngotMeltingRecipes("EndSteel", "end_steel");
        this.addIngotMeltingRecipes("ConstructionAlloy", "construction_alloy");
        this.addIngotMeltingRecipes("CrudeSteel", "crude_steel");
        this.addIngotMeltingRecipes("CrystallineAlloy", "crystalline_alloy");
        this.addIngotMeltingRecipes("MelodicAlloy", "melodic_alloy");
        this.addIngotMeltingRecipes("StellarAlloy", "stellar_alloy");
        this.addIngotMeltingRecipes("CrystallinePinkSlime", "crystalline_pink_slime");
        this.addIngotMeltingRecipes("EnergeticSilver", "energetic_silver");
        this.addIngotMeltingRecipes("VividAlloy", "vivid_alloy");
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"itemSalt", "dustSalt"}), MelterRecipes.fluidStack("brine", 15), 0.25, 0.5);
        this.addIngotMeltingRecipes("dilithium");
        this.addIngotMeltingRecipes("manasteel");
        this.addIngotMeltingRecipes("terrasteel");
        this.addIngotMeltingRecipes("elementium");
        this.addIngotMeltingRecipes("RefinedObsidian", "refinedobsidian");
        this.addIngotMeltingRecipes("RefinedGlowstone", "refinedglowstone");
        this.addIngotMeltingRecipes("psi");
        this.addIngotMeltingRecipes("astralStarmetal");
        this.addIngotMeltingRecipes("baseEssence");
        this.addIngotMeltingRecipes("inferium");
        this.addIngotMeltingRecipes("prudentium");
        this.addIngotMeltingRecipes("intermedium");
        this.addIngotMeltingRecipes("superium");
        this.addIngotMeltingRecipes("supremium");
        this.addRecipe(Blocks.field_150432_aD, MelterRecipes.fluidStack("water", 1000), 0.25, 0.5);
        this.addRecipe(Blocks.field_150403_cj, MelterRecipes.fluidStack("water", 1000), 0.5, 0.5);
        this.addRecipe(NCItems.ground_cocoa_nibs, MelterRecipes.fluidStack("chocolate_liquor", 144), 0.25, 0.5);
        this.addRecipe("ingotCocoaButter", MelterRecipes.fluidStack("cocoa_butter", 144), 0.25, 0.5);
        this.addRecipe("ingotUnsweetenedChocolate", MelterRecipes.fluidStack("unsweetened_chocolate", 144), 0.25, 0.5);
        this.addRecipe("ingotDarkChocolate", MelterRecipes.fluidStack("dark_chocolate", 144), 0.25, 0.5);
        this.addRecipe("ingotChocolate", MelterRecipes.fluidStack("milk_chocolate", 144), 0.25, 0.5);
        this.addRecipe(Items.field_151102_aT, MelterRecipes.fluidStack("sugar", 144), 0.5, 0.5);
        this.addRecipe(NCItems.gelatin, MelterRecipes.fluidStack("gelatin", 144), 0.5, 0.5);
        this.addRecipe("ingotMarshmallow", MelterRecipes.fluidStack("marshmallow", 144), 0.5, 0.5);
        this.addOreMeltingRecipes();
        this.addFissionMeltingRecipes();
        this.addIngotMeltingRecipes("Strontium90", "strontium_90");
        this.addIngotMeltingRecipes("Molybdenum", "molybdenum");
        this.addIngotMeltingRecipes("Ruthenium106", "ruthenium_106");
        this.addIngotMeltingRecipes("Caesium137", "caesium_137");
        this.addIngotMeltingRecipes("Promethium147", "promethium_147");
        this.addIngotMeltingRecipes("Europium155", "europium_155");
    }

    public void addIngotMeltingRecipes(String oreName, String fluidName) {
        if (NCConfig.ore_processing) {
            for (String prefix : ORE_PREFIX_LIST) {
                this.addRecipe(prefix + oreName, MelterRecipes.fluidStack(fluidName, 288), 1.25, 1.5);
            }
        }
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingot" + oreName, "dust" + oreName}), MelterRecipes.fluidStack(fluidName, 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nugget" + oreName, "tinyDust" + oreName}), MelterRecipes.fluidStack(fluidName, 16), 0.1111111111111111, 1.0);
        this.addRecipe("block" + oreName, MelterRecipes.fluidStack(fluidName, 1296), 9.0, 1.0);
    }

    public void addIngotMeltingRecipes(String fluidName) {
        this.addIngotMeltingRecipes(StringHelper.capitalize(fluidName), fluidName);
    }

    public void addGemMeltingRecipes(String oreName, String fluidName) {
        if (NCConfig.ore_processing) {
            for (String prefix : ORE_PREFIX_LIST) {
                this.addRecipe(prefix + oreName, MelterRecipes.fluidStack(fluidName, 1332), 1.25, 1.5);
            }
        }
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gem" + oreName, "dust" + oreName}), MelterRecipes.fluidStack(fluidName, 666), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nugget" + oreName, "tinyDust" + oreName}), MelterRecipes.fluidStack(fluidName, 74), 0.1111111111111111, 1.0);
    }

    public void addGemMeltingRecipes(String fluidName) {
        this.addGemMeltingRecipes(StringHelper.capitalize(fluidName), fluidName);
    }

    public void addFissionMeltingRecipes() {
        for (int i = 0; i < FissionHelper.FISSION_ORE_DICT.length; ++i) {
            this.addRecipe("ingot" + FissionHelper.FISSION_ORE_DICT[i], MelterRecipes.fluidStack(FissionHelper.FISSION_FLUID[i], 144), 1.0, 1.0);
        }
    }

    public void addOreMeltingRecipes() {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        for (String fluidName : fluidList) {
            if (MELTING_BLACKLIST.contains(fluidName)) continue;
            String oreSuffix = StringHelper.capitalize(fluidName);
            String ingot = "ingot" + oreSuffix;
            String gem = "gem" + oreSuffix;
            String dust = "dust" + oreSuffix;
            if (OreDictHelper.oreExists(ingot) && OreDictHelper.oreExists(dust)) {
                this.addIngotMeltingRecipes(fluidName);
                continue;
            }
            if (!OreDictHelper.oreExists(gem) || !OreDictHelper.oreExists(dust)) continue;
            this.addGemMeltingRecipes(fluidName);
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

