/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nc.init.NCItems;
import nc.recipe.BasicRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.oredict.OreDictionary;

public class PressurizerRecipes
extends BasicRecipeHandler {
    private static final Set<String> PLATE_BLACKLIST = Sets.newHashSet((Object[])new String[]{"Graphite"});

    public PressurizerRecipes() {
        super("pressurizer", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addRecipe("dustGraphite", "coal", 1.0, 1.0);
        this.addRecipe("ingotGraphite", "ingotPyrolyticCarbon", 1.0, 1.0);
        this.addRecipe("dustDiamond", "gemDiamond", 1.0, 1.0);
        this.addRecipe("dustRhodochrosite", "gemRhodochrosite", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dustQuartz", "dustNetherQuartz"}), "gemQuartz", 1.0, 1.0);
        this.addRecipe(PressurizerRecipes.oreStack("dustObsidian", 4), Blocks.field_150343_Z, 1.5, 1.5);
        this.addRecipe("dustBoronNitride", "gemBoronNitride", 1.0, 1.0);
        this.addRecipe("dustFluorite", "gemFluorite", 1.0, 1.0);
        this.addRecipe("dustVilliaumite", "gemVilliaumite", 1.0, 1.0);
        this.addRecipe("dustCarobbiite", "gemCarobbiite", 1.0, 1.0);
        this.addRecipe(PressurizerRecipes.oreStackList(Lists.newArrayList((Object[])new String[]{"dustWheat", "foodFlour"}), 2), NCItems.graham_cracker, 0.25, 0.5);
        this.addRecipe(PressurizerRecipes.oreStack("dustClay", 4), "dustSiliconDioxide", 1.0, 1.0);
        this.addRecipe(RegistryHelper.itemStackFromRegistry("techreborn:part:34"), RegistryHelper.itemStackFromRegistry("techreborn:plates:2"), 1.0, 1.0);
        this.addRecipe("dustEnder", Items.field_151079_bi, 1.0, 1.0);
        this.addPlatePressingRecipes();
    }

    public void addPlatePressingRecipes() {
        for (String ore : OreDictionary.getOreNames()) {
            String plate;
            if (ore.startsWith("plate")) {
                String type = ore.substring(5);
                if (PLATE_BLACKLIST.contains(type)) continue;
                String ingot = "ingot" + type;
                String gem = "gem" + type;
                if (OreDictHelper.oreExists(ingot)) {
                    this.addRecipe(ingot, ore, 1.0, 1.0);
                } else if (OreDictHelper.oreExists(gem)) {
                    this.addRecipe(gem, ore, 1.0, 1.0);
                }
            }
            if (!ore.startsWith("plateDense") || !OreDictHelper.oreExists(plate = "plate" + ore.substring(10))) continue;
            this.addRecipe(PressurizerRecipes.oreStack(plate, 9), ore, 2.0, 2.0);
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

