/*
 * Decompiled with CFR 0.152.
 */
package nc.render;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import nc.network.PacketHandler;
import nc.network.render.BlockHighlightUpdatePacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockHighlightTracker {
    private final Long2LongMap highlightMap = new Long2LongOpenHashMap();

    public void highlightBlock(long posLong, long highlightTimeMillis) {
        this.highlightMap.put(posLong, System.currentTimeMillis() + highlightTimeMillis);
    }

    public Long2LongMap getHighlightMap() {
        return this.highlightMap;
    }

    public static void sendPacket(EntityPlayerMP player, BlockPos pos, long highlightTimeMillis) {
        PacketHandler.instance.sendTo((IMessage)new BlockHighlightUpdatePacket(pos, highlightTimeMillis), player);
    }

    public static void sendPacket(EntityPlayerMP player, long posLong, long highlightTimeMillis) {
        BlockHighlightTracker.sendPacket(player, BlockPos.func_177969_a((long)posLong), highlightTimeMillis);
    }

    public static void sendPacketToAll(BlockPos pos, long highlightTimeMillis) {
        PacketHandler.instance.sendToAll((IMessage)new BlockHighlightUpdatePacket(pos, highlightTimeMillis));
    }

    public static void sendPacketToAll(long posLong, long highlightTimeMillis) {
        BlockHighlightTracker.sendPacketToAll(BlockPos.func_177969_a((long)posLong), highlightTimeMillis);
    }
}

