/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.tile.ITile;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.tile.passive.ITilePassive;
import nc.util.EnergyHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.Interface(iface="mcjty.lib.api.power.IBigPower", modid="theoneprobe")
public interface ITileEnergy
extends ITile,
IBigPower {
    public EnergyStorage getEnergyStorage();

    public EnergyConnection[] getEnergyConnections();

    default public EnergyConnection getEnergyConnection(@Nonnull EnumFacing side) {
        return this.getEnergyConnections()[side.func_176745_a()];
    }

    default public void setEnergyConnection(@Nonnull EnergyConnection energyConnection, @Nonnull EnumFacing side) {
        this.getEnergyConnections()[side.func_176745_a()] = energyConnection;
    }

    default public void toggleEnergyConnection(@Nonnull EnumFacing side, @Nonnull EnergyConnection.Type type) {
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
        this.setEnergyConnection(this.getEnergyConnection(side).next(type), side);
        this.markDirtyAndNotify(true);
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    default public boolean canConnectEnergy(@Nonnull EnumFacing side) {
        return this.getEnergyConnection(side).canConnect();
    }

    @Nonnull
    public static EnergyConnection[] energyConnectionAll(@Nonnull EnergyConnection connection) {
        EnergyConnection[] array = new EnergyConnection[6];
        for (int i = 0; i < 6; ++i) {
            array[i] = connection;
        }
        return array;
    }

    default public boolean hasConfigurableEnergyConnections() {
        return false;
    }

    default public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored();
    }

    default public int getMaxEnergyStored() {
        return this.getEnergyStorage().getMaxEnergyStored();
    }

    default public boolean canReceiveEnergy(EnumFacing side) {
        return this.getEnergyConnection(side).canReceive();
    }

    default public boolean canExtractEnergy(EnumFacing side) {
        return this.getEnergyConnection(side).canExtract();
    }

    default public int receiveEnergy(int maxReceive, EnumFacing side, boolean simulate) {
        return this.canReceiveEnergy(side) ? this.getEnergyStorage().receiveEnergy(maxReceive, simulate) : 0;
    }

    default public int extractEnergy(int maxExtract, EnumFacing side, boolean simulate) {
        return this.canExtractEnergy(side) ? this.getEnergyStorage().extractEnergy(maxExtract, simulate) : 0;
    }

    public boolean getIC2Reg();

    public void setIC2Reg(boolean var1);

    @Optional.Method(modid="ic2")
    default public void addTileToENet() {
        if (!this.getTileWorld().field_72995_K && NCConfig.enable_ic2_eu && !this.getIC2Reg() && this instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.setIC2Reg(true);
        }
    }

    @Optional.Method(modid="ic2")
    default public void removeTileFromENet() {
        if (!this.getTileWorld().field_72995_K && this.getIC2Reg() && this instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.setIC2Reg(false);
        }
    }

    public int getSinkTier();

    public int getSourceTier();

    @Optional.Method(modid="ic2")
    default public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getEnergyConnection(side).canReceive();
    }

    @Optional.Method(modid="ic2")
    default public double getDemandedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSinkTier() + 3), (double)this.getEnergyStorage().receiveEnergy(this.getEnergyStorage().getMaxTransfer(), true) / (double)NCConfig.rf_per_eu);
    }

    @Optional.Method(modid="ic2")
    default public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int energyReceived = this.getEnergyStorage().receiveEnergy((int)((double)NCConfig.rf_per_eu * amount), true);
        this.getEnergyStorage().receiveEnergy(energyReceived, false);
        return amount - (double)energyReceived / (double)NCConfig.rf_per_eu;
    }

    @Optional.Method(modid="ic2")
    default public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getEnergyConnection(side).canExtract();
    }

    @Optional.Method(modid="ic2")
    default public double getOfferedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSourceTier() + 3), (double)this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxTransfer(), true) / (double)NCConfig.rf_per_eu);
    }

    @Optional.Method(modid="ic2")
    default public void drawEnergy(double amount) {
        this.getEnergyStorage().extractEnergy((int)((double)NCConfig.rf_per_eu * amount), false);
    }

    @Nonnull
    public EnergyTileWrapper[] getEnergySides();

    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT();

    @Nonnull
    default public EnergyTileWrapper getEnergySide(@Nonnull EnumFacing side) {
        return this.getEnergySides()[side.func_176745_a()];
    }

    @Nonnull
    default public EnergyTileWrapperGT getEnergySideGT(@Nonnull EnumFacing side) {
        return this.getEnergySidesGT()[side.func_176745_a()];
    }

    @Nonnull
    public static EnergyTileWrapper[] getDefaultEnergySides(@Nonnull ITileEnergy tile) {
        return new EnergyTileWrapper[]{new EnergyTileWrapper(tile, EnumFacing.DOWN), new EnergyTileWrapper(tile, EnumFacing.UP), new EnergyTileWrapper(tile, EnumFacing.NORTH), new EnergyTileWrapper(tile, EnumFacing.SOUTH), new EnergyTileWrapper(tile, EnumFacing.WEST), new EnergyTileWrapper(tile, EnumFacing.EAST)};
    }

    @Nonnull
    public static EnergyTileWrapperGT[] getDefaultEnergySidesGT(@Nonnull ITileEnergy tile) {
        return new EnergyTileWrapperGT[]{new EnergyTileWrapperGT(tile, EnumFacing.DOWN), new EnergyTileWrapperGT(tile, EnumFacing.UP), new EnergyTileWrapperGT(tile, EnumFacing.NORTH), new EnergyTileWrapperGT(tile, EnumFacing.SOUTH), new EnergyTileWrapperGT(tile, EnumFacing.WEST), new EnergyTileWrapperGT(tile, EnumFacing.EAST)};
    }

    default public void pushEnergy() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getEnergyStorage().getEnergyStored() <= 0) {
                return;
            }
            this.pushEnergyToSide(side);
        }
    }

    default public void pushEnergyToSide(@Nonnull EnumFacing side) {
        IEnergyContainer adjStorageGT;
        if (!this.getEnergyConnection(side).canExtract()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null) {
            return;
        }
        if (tile instanceof ITileEnergy && !((ITileEnergy)tile).getEnergyConnection(side.func_176734_d()).canReceive()) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushEnergyTo()) {
            return;
        }
        IEnergyStorage adjStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        if (adjStorage != null && this.getEnergyStorage().canExtract()) {
            this.getEnergyStorage().extractEnergy(adjStorage.receiveEnergy(this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxEnergyStored(), true), false), false);
            return;
        }
        if (this.getEnergyStorage().getEnergyStored() < NCConfig.rf_per_eu) {
            return;
        }
        if (ModCheck.ic2Loaded() && NCConfig.enable_ic2_eu && tile instanceof IEnergySink) {
            this.getEnergyStorage().extractEnergy((int)Math.round(((IEnergySink)tile).injectEnergy(side.func_176734_d(), (double)(this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxEnergyStored(), true) / NCConfig.rf_per_eu), (double)this.getSourceTier()) * (double)NCConfig.rf_per_eu), false);
            return;
        }
        if (NCConfig.enable_gtce_eu && ModCheck.gregtechLoaded() && (adjStorageGT = (IEnergyContainer)tile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, side.func_176734_d())) != null && this.getEnergyStorage().canExtract()) {
            int voltage = MathHelper.func_76125_a((int)(this.getEnergyStorage().getEnergyStored() / NCConfig.rf_per_eu), (int)1, (int)EnergyHelper.getMaxEUFromTier(this.getSourceTier()));
            this.getEnergyStorage().extractEnergy((int)Math.min((long)voltage * adjStorageGT.acceptEnergyFromNetwork(side.func_176734_d(), (long)voltage, 1L) * (long)NCConfig.rf_per_eu, Integer.MAX_VALUE), false);
            return;
        }
    }

    default public NBTTagCompound writeEnergy(NBTTagCompound nbt) {
        this.getEnergyStorage().writeToNBT(nbt, "energyStorage");
        return nbt;
    }

    default public void readEnergy(NBTTagCompound nbt) {
        this.getEnergyStorage().readFromNBT(nbt, "energyStorage");
    }

    default public NBTTagCompound writeEnergyConnections(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            nbt.func_74768_a("energyConnections" + i, this.getEnergyConnections()[i].ordinal());
        }
        return nbt;
    }

    default public void readEnergyConnections(NBTTagCompound nbt) {
        if (this.hasConfigurableEnergyConnections()) {
            for (int i = 0; i < 6; ++i) {
                if (!nbt.func_74764_b("energyConnections" + i)) continue;
                this.getEnergyConnections()[i] = EnergyConnection.values()[nbt.func_74762_e("energyConnections" + i)];
            }
        }
    }

    default public boolean hasEnergySideCapability(@Nullable EnumFacing side) {
        return side == null || this.getEnergyConnection(side).canConnect();
    }

    @Optional.Method(modid="theoneprobe")
    default public long getStoredPower() {
        return this.getEnergyStorage().getEnergyStoredLong();
    }

    @Optional.Method(modid="theoneprobe")
    default public long getCapacity() {
        return this.getEnergyStorage().getMaxEnergyStoredLong();
    }
}

