/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import javax.annotation.Nonnull;
import nc.tile.fluid.ITileFluid;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTileWrapper
implements IFluidHandler {
    public final ITileFluid tile;
    @Nonnull
    public final EnumFacing side;

    public FluidTileWrapper(ITileFluid tile, @Nonnull EnumFacing side) {
        this.tile = tile;
        this.side = side;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tile.getTankProperties(this.side);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = this.tile.fill(this.side, resource, doFill);
        this.tile.onWrapperFill(amount, doFill);
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack stack = this.tile.drain(this.side, resource, doDrain);
        this.tile.onWrapperDrain(stack, doDrain);
        return stack;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack stack = this.tile.drain(this.side, maxDrain, doDrain);
        this.tile.onWrapperDrain(stack, doDrain);
        return stack;
    }
}

