/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.passive;

import com.google.common.collect.Lists;
import gregtech.api.capability.GregtechCapabilities;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.passive.ITilePassive;
import nc.util.CapabilityHelper;
import nc.util.EnergyHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TilePassiveAbstract
extends TileEnergyFluidSidedInventory
implements ITilePassive {
    protected int tickCount;
    public boolean isActive;
    public boolean energyBool;
    public boolean itemBool;
    public boolean fluidBool;
    public final double energyRate;
    public final double itemRate;
    public final double fluidRate;
    public double energyBuffer;
    public double itemBuffer;
    public double fluidBuffer;
    public final IItemIngredient itemType;
    public final IFluidIngredient fluidType;
    private static final IItemIngredient ITEM_BACKUP = new ItemIngredient(new ItemStack(Items.field_151055_y));
    private static final IFluidIngredient FLUID_BACKUP = new FluidIngredient(new FluidStack(FluidRegistry.WATER, 1));

    public TilePassiveAbstract(String name, double energyRate) {
        this(name, ITEM_BACKUP, 0.0, energyRate, FLUID_BACKUP, 0.0);
    }

    public TilePassiveAbstract(String name, IItemIngredient itemType, double itemRate) {
        this(name, itemType, itemRate, 0.0, FLUID_BACKUP, 0.0);
    }

    public TilePassiveAbstract(String name, IFluidIngredient fluidType, double fluidRate) {
        this(name, ITEM_BACKUP, 0.0, 0.0, fluidType, fluidRate);
    }

    public TilePassiveAbstract(String name, IItemIngredient itemType, double itemRate, double energyRate) {
        this(name, itemType, itemRate, energyRate, FLUID_BACKUP, 0.0);
    }

    public TilePassiveAbstract(String name, double energyRate, IFluidIngredient fluidType, double fluidRate) {
        this(name, ITEM_BACKUP, 0.0, energyRate, fluidType, fluidRate);
    }

    public TilePassiveAbstract(String name, IItemIngredient itemType, double itemRate, IFluidIngredient fluidType, double fluidRate) {
        this(name, itemType, itemRate, 0.0, fluidType, fluidRate);
    }

    protected TilePassiveAbstract(String name, IItemIngredient itemType, double itemRate, double energyRate, IFluidIngredient fluidType, double fluidRate) {
        super(name, 1, itemRate > 0.0 ? ITileInventory.inventoryConnectionAll(ItemSorption.OUT) : (itemRate < 0.0 ? ITileInventory.inventoryConnectionAll(ItemSorption.IN) : ITileInventory.inventoryConnectionAll(ItemSorption.NON)), energyRate == 0.0 ? 1L : (long)MathHelper.func_76143_f((double)((double)Math.max(NCConfig.rf_per_eu, NCConfig.machine_update_rate) * Math.abs(energyRate))), energyRate == 0.0 ? 0 : MathHelper.func_76143_f((double)((double)Math.max(NCConfig.rf_per_eu, NCConfig.machine_update_rate) * Math.abs(energyRate))), energyRate > 0.0 ? ITileEnergy.energyConnectionAll(EnergyConnection.OUT) : (energyRate < 0.0 ? ITileEnergy.energyConnectionAll(EnergyConnection.IN) : ITileEnergy.energyConnectionAll(EnergyConnection.NON)), fluidRate == 0.0 ? 1 : MathHelper.func_76143_f((double)((double)(6 * NCConfig.machine_update_rate) * Math.abs(fluidRate))), Lists.newArrayList((Object[])new String[]{((FluidStack)fluidType.getStack()).getFluid().getName()}), fluidRate > 0.0 ? ITileFluid.fluidConnectionAll(TankSorption.OUT) : (fluidRate < 0.0 ? ITileFluid.fluidConnectionAll(TankSorption.IN) : ITileFluid.fluidConnectionAll(TankSorption.NON)));
        this.energyRate = energyRate;
        this.itemRate = itemRate;
        this.itemType = itemType;
        this.fluidRate = fluidRate;
        this.fluidType = fluidType;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasActive = this.isActive;
            boolean shouldUpdate = false;
            this.energyBool = this.changeEnergy(false);
            this.itemBool = this.changeStack(false);
            this.fluidBool = this.changeFluid(false);
            this.isActive = this.isRunning(this.energyBool, this.itemBool, this.fluidBool);
            if (wasActive != this.isActive) {
                shouldUpdate = true;
                this.setActivity(this.isActive);
            }
            if (this.tickCount == 0) {
                if (NCConfig.passive_push) {
                    if (this.itemRate > 0.0) {
                        this.pushStacks();
                    }
                    if (this.fluidRate > 0.0) {
                        this.pushFluid();
                    }
                }
                if (this.energyRate > 0.0) {
                    this.pushEnergy();
                }
            }
            this.tickCount();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickCount() {
        ++this.tickCount;
        this.tickCount %= NCConfig.machine_update_rate;
    }

    protected boolean changeEnergy(boolean simulateChange) {
        if (this.energyRate == 0.0) {
            return simulateChange;
        }
        this.energyBuffer += this.energyRate;
        int energyChange = (int)this.energyBuffer;
        this.energyBuffer -= (double)energyChange;
        if (this.energyRate > 0.0 && this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored()) {
            return false;
        }
        if (this.energyRate < 0.0 && this.getEnergyStorage().getEnergyStored() < Math.abs(energyChange)) {
            return false;
        }
        if (!simulateChange && energyChange != 0 && this.changeStack(true) && this.changeFluid(true)) {
            this.getEnergyStorage().changeEnergyStored(energyChange);
        }
        return true;
    }

    protected boolean changeStack(boolean simulateChange) {
        if (this.itemRate == 0.0) {
            return simulateChange;
        }
        this.itemBuffer += this.itemRate;
        int itemChange = (int)this.itemBuffer;
        this.itemBuffer -= (double)itemChange;
        if (!simulateChange && !this.itemType.match(this.getInventoryStacks().get(0), IngredientSorption.NEUTRAL).matches()) {
            this.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
        }
        if (this.itemRate > 0.0) {
            if (((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() + itemChange > this.func_70297_j_()) {
                return false;
            }
            if (!simulateChange && this.changeEnergy(true) && this.changeFluid(true)) {
                if (((ItemStack)this.getInventoryStacks().get(0)).func_190926_b()) {
                    this.getInventoryStacks().set(0, this.itemType.getStack());
                } else {
                    ((ItemStack)this.getInventoryStacks().get(0)).func_190917_f(itemChange);
                }
            }
            return true;
        }
        if (((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() < Math.abs(itemChange)) {
            return false;
        }
        if (!simulateChange && this.changeEnergy(true) && this.changeFluid(true)) {
            if (((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() > Math.abs(itemChange)) {
                ((ItemStack)this.getInventoryStacks().get(0)).func_190917_f(itemChange);
            } else if (((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() == Math.abs(itemChange)) {
                this.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
            }
        }
        return true;
    }

    protected boolean changeFluid(boolean simulateChange) {
        if (this.fluidRate == 0.0) {
            return simulateChange;
        }
        this.fluidBuffer += this.fluidRate;
        int fluidChange = (int)this.fluidBuffer;
        this.fluidBuffer -= (double)fluidChange;
        if (this.fluidRate > 0.0 && this.getTanks().get(0).getFluidAmount() >= this.getTanks().get(0).getCapacity()) {
            return false;
        }
        if (this.fluidRate < 0.0 && this.getTanks().get(0).getFluidAmount() < Math.abs(fluidChange)) {
            return false;
        }
        if (!simulateChange && this.changeEnergy(true) && this.changeStack(true)) {
            if (this.fluidRate > 0.0) {
                this.getTanks().get(0).changeFluidStored(((FluidStack)this.fluidType.getStack()).getFluid(), fluidChange);
            } else {
                this.getTanks().get(0).changeFluidAmount(fluidChange);
            }
        }
        return true;
    }

    protected boolean isRunning(boolean energy, boolean stack, boolean fluid) {
        if (this.energyRate == 0.0 && this.itemRate == 0.0 && this.fluidRate == 0.0) {
            return true;
        }
        if (this.energyRate >= 0.0) {
            if (this.itemRate >= 0.0) {
                if (this.fluidRate >= 0.0) {
                    return energy || stack || fluid;
                }
                return fluid;
            }
            if (this.fluidRate >= 0.0) {
                return stack;
            }
            return stack && fluid;
        }
        if (this.itemRate >= 0.0) {
            if (this.fluidRate >= 0.0) {
                return energy;
            }
            return energy && fluid;
        }
        if (this.fluidRate >= 0.0) {
            return energy && stack;
        }
        return energy && stack && fluid;
    }

    @Override
    public double getEnergyRate() {
        return this.energyRate;
    }

    @Override
    public double getItemRate() {
        return this.itemRate;
    }

    @Override
    public double getFluidRate() {
        return this.fluidRate;
    }

    @Override
    public boolean canPushEnergyTo() {
        return this.energyRate < 0.0;
    }

    @Override
    public boolean canPushItemsTo() {
        return this.itemRate < 0.0;
    }

    @Override
    public boolean canPushFluidsTo() {
        return this.fluidRate < 0.0;
    }

    @Override
    public int func_70297_j_() {
        return this.itemRate == 0.0 ? 1 : MathHelper.func_76143_f((double)((double)(6 * NCConfig.machine_update_rate) * Math.abs(this.itemRate)));
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.itemRate < 0.0 && super.func_180462_a(slot, stack, side) && this.itemType.match(stack, IngredientSorption.NEUTRAL).matches();
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return this.itemRate > 0.0 && super.func_180461_b(slot, stack, side);
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    @Override
    public int getSourceTier() {
        return EnergyHelper.getEUTier(this.energyRate);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74757_a("isRunning", this.isActive);
        nbt.func_74757_a("energyBool", this.energyBool);
        nbt.func_74757_a("itemBool", this.itemBool);
        nbt.func_74757_a("fluidBool", this.fluidBool);
        nbt.func_74780_a("energyBuffer", this.energyBuffer);
        nbt.func_74780_a("itemBuffer", this.itemBuffer);
        nbt.func_74780_a("fluidBuffer", this.fluidBuffer);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.isActive = nbt.func_74767_n("isRunning");
        this.energyBool = nbt.func_74767_n("energyBool");
        this.itemBool = nbt.func_74767_n("itemBool");
        this.fluidBool = nbt.func_74767_n("fluidBool");
        this.energyBuffer = nbt.func_74769_h("energyBuffer");
        this.itemBuffer = nbt.func_74769_h("itemBuffer");
        this.fluidBuffer = nbt.func_74769_h("fluidBuffer");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.getRadiationSource() != null;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyRate != 0.0 && this.hasEnergySideCapability(side);
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return NCConfig.enable_gtce_eu && this.energyRate != 0.0 && this.hasEnergySideCapability(side);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidRate != 0.0 && this.hasFluidSideCapability(side);
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            return NCConfig.enable_mek_gas && this.fluidRate != 0.0 && this.hasFluidSideCapability(side);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemRate != 0.0;
        }
        return this.hasCapabilityDefault(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)IRadiationSource.CAPABILITY_RADIATION_SOURCE.cast((Object)this.getRadiationSource());
        }
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.energyRate != 0.0 && this.hasEnergySideCapability(side)) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergySide(this.nonNullSide(side)));
            }
            return null;
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (NCConfig.enable_gtce_eu && this.energyRate != 0.0 && this.hasEnergySideCapability(side)) {
                return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this.getEnergySideGT(this.nonNullSide(side)));
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidRate != 0.0 && this.hasFluidSideCapability(side)) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidSide(this.nonNullSide(side)));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && this.fluidRate != 0.0 && this.hasFluidSideCapability(side)) {
                return (T)CapabilityHelper.GAS_HANDLER_CAPABILITY.cast((Object)this.getGasWrapper());
            }
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemRate != 0.0) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler(null));
            }
            return null;
        }
        return this.getCapabilityDefault(capability, side);
    }
}

