/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CollectionHelper {
    public static <T> List<T> asList(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> intersect(List<T> list, Collection<T> collection) {
        ArrayList<T> out = new ArrayList<T>();
        for (T t : list) {
            if (!collection.contains(t)) continue;
            out.add(t);
        }
        return out;
    }

    @SafeVarargs
    public static <T> List<T> intersect(List<T> first, List<T> ... rest) {
        List<Object> tList = new ArrayList<T>();
        tList.addAll(first);
        for (List<T> list : rest) {
            tList = CollectionHelper.intersect(tList, list);
        }
        return tList;
    }

    @SafeVarargs
    public static <T> List<T> union(List<T> first, List<T> ... rest) {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        set.addAll(first);
        for (List<T> list : rest) {
            set.addAll(list);
        }
        return new ArrayList(set);
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] first, T ... rest) {
        int totalLength = first.length + rest.length;
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        System.arraycopy(rest, 0, result, offset, rest.length);
        return result;
    }

    @SafeVarargs
    public static <T> List<T> concatenate(List<T> first, List<T> ... rest) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(first);
        for (List<T> list : rest) {
            result.addAll(list);
        }
        return result;
    }

    @SafeVarargs
    public static List<Object> concatGeneral(List<Object> first, List<Object> ... rest) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(first);
        for (List<Object> list : rest) {
            result.addAll(list);
        }
        return result;
    }

    @SafeVarargs
    public static IntList concatInt(List<? extends Integer> first, List<? extends Integer> ... rest) {
        IntArrayList result = new IntArrayList();
        result.addAll(first);
        for (List<? extends Integer> list : rest) {
            result.addAll(list);
        }
        return result;
    }

    @SafeVarargs
    public static DoubleList concatDouble(List<? extends Double> first, List<? extends Double> ... rest) {
        DoubleArrayList result = new DoubleArrayList();
        result.addAll(first);
        for (List<? extends Double> list : rest) {
            result.addAll(list);
        }
        return result;
    }

    @SafeVarargs
    public static LongList concatLong(List<? extends Long> first, List<? extends Long> ... rest) {
        LongArrayList result = new LongArrayList();
        result.addAll(first);
        for (List<? extends Long> list : rest) {
            result.addAll(list);
        }
        return result;
    }

    public static <T> Set<T> asSet(T[] array) {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (T t : array) {
            set.add(t);
        }
        return set;
    }

    public static <T> Set<T> intersect(Set<T> set1, Collection<T> set2) {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (T t : set1) {
            if (!set2.contains(t)) continue;
            set.add(t);
        }
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> intersect(Set<T> first, Set<T> ... rest) {
        Object tSet = new ObjectOpenHashSet();
        tSet.addAll(first);
        for (Set<T> set : rest) {
            tSet = CollectionHelper.intersect(tSet, set);
        }
        return tSet;
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> first, Set<T> ... rest) {
        ObjectOpenHashSet tSet = new ObjectOpenHashSet();
        tSet.addAll(first);
        for (Set<T> set : rest) {
            tSet.addAll(set);
        }
        return tSet;
    }

    public static <T> boolean isEmpty(T[][] arrays, int arrayNo) {
        if (arrays.length <= arrayNo) {
            return true;
        }
        return arrays[arrayNo].length == 0;
    }

    public static <T> boolean isNull(T[][] arrays, int arrayNo) {
        if (arrays.length <= arrayNo) {
            return false;
        }
        return arrays[arrayNo] == null;
    }

    public static int sum(int[] numberArray) {
        int result = 0;
        for (int element : numberArray) {
            result += element;
        }
        return result;
    }

    public static int sumIntList(IntList numberList) {
        int result = 0;
        IntListIterator intListIterator = numberList.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            result += i;
        }
        return result;
    }

    public static double sum(double[] numberArray) {
        double result = 0.0;
        for (double element : numberArray) {
            result += element;
        }
        return result;
    }

    public static double sumDoubleList(DoubleList numberList) {
        double result = 0.0;
        DoubleListIterator doubleListIterator = numberList.iterator();
        while (doubleListIterator.hasNext()) {
            double i = (Double)doubleListIterator.next();
            result += i;
        }
        return result;
    }

    public static IntList asIntegerList(int[] array) {
        IntArrayList list = new IntArrayList();
        for (int t : array) {
            list.add(t);
        }
        return list;
    }

    public static DoubleList asDoubleList(double[] array) {
        DoubleArrayList list = new DoubleArrayList();
        for (double t : array) {
            list.add(t);
        }
        return list;
    }

    public static FloatList asFloatList(float[] array) {
        FloatArrayList list = new FloatArrayList();
        for (float t : array) {
            list.add(t);
        }
        return list;
    }

    public static int[] asIntegerArray(IntList list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    public static double[] asDoubleArray(DoubleList list) {
        double[] array = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (Double)list.get(i);
        }
        return array;
    }

    public static float[] asFloatArray(FloatList list) {
        float[] array = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = ((Float)list.get(i)).floatValue();
        }
        return array;
    }

    public static String[] asStringArray(List<String> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static int[] increasingArray(int start, int length) {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = start + i;
        }
        return array;
    }

    public static int[] increasingArray(int length) {
        return CollectionHelper.increasingArray(0, length);
    }

    public static IntList increasingList(int start, int length) {
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < length; ++i) {
            list.add(start + i);
        }
        return list;
    }

    public static IntList increasingList(int length) {
        return CollectionHelper.increasingList(0, length);
    }

    public static boolean arrayXAND(boolean[] array, int ... i) {
        for (int j = 0; j < array.length; ++j) {
            boolean b = 2 * i.length > array.length;
            for (int k : i) {
                if (!(b ^ j == k)) continue;
                b = !b;
                break;
            }
            if (!(b ^ array[j])) continue;
            return false;
        }
        return true;
    }

    public static IntList nCopies(int n, int value) {
        return new IntArrayList(Collections.nCopies(n, value));
    }

    public static LongList nCopies(int n, long value) {
        return new LongArrayList(Collections.nCopies(n, value));
    }

    public static DoubleList nCopies(int n, double value) {
        return new DoubleArrayList(Collections.nCopies(n, value));
    }

    public static int[] arrayCopies(int n, int value) {
        return CollectionHelper.nCopies(n, value).toIntArray();
    }

    public static long[] arrayCopies(int n, long value) {
        return CollectionHelper.nCopies(n, value).toLongArray();
    }

    public static double[] arrayCopies(int n, double value) {
        return CollectionHelper.nCopies(n, value).toDoubleArray();
    }
}

