/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.MathHelper;

public class GuiHelper {
    public static int getScreenEdgeFromAngleX(ScaledResolution res, double angle) {
        int width = res.func_78326_a();
        if (angle >= 45.0 && angle <= 135.0) {
            return width;
        }
        if (angle >= 225.0 && angle <= 315.0) {
            return 0;
        }
        double radAngle = Math.toRadians(angle - 45.0);
        double cos = Math.cos(radAngle);
        double sin = Math.sin(radAngle);
        return (int)Math.round(0.5 * (double)width * (1.0 + cos * Math.abs(cos) + sin * Math.abs(sin)));
    }

    public static int getScreenEdgeFromAngleY(ScaledResolution res, double angle) {
        int height = res.func_78328_b();
        if (angle >= 315.0 || angle <= 45.0) {
            return 0;
        }
        if (angle >= 135.0 && angle <= 225.0) {
            return height;
        }
        double radAngle = Math.toRadians(angle - 45.0);
        double cos = Math.cos(radAngle);
        double sin = Math.sin(radAngle);
        return (int)Math.round(0.5 * (double)height * (1.0 - cos * Math.abs(cos) + sin * Math.abs(sin)));
    }

    public static int getRenderPositionX(ScaledResolution res, int edgeX, int width, int cushion) {
        return MathHelper.func_76125_a((int)edgeX, (int)cushion, (int)(res.func_78326_a() - width - cushion));
    }

    public static int getRenderPositionY(ScaledResolution res, int edgeY, int height, int cushion) {
        return MathHelper.func_76125_a((int)edgeY, (int)cushion, (int)(res.func_78328_b() - height - cushion));
    }

    public static int getRenderPositionXFromAngle(ScaledResolution res, double angle, int width, int cushion) {
        return MathHelper.func_76125_a((int)GuiHelper.getScreenEdgeFromAngleX(res, angle), (int)cushion, (int)(res.func_78326_a() - width - cushion));
    }

    public static int getRenderPositionYFromAngle(ScaledResolution res, double angle, int height, int cushion) {
        return MathHelper.func_76125_a((int)GuiHelper.getScreenEdgeFromAngleY(res, angle), (int)cushion, (int)(res.func_78328_b() - height - cushion));
    }
}

