/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.Arrays;
import java.util.List;
import nc.config.NCConfig;
import nc.util.CollectionHelper;
import nc.util.FontRenderHelper;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;

public class InfoHelper {
    public static final int MAXIMUM_TEXT_WIDTH = 225;
    public static final String SHIFT_STRING = Lang.localise("gui.nc.inventory.shift_for_info");
    public static final String CTRL_STRING = Lang.localise("gui.nc.inventory.ctrl_for_info");
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String[] NULL_ARRAY = new String[]{null};
    public static final String[][] EMPTY_ARRAYS = new String[0][];
    public static final String[][] NULL_ARRAYS = new String[][]{null};

    public static void infoLine(List<String> list, TextFormatting fixedColor, String line) {
        list.add(fixedColor + line);
    }

    public static void shiftInfo(List<String> list) {
        list.add(TextFormatting.ITALIC + (NCConfig.ctrl_info ? CTRL_STRING : SHIFT_STRING));
    }

    public static void fixedInfoList(List<String> list, boolean infoBelow, TextFormatting fixedColor, String ... fixedLines) {
        for (String fixedLine : fixedLines) {
            InfoHelper.infoLine(list, fixedColor, fixedLine);
        }
        if (infoBelow) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static void fixedInfoList(List<String> list, boolean infoBelow, TextFormatting[] fixedColors, String ... fixedLines) {
        for (int i = 0; i < fixedLines.length; ++i) {
            InfoHelper.infoLine(list, fixedColors[i], fixedLines[i]);
        }
        if (infoBelow) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static void infoList(List<String> list, TextFormatting infoColor, String ... lines) {
        for (String line : lines) {
            InfoHelper.infoLine(list, infoColor, line);
        }
    }

    public static void infoList(List<String> list, TextFormatting[] infoColors, String ... lines) {
        for (int i = 0; i < lines.length; ++i) {
            InfoHelper.infoLine(list, infoColors[i], lines[i]);
        }
    }

    public static void infoFull(List<String> list, TextFormatting fixedColor, String[] fixedLines, TextFormatting infoColor, String ... lines) {
        if (InfoHelper.showFixedInfo(fixedLines, lines)) {
            InfoHelper.fixedInfoList(list, !Arrays.equals(lines, EMPTY_ARRAY) && !Arrays.equals(lines, NULL_ARRAY), fixedColor, fixedLines);
        } else if (InfoHelper.showInfo(fixedLines, lines)) {
            InfoHelper.infoList(list, infoColor, lines);
        } else if (InfoHelper.showShiftInfo(fixedLines, lines)) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static void infoFull(List<String> list, TextFormatting fixedColor, String[] fixedLines, TextFormatting[] infoColors, String ... lines) {
        if (InfoHelper.showFixedInfo(fixedLines, lines)) {
            InfoHelper.fixedInfoList(list, !Arrays.equals(lines, EMPTY_ARRAY) && !Arrays.equals(lines, NULL_ARRAY), fixedColor, fixedLines);
        } else if (InfoHelper.showInfo(fixedLines, lines)) {
            InfoHelper.infoList(list, infoColors, lines);
        } else if (InfoHelper.showShiftInfo(fixedLines, lines)) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static void infoFull(List<String> list, TextFormatting[] fixedColors, String[] fixedLines, TextFormatting infoColor, String ... lines) {
        if (InfoHelper.showFixedInfo(fixedLines, lines)) {
            InfoHelper.fixedInfoList(list, !Arrays.equals(lines, EMPTY_ARRAY) && !Arrays.equals(lines, NULL_ARRAY), fixedColors, fixedLines);
        } else if (InfoHelper.showInfo(fixedLines, lines)) {
            InfoHelper.infoList(list, infoColor, lines);
        } else if (InfoHelper.showShiftInfo(fixedLines, lines)) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static void infoFull(List<String> list, TextFormatting[] fixedColors, String[] fixedLines, TextFormatting[] infoColors, String ... lines) {
        if (InfoHelper.showFixedInfo(fixedLines, lines)) {
            InfoHelper.fixedInfoList(list, !Arrays.equals(lines, EMPTY_ARRAY) && !Arrays.equals(lines, NULL_ARRAY), fixedColors, fixedLines);
        } else if (InfoHelper.showInfo(fixedLines, lines)) {
            InfoHelper.infoList(list, infoColors, lines);
        } else if (InfoHelper.showShiftInfo(fixedLines, lines)) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static boolean showFixedInfo(String[] fixedLines, String ... lines) {
        return !Arrays.equals(fixedLines, EMPTY_ARRAY) && !Arrays.equals(fixedLines, NULL_ARRAY) && (!NCUtil.isInfoKeyDown() || Arrays.equals(lines, EMPTY_ARRAY));
    }

    public static boolean showInfo(String[] fixedLines, String ... lines) {
        return (NCUtil.isInfoKeyDown() || lines.length == 1) && !Arrays.equals(lines, EMPTY_ARRAY) && !Arrays.equals(lines, NULL_ARRAY);
    }

    public static boolean showShiftInfo(String[] fixedLines, String ... lines) {
        return !Arrays.equals(lines, EMPTY_ARRAY) && !Arrays.equals(lines, NULL_ARRAY);
    }

    public static void infoFull(List<String> list, TextFormatting infoColor, String ... lines) {
        InfoHelper.infoFull(list, TextFormatting.AQUA, EMPTY_ARRAY, infoColor, lines);
    }

    public static void infoFull(List<String> list, TextFormatting[] infoColors, String ... lines) {
        InfoHelper.infoFull(list, new TextFormatting[0], EMPTY_ARRAY, infoColors, lines);
    }

    public static String[] formattedInfo(String tooltip, Object ... args) {
        return FontRenderHelper.wrapString(Lang.localise(tooltip, args), 225);
    }

    public static String[] buildFixedInfo(String unlocName, String ... tooltip) {
        if (tooltip.length == 0) {
            return InfoHelper.standardFixedInfo(unlocName, unlocName);
        }
        return tooltip;
    }

    public static String[] buildInfo(String unlocName, String ... tooltip) {
        if (tooltip.length == 0) {
            return InfoHelper.standardInfo(unlocName, unlocName);
        }
        return tooltip;
    }

    public static <T extends Enum<T>> String[] getEnumNames(Class<T> enumm) {
        Enum[] values = (Enum[])enumm.getEnumConstants();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = ((IStringSerializable)values[i]).func_176610_l();
        }
        return names;
    }

    public static <T extends Enum<T>> String[][] buildFixedInfo(String unlocNameBase, Class<T> enumm, String[] ... tooltips) {
        return InfoHelper.buildGeneralInfo(unlocNameBase, InfoHelper.getEnumNames(enumm), ".fixd", ".fix", tooltips);
    }

    public static String[][] buildFixedInfo(String unlocNameBase, String[] types, String[] ... tooltips) {
        return InfoHelper.buildGeneralInfo(unlocNameBase, types, ".fixd", ".fix", tooltips);
    }

    public static <T extends Enum<T>> String[][] buildInfo(String unlocNameBase, Class<T> enumm, String[] ... tooltips) {
        return InfoHelper.buildGeneralInfo(unlocNameBase, InfoHelper.getEnumNames(enumm), ".desc", ".des", tooltips);
    }

    public static String[][] buildInfo(String unlocNameBase, String[] names, String[] ... tooltips) {
        return InfoHelper.buildGeneralInfo(unlocNameBase, names, ".desc", ".des", tooltips);
    }

    public static String[][] buildGeneralInfo(String unlocNameBase, String[] types, String desc, String des, String[] ... tooltips) {
        String[][] strings = new String[types.length][];
        if (Arrays.equals((Object[])tooltips, (Object[])NULL_ARRAYS)) {
            for (int i = 0; i < types.length; ++i) {
                strings[i] = NULL_ARRAY;
            }
            return strings;
        }
        for (int i = 0; i < types.length; ++i) {
            strings[i] = CollectionHelper.isNull(tooltips, i) ? EMPTY_ARRAY : (CollectionHelper.isEmpty(tooltips, i) ? InfoHelper.standardGeneralInfo(unlocNameBase + "." + types[i], unlocNameBase, desc, des) : tooltips[i]);
        }
        return strings;
    }

    public static String[] standardFixedInfo(String unlocName, String generalName) {
        return InfoHelper.standardGeneralInfo(unlocName, generalName, ".fixd", ".fix");
    }

    public static String[] standardInfo(String unlocName, String generalName) {
        return InfoHelper.standardGeneralInfo(unlocName, generalName, ".desc", ".des");
    }

    public static String[] standardGeneralInfo(String unlocName, String generalName, String desc, String des) {
        for (String name : new String[]{unlocName, generalName}) {
            if (!Lang.canLocalise(name + desc)) continue;
            return InfoHelper.formattedInfo(name + desc, new Object[0]);
        }
        return InfoHelper.getNumberedInfo(unlocName + des);
    }

    public static String[] getNumberedInfo(String base) {
        String firstLine = base + 0;
        if (!Lang.canLocalise(firstLine)) {
            return EMPTY_ARRAY;
        }
        String[] info = new String[]{Lang.localise(firstLine)};
        int line = 1;
        while (Lang.canLocalise(base + line)) {
            info = CollectionHelper.concatenate(info, Lang.localise(base + line));
            ++line;
        }
        return info;
    }
}

