/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.decoration;

import java.util.Random;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BushGenerator
implements IWorldGenerator {
    protected final IBlockState bush;
    protected final int genSize;
    protected final int genRate;

    public BushGenerator(IBlockState bush, int genSize, int genRate) {
        this.bush = bush;
        this.genSize = genSize;
        this.genRate = genRate;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos chunkPos;
        if (this.shouldGenerate() && rand.nextInt(Math.max(1, NCMath.toInt(400.0 / (double)this.genRate))) == 0 && this.canGenerate(rand, world, chunkPos = new BlockPos(chunkX * 16 + 8, rand.nextInt(world.func_72800_K()), chunkZ * 16 + 8))) {
            this.generateBush(rand, world, chunkPos.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16)));
        }
    }

    public boolean shouldGenerate() {
        return this.genSize > 0 && this.genRate > 0;
    }

    public boolean canGenerate(Random rand, World world, BlockPos chunkPos) {
        return true;
    }

    public void generateBush(Random rand, World world, BlockPos sourcePos) {
        Block block = this.bush.func_177230_c();
        for (int i = 0; i < this.genSize; ++i) {
            boolean canBlockStay;
            int height = MathHelper.func_76125_a((int)(sourcePos.func_177956_o() + rand.nextInt(4) - rand.nextInt(4)), (int)1, (int)(world.func_72800_K() - 1));
            BlockPos genPos = new BlockPos(sourcePos.func_177958_n() + rand.nextInt(8) - rand.nextInt(8), height, sourcePos.func_177952_p() + rand.nextInt(8) - rand.nextInt(8));
            boolean bl = canBlockStay = block instanceof BlockBush ? ((BlockBush)block).func_180671_f(world, genPos, this.bush) : true;
            if (!world.func_175623_d(genPos) || world.field_73011_w.func_191066_m() && genPos.func_177956_o() >= world.func_72800_K() - 1 || !canBlockStay) continue;
            world.func_180501_a(genPos, this.bush, 2);
        }
    }
}

