/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.BakedAction;
import alexiil.mc.mod.load.baked.BakedConfig;
import alexiil.mc.mod.load.baked.BakedFactory;
import alexiil.mc.mod.load.baked.BakedRenderingPart;
import alexiil.mc.mod.load.baked.BakedVariable;
import alexiil.mc.mod.load.json.JsonAction;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.json.JsonFactory;
import alexiil.mc.mod.load.json.JsonRenderingPart;
import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionSignature;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.InternalCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import net.minecraft.util.ResourceLocation;

public class JsonConfig
extends JsonConfigurable<JsonConfig, BakedConfig> {
    public final JsonRenderingPart[] renders;
    public final String[][] functions;
    public final JsonFactory[] factories;
    public final JsonAction[] actions;
    public final JsonVariable[] constants;
    public final JsonVariable[] variables;

    public JsonConfig(JsonRenderingPart[] renders, String[][] functions, JsonFactory[] factories, JsonAction[] actions, JsonVariable[] constants, JsonVariable[] variables) {
        this.renders = renders;
        this.functions = functions;
        this.factories = factories;
        this.actions = actions;
        this.constants = constants;
        this.variables = variables;
    }

    public JsonConfig(JsonConfig parent, JsonRenderingPart[] renders, String[][] functions, JsonFactory[] factories, JsonAction[] actions, JsonVariable[] constants, JsonVariable[] variables) {
        this.renders = JsonConfig.consolidateArray(parent == null ? null : parent.renders, renders);
        this.functions = (String[][])JsonConfig.consolidateArray(parent == null ? null : parent.functions, functions);
        this.factories = JsonConfig.consolidateArray(parent == null ? null : parent.factories, factories);
        this.actions = JsonConfig.consolidateArray(parent == null ? null : parent.actions, actions);
        this.constants = JsonConfig.consolidateArray(parent == null ? null : parent.constants, constants);
        this.variables = JsonConfig.consolidateArray(parent == null ? null : parent.variables, variables);
    }

    @Override
    public void setLocation(ResourceLocation location) {
        super.setLocation(location);
        location = this.resourceLocation;
        for (JsonVariable jsonVariable : this.constants) {
            jsonVariable.setLocation(location);
        }
        for (JsonVariable jsonVariable : this.variables) {
            jsonVariable.setLocation(location);
        }
        for (JsonConfigurable jsonConfigurable : this.renders) {
            ((JsonRenderingPart)jsonConfigurable).setLocation(location);
        }
        for (JsonConfigurable jsonConfigurable : this.factories) {
            ((JsonFactory)jsonConfigurable).setLocation(location);
        }
        for (JsonConfigurable jsonConfigurable : this.actions) {
            jsonConfigurable.setLocation(location);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BakedConfig actuallyBake(FunctionContext context) throws InvalidExpressionException {
        void var5_16;
        BakedAction[] actions;
        for (JsonVariable jsonVariable : this.constants) {
            jsonVariable.bake(context);
        }
        context = new FunctionContext("User Functions", context);
        for (JsonVariable jsonVariable : this.functions) {
            FunctionSignature signature = FunctionSignature.parse((String)((Object)jsonVariable[0]));
            Object function = null;
            if (signature.func != null) {
                if (((JsonVariable)jsonVariable).length == 2) {
                    throw new InvalidExpressionException("Cannot provide two function implementations!");
                }
                function = signature.func;
            } else {
                function = jsonVariable[1];
            }
            String name = signature.name;
            context.putFunction(name, InternalCompiler.compileFunction((String)function, context, signature.args));
        }
        BakedVariable[] vars = new BakedVariable[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            vars[i] = (BakedVariable)this.variables[i].bake(context);
        }
        BakedRenderingPart[] array = new BakedRenderingPart[this.renders.length];
        for (int i = 0; i < this.renders.length; ++i) {
            JsonRenderingPart jsonRenderingPart = this.renders[i];
            array[i] = (BakedRenderingPart)jsonRenderingPart.bake(context);
        }
        if (this.actions == null || this.actions.length == 0) {
            actions = new BakedAction[]{};
        } else {
            void var5_13;
            actions = new BakedAction[this.actions.length];
            boolean bl = false;
            while (var5_13 < this.actions.length) {
                JsonAction ja = this.actions[var5_13];
                actions[var5_13] = (BakedAction)ja.bake(context);
                ++var5_13;
            }
        }
        if (this.factories == null || this.factories.length == 0) {
            BakedFactory[] bakedFactoryArray = new BakedFactory[]{};
        } else {
            BakedFactory[] bakedFactoryArray = new BakedFactory[this.factories.length];
            for (int i = 0; i < this.factories.length; ++i) {
                JsonFactory jf = this.factories[i];
                bakedFactoryArray[i] = (BakedFactory)jf.bake(context);
            }
        }
        return new BakedConfig(vars, array, actions, (BakedFactory[])var5_16);
    }
}

